/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.hsqldb.util.SqlToolError;

public class SqlFile {
    private static final int DEFAULT_HISTORY_SIZE = 20;
    private File file;
    private boolean interactive;
    private String primaryPrompt = "sql> ";
    private String chunkPrompt = "raw> ";
    private String contPrompt = "  +> ";
    private Connection curConn = null;
    private boolean htmlMode = false;
    private HashMap userVars = null;
    private String[] statementHistory = null;
    private boolean chunking = false;
    BooleanBucket possiblyUncommitteds = new BooleanBucket();
    private static final int SEP_LEN = 2;
    private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
    private static final String SPACES = "                                                                                                                                  ";
    private static String revnum = null;
    private static String BANNER;
    private static final String BUFFER_HELP_TEXT = "BUFFER Commands (only \":;\" is available for non-interactive use).\n    :?                Help\n    :;                Execute current buffer as an SQL Statement\n    :a[text]          Enter append mode with a copy of the buffer\n    :l                List current contents of buffer\n    :s/from/to        Substitute \"to\" for first occurrence of \"from\"\n    :s/from/to/[i;g2] Substitute \"to\" for occurrence(s) of \"from\"\n                from:  '$'s represent line breaks\n                to:    If empty, from's will be deleted (e.g. \":s/x//\").\n                       '$'s represent line breaks\n                       You can't use ';' in order to execute the SQL (use\n                       the ';' switch for this purpose, as explained below).\n                /:     Can actually be any character which occurs in\n                       neither \"to\" string nor \"from\" string.\n                SUBSTITUTION MODE SWITCHES:\n                       i:  case Insensitive\n                       ;:  execute immediately after substitution\n                       g:  Global (substitute ALL occurrences of \"from\" string)\n                       2:  Narrows substitution to specified buffer line number\n                           (Use any line number in place of '2').\n";
    private static final String HELP_TEXT = "SPECIAL Commands.\n* commands only available for interactive use.\nIn place of \"3\" below, you can use nothing for the previous command, or\nan integer \"X\" to indicate the Xth previous command.\nFilter substrings are cases-sensitive!  Use \"SCHEMANAME.\" to narrow schema.\n    \\?                   Help\n    \\p [line to print]   Print string to stdout\n    \\w file/path.sql     Append current buffer to file\n    \\i file/path.sql     Include/execute commands from external file\n    \\d{tvsiSanu*} [substr]  List objects of specified type:\n             Tbls/Views/Seqs/Indexes/SysTbls/Aliases/schemaNames/Users/all\n    \\d OBJECTNAME [subs] Describe table or view columns\n    \\o [file/path.html]  Tee (or stop teeing) query output to specified file\n    \\H                   Toggle HTML output mode\n    \\! COMMAND ARGS      Execute external program (no support for stdin)\n    \\c [true|false]      Continue upon errors (a.o.t. abort upon error)\n    \\a [true|false]      Auto-commit JDBC DML commands\n    \\b                   save next result to Binary buffer (no display)\n    \\bd file/path.bin    Dump Binary buffer to file\n    \\bl file/path.bin    Load file into Binary buffer\n    \\bp                  Use ? in next SQL statement to upload Bin. buffer\n    \\.                   Enter raw SQL.  End with line containing only \".\"\n    \\s                   * Show previous commands (i.e. SQL command history)\n    \\-[3]                * reload a command to buffer (for : commands)\n    \\-[3];               * reload command and execute (via \":;\")\n    \\q [abort message]   Quit (or end input like Ctrl-Z or Ctrl-D)\n";
    private static final String PL_HELP_TEXT = "PROCEDURAL LANGUAGE Commands.\n    *?                            Help\n    *                             Expand PL variables from now on.\n                                  (this is also implied by all the following).\n    * VARNAME = Variable value    Set variable value\n    * VARNAME =                   Unset variable\n    * VARNAME ~                   Set variable value to the value of the very\n                                  next SQL statement executed (see details\n                                  at the bottom of this listing).\n    * VARNAME _                   Same as * VARNAME _, except the query is\n                                  done silently (i.e, no rows to screen)\n    * list[value] [VARNAME1...]   List variable(s) (defaults to all)\n    * load VARNAME path.txt       Load variable value from text file\n    * dump VARNAME path.txt       Dump variable value to text file\n    * prepare VARNAME             Use ? in next SQL statement to upload val.\n    * foreach VARNAME ([val1...]) Repeat the following PL block with the\n                                  variable set to each value in turn.\n    * if (logical expr)           Execute following PL block only if expr true\n    * while (logical expr)        Repeat following PL block while expr true\n    * end foreach|if|while        Ends a PL block\n    * break [foreach|if|while|file] Exits a PL block or file early\n    * continue [foreach|while]    Exits a PL block iteration early\n\nUse PL variables (which you have set) like: *{VARNAME}.\nYou may use /VARNAME instead iff /VARNAME is the first word of a SQL command.\nUse PL variables in logical expressions like: *VARNAME.\n\n'* VARNAME ~' or '* VARNAME _' sets the variable value according to the very\nnext SQL statement (~ will echo the value, _ will do it silently):\n    Query:  The value of the first field of the first row returned.\n    other:  Return status of the command (for updates this will be\n            the number of rows updated).\n";
    public boolean recursed = false;
    private String curCommand = null;
    private int curLinenum = -1;
    private int curHist = -1;
    private PrintStream psStd = null;
    private PrintStream psErr = null;
    private PrintWriter pwQuery = null;
    StringBuffer stringBuffer = new StringBuffer();
    private boolean continueOnError = false;
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private BufferedReader br = null;
    private String charset = null;
    private boolean doPrepare = false;
    private String prepareVar = null;
    private static final char[] nonVarChars;
    public boolean plMode = false;
    private String fetchingVar = null;
    private boolean silentFetch = false;
    private boolean fetchBinary = false;
    private static final int DEFAULT_ELEMENT = 0;
    private static final int HSQLDB_ELEMENT = 1;
    private static final int ORACLE_ELEMENT = 2;
    private static final int[] listMDSchemaCols;
    private static final int[] listMDIndexCols;
    private static final int[][] listMDTableCols;
    private static final String[] oracleSysSchemas;
    private boolean excludeSysSchemas = false;
    private static final int COL_HEAD = 0;
    private static final int COL_ODD = 1;
    private static final int COL_EVEN = 2;
    private static final String PRE_TR;
    private static final String PRE_TD;
    byte[] binBuffer = null;
    private static final int JDBC3_BOOLEAN = 16;
    private static final int JDBC3_DATALINK = 70;

    public SqlFile(File file, boolean bl, HashMap hashMap) throws IOException {
        this.file = file;
        this.interactive = bl;
        this.userVars = hashMap;
        try {
            this.statementHistory = new String[this.interactive ? Integer.parseInt(System.getProperty("sqltool.historyLength")) : 1];
        }
        catch (Throwable throwable) {
            this.statementHistory = null;
        }
        if (this.statementHistory == null) {
            this.statementHistory = new String[20];
        }
        if (this.file != null && !this.file.canRead()) {
            throw new IOException("Can't read SQL file '" + this.file + "'");
        }
    }

    public SqlFile(boolean bl, HashMap hashMap) throws IOException {
        this(null, bl, hashMap);
    }

    public void execute(Connection connection, Boolean bl) throws IOException, SqlToolError, SQLException {
        this.execute(connection, System.out, System.err, bl);
    }

    public void execute(Connection connection, boolean bl) throws IOException, SqlToolError, SQLException {
        this.execute(connection, System.out, System.err, new Boolean(bl));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void execute(Connection connection, PrintStream printStream, PrintStream printStream2, Boolean bl) throws IOException, SqlToolError, SQLException {
        boolean bl2;
        block53: {
            String string;
            this.psStd = printStream;
            this.psErr = printStream2;
            this.curConn = connection;
            this.curLinenum = -1;
            boolean bl3 = false;
            bl2 = false;
            boolean bl4 = this.continueOnError = bl == null ? this.interactive : bl;
            if (this.userVars != null && this.userVars.size() > 0) {
                this.plMode = true;
            }
            this.charset = (string = System.getProperty("sqlfile.charset")) == null ? DEFAULT_CHARSET : string;
            try {
                try {
                    this.br = new BufferedReader(new InputStreamReader(this.file == null ? System.in : new FileInputStream(this.file), this.charset));
                    this.curLinenum = 0;
                    if (this.interactive) {
                        this.stdprintln(BANNER);
                    }
                    while (true) {
                        block52: {
                            int n;
                            String string2;
                            if (this.interactive) {
                                this.psStd.print(this.stringBuffer.length() == 0 ? (this.chunking ? this.chunkPrompt : this.primaryPrompt) : this.contPrompt);
                            }
                            if ((string2 = this.br.readLine()) == null) {
                                if (!this.interactive) break;
                                this.psStd.println();
                                break;
                            }
                            ++this.curLinenum;
                            if (this.chunking) {
                                if (string2.equals(".")) {
                                    this.chunking = false;
                                    this.setBuf(this.stringBuffer.toString());
                                    this.stringBuffer.setLength(0);
                                    if (!this.interactive) continue;
                                    this.stdprintln("Raw SQL chunk moved into buffer.  Run \":;\" to execute the chunk.");
                                    continue;
                                }
                                if (this.stringBuffer.length() > 0) {
                                    this.stringBuffer.append('\n');
                                }
                                this.stringBuffer.append(string2);
                                continue;
                            }
                            if (bl3) {
                                n = string2.indexOf("*/") + 2;
                                if (n <= 1) continue;
                                string2 = string2.substring(n);
                                this.stringBuffer.setLength(0);
                                bl3 = false;
                            }
                            String string3 = string2.trim();
                            try {
                                if (this.stringBuffer.length() == 0) {
                                    if (string3.startsWith("/*")) {
                                        n = string3.indexOf("*/", 2) + 2;
                                        if (n > 1) {
                                            string2 = string2.substring(n + string2.length() - string3.length());
                                            string3 = string2.trim();
                                        } else {
                                            this.stringBuffer.append("COMMENT");
                                            bl3 = true;
                                            continue;
                                        }
                                    }
                                    if (string3.length() == 0) continue;
                                    if (string3.charAt(0) == '*' && (string3.length() < 2 || string3.charAt(1) != '{')) {
                                        try {
                                            this.processPL(string3.length() == 1 ? "" : string3.substring(1).trim());
                                            continue;
                                        }
                                        catch (BadSpecial badSpecial) {
                                            this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + string2 + "\"\n" + badSpecial.getMessage());
                                            if (this.continueOnError) continue;
                                            throw new SqlToolError(badSpecial);
                                        }
                                    }
                                    if (string3.charAt(0) == '\\') {
                                        try {
                                            this.processSpecial(string3.substring(1));
                                            continue;
                                        }
                                        catch (BadSpecial badSpecial) {
                                            this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + string2 + "\"\n" + badSpecial.getMessage());
                                            if (this.continueOnError) continue;
                                            throw new SqlToolError(badSpecial);
                                        }
                                    }
                                    if (string3.charAt(0) == ':' && (this.interactive || string3.charAt(1) == ';')) {
                                        try {
                                            this.processBuffer(string3.substring(1));
                                            continue;
                                        }
                                        catch (BadSpecial badSpecial) {
                                            this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + string2 + "\"\n" + badSpecial.getMessage());
                                            if (this.continueOnError) continue;
                                            throw new SqlToolError(badSpecial);
                                        }
                                    }
                                    String string4 = string3.toUpperCase();
                                    if (string4.startsWith("DECLARE") || string4.startsWith("BEGIN")) {
                                        this.chunking = true;
                                        this.stringBuffer.append(string2);
                                        if (!this.interactive) continue;
                                        this.stdprintln("Enter RAW SQL.  No \\, :, * commands.  End with a line containing only \".\":");
                                        continue;
                                    }
                                }
                                if (string3.length() == 0) {
                                    if (!this.interactive || bl3) continue;
                                    this.setBuf(this.stringBuffer.toString());
                                    this.stringBuffer.setLength(0);
                                    this.stdprintln("Current input moved into buffer.");
                                    continue;
                                }
                                String string5 = SqlFile.deTerminated(string2);
                                if (!string3.equals(";")) {
                                    if (this.stringBuffer.length() > 0) {
                                        this.stringBuffer.append('\n');
                                    }
                                    this.stringBuffer.append(string5 == null ? string2 : string5);
                                }
                                if (string5 == null) continue;
                                this.curCommand = this.stringBuffer.toString();
                                String string6 = this.curCommand.trim();
                                if (string6.length() == 0) {
                                    throw new SQLException("Empty SQL Statement");
                                }
                                this.setBuf(this.curCommand);
                                this.processSQL();
                            }
                            catch (SQLException sQLException) {
                                this.errprintln("SQL Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + this.curCommand + "\"\n" + sQLException.getMessage());
                                if (!this.continueOnError) {
                                    throw sQLException;
                                }
                            }
                            catch (BreakException breakException) {
                                String string7 = breakException.getMessage();
                                if (!this.recursed && string7 != null && !string7.equals("file")) {
                                    this.errprintln("Unsatisfied break statement" + (string7 == null ? "" : " (type " + string7 + ')') + '.');
                                } else {
                                    bl2 = true;
                                }
                                if (this.recursed) throw breakException;
                                if (!this.continueOnError) {
                                    throw breakException;
                                }
                            }
                            catch (ContinueException continueException) {
                                String string8 = continueException.getMessage();
                                if (!this.recursed) {
                                    this.errprintln("Unsatisfied continue statement" + (string8 == null ? "" : " (type " + string8 + ')') + '.');
                                } else {
                                    bl2 = true;
                                }
                                if (this.recursed) throw continueException;
                                if (!this.continueOnError) {
                                    throw continueException;
                                }
                            }
                            catch (QuitNow quitNow) {
                                throw quitNow;
                            }
                            catch (SqlToolError sqlToolError) {
                                if (this.continueOnError) break block52;
                                throw sqlToolError;
                            }
                        }
                        this.stringBuffer.setLength(0);
                    }
                    if (bl3 || this.stringBuffer.length() != 0) {
                        this.errprintln("Unterminated input:  [" + this.stringBuffer + ']');
                        throw new SqlToolError("Unterminated input:  [" + this.stringBuffer + ']');
                    }
                    bl2 = true;
                }
                catch (QuitNow quitNow) {
                    boolean bl5 = bl2 = quitNow.getMessage() == null;
                    if (!this.recursed && !bl2) {
                        this.errprintln("Aborting: " + quitNow.getMessage());
                    }
                    if (this.recursed) throw quitNow;
                    if (!bl2) {
                        throw quitNow;
                    }
                    Object var19_26 = null;
                    this.closeQueryOutputStream();
                    if (this.fetchingVar != null) {
                        this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                        bl2 = false;
                    }
                    if (this.br != null) {
                        this.br.close();
                    }
                    if (bl2) return;
                    if (!this.possiblyUncommitteds.get()) return;
                    this.errprintln("Rolling back SQL transaction.");
                    this.curConn.rollback();
                    this.possiblyUncommitteds.set(false);
                    return;
                }
                Object var19_25 = null;
                this.closeQueryOutputStream();
                if (this.fetchingVar != null) {
                    this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                    bl2 = false;
                }
                if (this.br == null) break block53;
            }
            catch (Throwable throwable) {
                Object var19_27 = null;
                this.closeQueryOutputStream();
                if (this.fetchingVar != null) {
                    this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                    bl2 = false;
                }
                if (this.br != null) {
                    this.br.close();
                }
                if (bl2) throw throwable;
                if (!this.possiblyUncommitteds.get()) throw throwable;
                this.errprintln("Rolling back SQL transaction.");
                this.curConn.rollback();
                this.possiblyUncommitteds.set(false);
                throw throwable;
            }
            this.br.close();
        }
        if (bl2) return;
        if (!this.possiblyUncommitteds.get()) return;
        this.errprintln("Rolling back SQL transaction.");
        this.curConn.rollback();
        this.possiblyUncommitteds.set(false);
    }

    private static String deTerminated(String string) {
        int n = string.lastIndexOf(59);
        if (n < 0) {
            return null;
        }
        int n2 = n + 1;
        while (n2 < string.length()) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                return null;
            }
            ++n2;
        }
        return string.substring(0, n);
    }

    private void processBuffer(String string) throws BadSpecial, SQLException {
        boolean bl = false;
        int n = 105;
        String string2 = null;
        if (string.length() > 0) {
            n = string.charAt(0);
            string2 = string.substring(1);
            if (string2.trim().length() == 0) {
                string2 = null;
            }
        }
        switch (n) {
            case 59: {
                this.curCommand = this.commandFromHistory(0);
                this.stdprintln("Executing command from buffer:\n" + this.curCommand + '\n');
                this.processSQL();
                return;
            }
            case 65: 
            case 97: {
                this.stringBuffer.append(this.commandFromHistory(0));
                if (string2 != null) {
                    String string3 = SqlFile.deTerminated(string2);
                    if (!string2.equals(";")) {
                        this.stringBuffer.append(string3 == null ? string2 : string3);
                    }
                    if (string3 != null) {
                        this.curCommand = this.stringBuffer.toString();
                        this.setBuf(this.curCommand);
                        this.stdprintln("Executing:\n" + this.curCommand + '\n');
                        this.processSQL();
                        this.stringBuffer.setLength(0);
                        return;
                    }
                }
                this.stdprintln("Appending to:\n" + this.stringBuffer);
                return;
            }
            case 76: 
            case 108: {
                this.stdprintln("Current Buffer:\n" + this.commandFromHistory(0));
                return;
            }
            case 83: 
            case 115: {
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                int n2 = 0;
                try {
                    int n3;
                    int n4;
                    String string4 = this.commandFromHistory(0);
                    StringBuffer stringBuffer = new StringBuffer(string4);
                    if (string2 == null) {
                        throw new BadSwitch(0);
                    }
                    String string5 = string2.substring(0, 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, string5, true);
                    if (stringTokenizer.countTokens() < 4 || !stringTokenizer.nextToken().equals(string5)) {
                        throw new BadSwitch(1);
                    }
                    String string6 = stringTokenizer.nextToken().replace('$', '\n');
                    if (!stringTokenizer.nextToken().equals(string5)) {
                        throw new BadSwitch(2);
                    }
                    String string7 = stringTokenizer.nextToken().replace('$', '\n');
                    if (string7.equals(string5)) {
                        string7 = "";
                    } else if (stringTokenizer.countTokens() > 0 && !stringTokenizer.nextToken().equals(string5)) {
                        throw new BadSwitch(3);
                    }
                    if (stringTokenizer.countTokens() > 0) {
                        String string8 = stringTokenizer.nextToken("");
                        n4 = 0;
                        while (n4 < string8.length()) {
                            switch (string8.charAt(n4)) {
                                case 'i': {
                                    bl2 = true;
                                    break;
                                }
                                case ';': {
                                    bl4 = true;
                                    break;
                                }
                                case 'g': {
                                    bl3 = true;
                                    break;
                                }
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    n2 = Character.digit(string8.charAt(n4), 10);
                                    break;
                                }
                                default: {
                                    throw new BadSpecial("Unknown Substitution option: " + string8.charAt(n4));
                                }
                            }
                            ++n4;
                        }
                    }
                    if (bl2) {
                        string4 = string4.toUpperCase();
                        string6 = string6.toUpperCase();
                    }
                    int n5 = 0;
                    n4 = -1;
                    if (n2 > 0) {
                        n3 = 1;
                        while (n3 < n2) {
                            if ((n5 = string4.indexOf(10, n5) + 1) < 1) {
                                throw new BadSpecial("There are not " + n2 + " lines in the buffer.");
                            }
                            ++n3;
                        }
                        n4 = string4.indexOf(10, n5);
                    }
                    if (n4 < 0) {
                        n4 = string4.length();
                    }
                    if (bl3) {
                        n3 = n4;
                        while ((n3 = string4.lastIndexOf(string6, n3 - 1)) >= n5) {
                            stringBuffer.replace(n3, n3 + string6.length(), string7);
                        }
                    } else {
                        n3 = string4.indexOf(string6, n5);
                        if (n3 > -1 && n3 < n4) {
                            stringBuffer.replace(n3, n3 + string6.length(), string7);
                        }
                    }
                    this.curCommand = stringBuffer.toString();
                    this.setBuf(this.curCommand);
                    this.stdprintln((bl4 ? "Executing" : "Current Buffer") + ":\n" + this.curCommand);
                    if (bl4) {
                        this.stdprintln();
                    }
                }
                catch (BadSwitch badSwitch) {
                    throw new BadSpecial("Substitution syntax:  \":s/from this/to that/i;g2\".  Use '$' for line separations.  [" + badSwitch.getMessage() + ']');
                }
                if (bl4) {
                    this.processSQL();
                    this.stringBuffer.setLength(0);
                }
                return;
            }
            case 63: {
                this.stdprintln(BUFFER_HELP_TEXT);
                return;
            }
        }
        throw new BadSpecial("Unknown Buffer Command");
    }

    private void processSpecial(String string) throws BadSpecial, QuitNow, SQLException, SqlToolError {
        boolean bl = false;
        String string2 = null;
        if (string.length() < 1) {
            throw new BadSpecial("Null special command");
        }
        if (this.plMode) {
            string = this.dereference(string, false);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken("").trim();
        }
        switch (string3.charAt(0)) {
            case 'q': {
                if (string2 != null) {
                    throw new QuitNow(string2);
                }
                throw new QuitNow();
            }
            case 'H': {
                this.htmlMode = !this.htmlMode;
                this.stdprintln("HTML Mode is now set to: " + this.htmlMode);
                return;
            }
            case 'd': {
                if (string3.length() == 2) {
                    this.listTables(string3.charAt(1), string2);
                    return;
                }
                if (string3.length() == 1 && string2 != null) {
                    int n = string2.indexOf(32);
                    if (n < 0) {
                        this.describe(string2, null);
                    } else {
                        this.describe(string2.substring(0, n), string2.substring(n + 1).trim());
                    }
                    return;
                }
                throw new BadSpecial("Describe commands must be like '\\dX' or like '\\d OBJECTNAME'.");
            }
            case 'o': {
                if (string2 == null) {
                    if (this.pwQuery == null) {
                        throw new BadSpecial("There is no query output file to close");
                    }
                    this.closeQueryOutputStream();
                    return;
                }
                if (this.pwQuery != null) {
                    this.stdprintln("Closing current query output file and opening new one");
                    this.closeQueryOutputStream();
                }
                try {
                    this.pwQuery = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2, true), this.charset));
                    this.pwQuery.println((this.htmlMode ? "<HTML>\n<!--" : "#") + " " + new Date() + ".  Query output from " + this.getClass().getName() + (this.htmlMode ? ". -->\n\n<BODY>" : ".\n"));
                    this.pwQuery.flush();
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to write to file '" + string2 + "':  " + exception);
                }
                return;
            }
            case 'w': {
                if (string2 == null) {
                    throw new BadSpecial("You must supply a destination file name");
                }
                if (this.commandFromHistory(0).length() == 0) {
                    throw new BadSpecial("Empty command in buffer");
                }
                try {
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2, true), this.charset));
                    printWriter.println(this.commandFromHistory(0) + ';');
                    printWriter.flush();
                    printWriter.close();
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to append to file '" + string2 + "':  " + exception);
                }
                return;
            }
            case 'i': {
                if (string2 == null) {
                    throw new BadSpecial("You must supply an SQL file name");
                }
                try {
                    SqlFile sqlFile = new SqlFile(new File(string2), false, this.userVars);
                    sqlFile.recursed = true;
                    sqlFile.possiblyUncommitteds = this.possiblyUncommitteds;
                    sqlFile.plMode = this.plMode;
                    sqlFile.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException continueException) {
                    throw continueException;
                }
                catch (BreakException breakException) {
                    String string4 = breakException.getMessage();
                    if (string4 != null && !string4.equals("file")) {
                        throw breakException;
                    }
                }
                catch (QuitNow quitNow) {
                    throw quitNow;
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to execute SQL from file '" + string2 + "':  " + exception.getMessage());
                }
                return;
            }
            case 'p': {
                if (string2 == null) {
                    this.stdprintln(true);
                } else {
                    this.stdprintln(string2, true);
                }
                return;
            }
            case 'a': {
                if (string2 != null) {
                    this.curConn.setAutoCommit(Boolean.valueOf(string2));
                }
                this.stdprintln("Auto-commit is set to: " + this.curConn.getAutoCommit());
                return;
            }
            case 'b': {
                if (string3.length() == 1) {
                    this.fetchBinary = true;
                    return;
                }
                if (string3.charAt(1) == 'p') {
                    this.doPrepare = true;
                    return;
                }
                if (string3.charAt(1) != 'd' && string3.charAt(1) != 'l' || string2 == null) {
                    throw new BadSpecial("Malformatted binary command");
                }
                File file = new File(string2);
                try {
                    if (string3.charAt(1) == 'd') {
                        this.dump(file);
                    } else {
                        this.load(file);
                    }
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to load/dump binary  data to file '" + string2 + "'");
                }
                return;
            }
            case '*': 
            case 'c': {
                if (string2 != null) {
                    this.continueOnError = Boolean.valueOf(string2);
                }
                this.stdprintln("Continue-on-error is set to: " + this.continueOnError);
                return;
            }
            case 's': {
                this.showHistory();
                return;
            }
            case '-': {
                String string5;
                boolean bl2;
                int n = 0;
                boolean bl3 = bl2 = string3.charAt(string3.length() - 1) == ';';
                if (bl2) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                String string6 = string5 = string3.length() == 1 ? null : string3.substring(1, string3.length());
                if (string5 == null) {
                    n = 0;
                } else {
                    try {
                        n = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new BadSpecial("Malformatted command number");
                    }
                }
                this.setBuf(this.commandFromHistory(n));
                if (bl2) {
                    this.processBuffer(";");
                } else {
                    this.stdprintln("RESTORED following command to buffer.  Enter \":?\" to see buffer commands:\n" + this.commandFromHistory(0));
                }
                return;
            }
            case '?': {
                this.stdprintln(HELP_TEXT);
                return;
            }
            case '!': {
                byte[] byArray = new byte[1024];
                String string7 = (string3.length() == 1 ? "" : string3.substring(1)) + (string3.length() > 1 && string2 != null ? " " : "") + (string2 == null ? "" : string2);
                try {
                    int n;
                    Process process = Runtime.getRuntime().exec(string7);
                    process.getOutputStream().close();
                    InputStream inputStream = process.getInputStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        this.stdprint(new String(byArray, 0, n));
                    }
                    inputStream.close();
                    inputStream = process.getErrorStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        this.errprint(new String(byArray, 0, n));
                    }
                    inputStream.close();
                    if (process.waitFor() != 0) {
                        throw new BadSpecial("External command failed: '" + string7 + "'");
                    }
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to execute command '" + string7 + "':  " + exception);
                }
                return;
            }
            case '.': {
                this.chunking = true;
                if (this.interactive) {
                    this.stdprintln("Enter RAW SQL.  No \\, :, * commands.  End with a line containing only \".\":");
                }
                return;
            }
        }
        throw new BadSpecial("Unknown Special Command");
    }

    static int pastName(String string, int n) {
        String string2 = string.substring(n);
        int n2 = string.length();
        int n3 = 0;
        while (n3 < nonVarChars.length) {
            int n4 = string2.indexOf(nonVarChars[n3]);
            if (n4 > -1 && n4 < n2) {
                n2 = n4;
            }
            ++n3;
        }
        return n + n2;
    }

    private String dereference(String string, boolean bl) throws SQLException {
        String string2;
        int n;
        String string3;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl && string.trim().charAt(0) == '/') {
            int n3 = string.indexOf(47);
            n2 = SqlFile.pastName(string.substring(n3 + 1), 0);
            if (n2 < 1) {
                throw new SQLException("Malformed PL alias use");
            }
            string3 = string.substring(n3 + 1, n3 + 1 + n2);
            String string4 = (String)this.userVars.get(string3);
            if (string4 == null) {
                throw new SQLException("Undefined PL variable:  " + string3);
            }
            stringBuffer.replace(n3, n3 + 1 + n2, (String)this.userVars.get(string3));
        }
        while ((n = (string2 = stringBuffer.toString()).indexOf("*{")) >= 0) {
            n2 = string2.indexOf(125, n + 2);
            if (n2 == n + 2) {
                throw new SQLException("Empty PL variable name");
            }
            if (n2 < 0) {
                throw new SQLException("Unterminated PL variable name");
            }
            string3 = string2.substring(n + 2, n2);
            if (!this.userVars.containsKey(string3)) {
                throw new SQLException("Use of undefined PL variable: " + string3);
            }
            stringBuffer.replace(n, n2 + 1, (String)this.userVars.get(string3));
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processPL(String string) throws BadSpecial, SqlToolError, SQLException {
        if (string.length() < 1) {
            this.plMode = true;
            this.stdprintln("PL variable expansion mode is now on");
            return;
        }
        if (string.charAt(0) == '?') {
            this.stdprintln(PL_HELP_TEXT);
            return;
        }
        if (this.plMode) {
            string = this.dereference(string, false);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        String[] stringArray = null;
        this.plMode = true;
        if (this.userVars == null) {
            this.userVars = new HashMap();
        }
        if (string2.equals("end")) {
            throw new BadSpecial("PL end statements may only occur inside of a PL block");
        }
        if (string2.equals("continue")) {
            if (!stringTokenizer.hasMoreTokens()) throw new ContinueException();
            String string3 = stringTokenizer.nextToken("").trim();
            if (!string3.equals("foreach") && !string3.equals("while")) throw new BadSpecial("Bad continue statement.You may use no argument or one of 'foreach', 'while'");
            throw new ContinueException(string3);
        }
        if (string2.equals("break")) {
            if (!stringTokenizer.hasMoreTokens()) throw new BreakException();
            String string4 = stringTokenizer.nextToken("").trim();
            if (!string4.equals("foreach") && !string4.equals("if") && !string4.equals("while") && !string4.equals("file")) throw new BadSpecial("Bad break statement.You may use no argument or one of 'foreach', 'if', 'while', 'file'");
            throw new BreakException(string4);
        }
        if (string2.equals("list") || string2.equals("listvalue")) {
            boolean bl = string2.equals("listvalue");
            if (stringTokenizer.countTokens() == 0) {
                this.stdprint(SqlFile.formatNicely(this.userVars, bl));
                return;
            } else {
                stringArray = SqlFile.getTokenArray(stringTokenizer.nextToken(""));
                if (bl) {
                    this.stdprintln("The outermost parentheses are not part of the values.");
                } else {
                    this.stdprintln("Showing variable names and length of values (use 'listvalue' to see values).");
                }
                int n = 0;
                while (n < stringArray.length) {
                    String string5 = (String)this.userVars.get(stringArray[n]);
                    this.stdprintln("    " + stringArray[n] + ": " + (bl ? "(" + string5 + ')' : Integer.toString(string5.length())));
                    ++n;
                }
            }
            return;
        }
        if (string2.equals("dump") || string2.equals("load")) {
            if (stringTokenizer.countTokens() != 2) {
                throw new BadSpecial("Malformatted PL dump/load command");
            }
            String string6 = stringTokenizer.nextToken();
            File file = new File(stringTokenizer.nextToken());
            try {
                if (string2.equals("dump")) {
                    this.dump(string6, file);
                    return;
                } else {
                    this.load(string6, file);
                }
                return;
            }
            catch (Exception exception) {
                throw new BadSpecial("Failed to dump/load variable '" + string6 + "' to file '" + file + "'");
            }
        }
        if (string2.equals("prepare")) {
            if (stringTokenizer.countTokens() != 1) {
                throw new BadSpecial("Malformatted prepare command");
            }
            String string7 = stringTokenizer.nextToken();
            if (this.userVars.get(string7) == null) {
                throw new SQLException("Use of unset PL variable: " + string7);
            }
            this.prepareVar = string7;
            this.doPrepare = true;
            return;
        }
        if (string2.equals("foreach")) {
            if (stringTokenizer.countTokens() < 2) {
                throw new BadSpecial("Malformatted PL foreach command (1)");
            }
            String string8 = stringTokenizer.nextToken();
            String string9 = stringTokenizer.nextToken("").trim();
            if (string9.length() < 2 || string9.charAt(0) != '(' || string9.charAt(string9.length() - 1) != ')') {
                throw new BadSpecial("Malformatted PL foreach command (2)");
            }
            String[] stringArray2 = SqlFile.getTokenArray(string9.substring(1, string9.length() - 1));
            File file = null;
            try {
                file = this.plBlockFile("foreach");
            }
            catch (IOException iOException) {
                throw new BadSpecial("Failed to write given PL block temp file: " + iOException);
            }
            String string10 = (String)this.userVars.get(string8);
            try {
                int n = 0;
                while (n < stringArray2.length) {
                    block74: {
                        try {
                            String string11 = stringArray2[n];
                            this.userVars.put(string8, string11);
                            SqlFile sqlFile = new SqlFile(file, false, this.userVars);
                            sqlFile.plMode = true;
                            sqlFile.recursed = true;
                            sqlFile.possiblyUncommitteds = this.possiblyUncommitteds;
                            sqlFile.execute(this.curConn, this.continueOnError);
                        }
                        catch (ContinueException continueException) {
                            String string12 = continueException.getMessage();
                            if (string12 == null || string12.equals("foreach")) break block74;
                            throw continueException;
                        }
                    }
                    ++n;
                }
            }
            catch (BreakException breakException) {
                String string13 = breakException.getMessage();
                if (string13 != null && !string13.equals("foreach")) {
                    throw breakException;
                }
            }
            catch (QuitNow quitNow) {
                throw quitNow;
            }
            catch (Exception exception) {
                throw new BadSpecial("Failed to execute SQL from PL block.  " + exception.getMessage());
            }
            if (string10 == null) {
                this.userVars.remove(string8);
            } else {
                this.userVars.put(string8, string10);
            }
            if (file == null || file.delete()) return;
            throw new BadSpecial("Error occurred while trying to remove temp file '" + file + "'");
        }
        if (string2.equals("if")) {
            if (stringTokenizer.countTokens() < 1) {
                throw new BadSpecial("Malformatted PL if command (1)");
            }
            String string14 = stringTokenizer.nextToken("").trim();
            if (string14.length() < 2 || string14.charAt(0) != '(' || string14.charAt(string14.length() - 1) != ')') {
                throw new BadSpecial("Malformatted PL if command (2)");
            }
            String[] stringArray3 = SqlFile.getTokenArray(string14.substring(1, string14.length() - 1));
            File file = null;
            try {
                file = this.plBlockFile("if");
            }
            catch (IOException iOException) {
                throw new BadSpecial("Failed to write given PL block temp file: " + iOException);
            }
            try {
                if (this.eval(stringArray3)) {
                    SqlFile sqlFile = new SqlFile(file, false, this.userVars);
                    sqlFile.plMode = true;
                    sqlFile.recursed = true;
                    sqlFile.possiblyUncommitteds = this.possiblyUncommitteds;
                    sqlFile.execute(this.curConn, this.continueOnError);
                }
            }
            catch (BreakException breakException) {
                String string15 = breakException.getMessage();
                if (string15 == null || !string15.equals("if")) {
                    throw breakException;
                }
            }
            catch (ContinueException continueException) {
                throw continueException;
            }
            catch (QuitNow quitNow) {
                throw quitNow;
            }
            catch (BadSpecial badSpecial) {
                throw new BadSpecial("Malformatted PL if command (3): " + badSpecial);
            }
            catch (Exception exception) {
                throw new BadSpecial("Failed to execute SQL from PL block.  " + exception.getMessage());
            }
            if (file == null || file.delete()) return;
            throw new BadSpecial("Error occurred while trying to remove temp file '" + file + "'");
        }
        if (string2.equals("while")) {
            if (stringTokenizer.countTokens() < 1) {
                throw new BadSpecial("Malformatted PL while command (1)");
            }
            String string16 = stringTokenizer.nextToken("").trim();
            if (string16.length() < 2 || string16.charAt(0) != '(' || string16.charAt(string16.length() - 1) != ')') {
                throw new BadSpecial("Malformatted PL while command (2)");
            }
            String[] stringArray4 = SqlFile.getTokenArray(string16.substring(1, string16.length() - 1));
            File file = null;
            try {
                file = this.plBlockFile("while");
            }
            catch (IOException iOException) {
                throw new BadSpecial("Failed to write given PL block temp file: " + iOException);
            }
            while (true) {
                try {
                    if (!this.eval(stringArray4)) break;
                    try {
                        SqlFile sqlFile = new SqlFile(file, false, this.userVars);
                        sqlFile.recursed = true;
                        sqlFile.possiblyUncommitteds = this.possiblyUncommitteds;
                        sqlFile.plMode = true;
                        sqlFile.execute(this.curConn, this.continueOnError);
                        continue;
                    }
                    catch (ContinueException continueException) {
                        String string17 = continueException.getMessage();
                        if (string17 != null && !string17.equals("while")) throw continueException;
                        continue;
                    }
                }
                catch (BreakException breakException) {
                    String string18 = breakException.getMessage();
                    if (string18 == null || string18.equals("while")) break;
                    throw breakException;
                }
                catch (QuitNow quitNow) {
                    throw quitNow;
                }
                catch (BadSpecial badSpecial) {
                    throw new BadSpecial("Malformatted PL while command (3): " + badSpecial);
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to execute SQL from PL block.  " + exception.getMessage());
                }
                break;
            }
            if (file == null || file.delete()) return;
            throw new BadSpecial("Error occurred while trying to remove temp file '" + file + "'");
        }
        stringTokenizer = null;
        int n = SqlFile.pastName(string, 0);
        int n2 = string.length();
        String string19 = string.substring(0, n);
        while (n + 1 < n2 && (string.charAt(n) == ' ' || string.charAt(n) == '\t')) {
            ++n;
        }
        if (n + 1 > n2) {
            throw new BadSpecial("Unterminated PL variable definition");
        }
        char c = string.charAt(n);
        String string20 = string.substring(n + 1);
        switch (string.charAt(n)) {
            case '_': {
                this.silentFetch = true;
            }
            case '~': {
                if (string20.length() > 0) {
                    throw new BadSpecial("PL ~/_ set commands take no other args");
                }
                this.userVars.remove(string19);
                this.fetchingVar = string19;
                return;
            }
            case '=': {
                if (this.fetchingVar != null && this.fetchingVar.equals(string19)) {
                    this.fetchingVar = null;
                }
                if (string20.length() > 0) {
                    this.userVars.put(string19, string.substring(n + 1).trim());
                    return;
                } else {
                    this.userVars.remove(string19);
                }
                return;
            }
        }
        throw new BadSpecial("Unknown PL command (3)");
    }

    private File plBlockFile(String string) throws IOException, SqlToolError {
        int n = 1;
        if (string == null || !string.equals("foreach") && !string.equals("if") && !string.equals("while")) {
            throw new RuntimeException("Assertion failed.  Unsupported PL block type:  " + string);
        }
        File file = File.createTempFile("sqltool-", ".sql");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset));
        printWriter.println("/* " + new Date() + ". " + this.getClass().getName() + " PL block. */\n");
        while (true) {
            String string2;
            if ((string2 = this.br.readLine()) == null) {
                this.errprintln("Unterminated '" + string + "' PL block");
                throw new SqlToolError("Unterminated '" + string + "' PL block");
            }
            ++this.curLinenum;
            if (string2.trim().length() > 1 && string2.trim().charAt(0) == '*') {
                StringTokenizer stringTokenizer = new StringTokenizer(string2.trim().substring(1));
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(string)) {
                    ++n;
                } else if (string3.equals("end")) {
                    if (stringTokenizer.countTokens() < 1) {
                        this.errprintln("PL end statement requires arg of 'foreach' or 'if' or 'while' (1)");
                        throw new SqlToolError("PL end statement requires arg  of 'foreach' or 'if' or 'while' (1)");
                    }
                    String string4 = stringTokenizer.nextToken();
                    if (string4.equals(string) && --n < 1) break;
                    if (!(string4.equals("foreach") || string4.equals("if") || string4.equals("while"))) {
                        this.errprintln("PL end statement requires arg of 'foreach' or 'if' or 'while' (2)");
                        throw new SqlToolError("PL end statement requires arg of 'foreach' or 'if' or 'while' (2)");
                    }
                }
            }
            printWriter.println(string2);
        }
        printWriter.flush();
        printWriter.close();
        return file;
    }

    private void stdprintln() {
        this.stdprintln(false);
    }

    private void stdprint(String string) {
        this.stdprint(string, false);
    }

    private void stdprintln(String string) {
        this.stdprintln(string, false);
    }

    private void stdprintln(boolean bl) {
        if (this.htmlMode) {
            this.psStd.println("<BR>");
        } else {
            this.psStd.println();
        }
        if (bl && this.pwQuery != null) {
            if (this.htmlMode) {
                this.pwQuery.println("<BR>");
            } else {
                this.pwQuery.println();
            }
            this.pwQuery.flush();
        }
    }

    private void errprint(String string) {
        this.psErr.print(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + string + "</DIV>" : string);
    }

    private void errprintln(String string) {
        this.psErr.println(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + string + "</DIV>" : string);
    }

    private void stdprint(String string, boolean bl) {
        this.psStd.print(this.htmlMode ? "<P>" + string + "</P>" : string);
        if (bl && this.pwQuery != null) {
            this.pwQuery.print(this.htmlMode ? "<P>" + string + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    private void stdprintln(String string, boolean bl) {
        this.psStd.println(this.htmlMode ? "<P>" + string + "</P>" : string);
        if (bl && this.pwQuery != null) {
            this.pwQuery.println(this.htmlMode ? "<P>" + string + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listTables(char var1_1, String var2_2) throws BadSpecial {
        block45: {
            block44: {
                block43: {
                    var3_3 = null;
                    var4_4 = null;
                    var5_5 = null;
                    var6_6 = null;
                    var7_7 = null;
                    var8_8 = null;
                    var9_9 = "";
                    var10_10 = var2_2;
                    try {
                        try {
                            var11_11 = this.curConn.getMetaData();
                            var12_13 = var11_11.getDatabaseProductName();
                            var13_15 = null;
                            var5_5 = new String[1];
                            switch (var1_1) {
                                case '*': {
                                    var5_5 = null;
                                    break;
                                }
                                case 'S': {
                                    if (var12_13.indexOf("Oracle") > -1) {
                                        System.err.println("*** WARNING:\n*** Listing tables in system-supplied schemas since\n*** Oracle(TM) doesn't return a JDBC system table list.");
                                        var5_5[0] = "TABLE";
                                        var3_3 = "SYS";
                                        var6_6 = SqlFile.oracleSysSchemas;
                                        break;
                                    }
                                    var5_5[0] = "SYSTEM TABLE";
                                    break;
                                }
                                case 's': {
                                    if (var12_13.indexOf("HSQL") > -1) {
                                        if (var10_10 != null && var10_10.charAt(var10_10.length() - 1) == '.') {
                                            var9_9 = "\nWHERE sequence_schema = '" + var10_10.substring(0, var10_10.length() - 1) + "'";
                                            var10_10 = null;
                                        }
                                        var7_7 = this.curConn.createStatement();
                                        var7_7.execute("SELECT sequence_schema, sequence_name FROM information_schema.system_sequences" + var9_9);
                                        break;
                                    }
                                    var5_5[0] = "SEQUENCE";
                                    break;
                                }
                                case 'u': {
                                    if (var12_13.indexOf("HSQL") > -1) {
                                        var7_7 = this.curConn.createStatement();
                                        var7_7.execute("SELECT user, admin FROM information_schema.system_users\nORDER BY user");
                                        break;
                                    }
                                    if (var12_13.indexOf("Oracle") > -1) {
                                        var7_7 = this.curConn.createStatement();
                                        var7_7.execute("SELECT username, created FROM all_users ORDER BY username");
                                        break;
                                    }
                                    if (var12_13.indexOf("PostgreSQL") <= -1) throw new BadSpecial("SqlFile does not yet support \\du for your database vendor");
                                    var7_7 = this.curConn.createStatement();
                                    var7_7.execute("SELECT usename, usesuper FROM pg_catalog.pg_user ORDER BY usename");
                                    break;
                                }
                                case 'a': {
                                    if (var12_13.indexOf("HSQL") > -1) {
                                        if (var10_10 != null && var10_10.charAt(var10_10.length() - 1) == '.') {
                                            var9_9 = "\nWHERE alias_schem = '" + var10_10.substring(0, var10_10.length() - 1) + "'";
                                            var10_10 = null;
                                        }
                                        var7_7 = this.curConn.createStatement();
                                        var7_7.execute("SELECT alias_schem, alias FROM information_schema.system_aliases" + var9_9);
                                        break;
                                    }
                                    var5_5[0] = "ALIAS";
                                    break;
                                }
                                case 't': {
                                    this.excludeSysSchemas = var12_13.indexOf("Oracle") > -1;
                                    var5_5[0] = "TABLE";
                                    break;
                                }
                                case 'v': {
                                    var5_5[0] = "VIEW";
                                    break;
                                }
                                case 'n': {
                                    var8_8 = var11_11.getSchemas();
                                    if (var8_8 == null) {
                                        throw new BadSpecial("Failed to get metadata from database");
                                    }
                                    this.displayResultSet(null, var8_8, SqlFile.listMDSchemaCols, var10_10);
                                    var17_16 = null;
                                    this.excludeSysSchemas = false;
                                    if (var8_8 != null) {
                                        var8_8 = null;
                                    }
                                    if (var7_7 == null) return;
                                    break block43;
                                }
                                case 'i': {
                                    var3_3 = null;
                                    var14_24 = null;
                                    if (var10_10 != null) {
                                        var15_25 = var10_10.indexOf(46);
                                        v0 = var3_3 = var15_25 > 0 ? var10_10.substring(0, var15_25) : null;
                                        if (var15_25 < var10_10.length() - 1) {
                                            var14_24 = var15_25 > 0 ? var10_10.substring(var15_25 + 1) : var10_10;
                                        }
                                        var10_10 = null;
                                    }
                                    if ((var8_8 = var11_11.getIndexInfo(null, var3_3, var14_24, false, true)) == null) {
                                        throw new BadSpecial("Failed to get metadata from database");
                                    }
                                    this.displayResultSet(null, var8_8, SqlFile.listMDIndexCols, null);
                                    break block44;
                                }
                                default: {
                                    throw new BadSpecial("Unknown describe option: '" + var1_1 + "'");
                                }
                            }
                            if (var7_7 == null) {
                                var4_4 = var12_13.indexOf("HSQL") > -1 ? SqlFile.listMDTableCols[1] : (var12_13.indexOf("Oracle") > -1 ? SqlFile.listMDTableCols[2] : SqlFile.listMDTableCols[0]);
                                if (var3_3 == null && var10_10 != null && var10_10.charAt(var10_10.length() - 1) == '.') {
                                    var3_3 = var10_10.substring(0, var10_10.length() - 1);
                                    var10_10 = null;
                                }
                            }
                            v1 = var8_8 = var7_7 == null ? var11_11.getTables(null, var3_3, null, var5_5) : var7_7.getResultSet();
                            if (var8_8 == null) {
                                throw new BadSpecial("Failed to get metadata from database");
                            }
                            this.displayResultSet(null, var8_8, var4_4, var10_10);
                            if (var6_6 != null) {
                                var15_26 = 1;
                                while (var15_26 < var6_6.length) {
                                    var8_8 = var11_11.getTables(null, var6_6[var15_26], null, var5_5);
                                    if (var8_8 == null) {
                                        throw new BadSpecial("Failed to get metadata from database for '" + var6_6[var15_26] + "'");
                                    }
                                    if (var8_8.next()) {
                                        this.displayResultSet(null, var11_11.getTables(null, var6_6[var15_26], null, var5_5), var4_4, var10_10);
                                    }
                                    ++var15_26;
                                }
                            }
                            break block45;
                        }
                        catch (SQLException var11_12) {
                            throw new BadSpecial("Failure getting MetaData: " + var11_12);
                        }
                        catch (NullPointerException var12_14) {
                            throw new BadSpecial("Failure getting MetaData (NPE)");
                        }
                    }
                    catch (Throwable var16_27) {
                        var17_19 = null;
                        this.excludeSysSchemas = false;
                        if (var8_8 != null) {
                            var8_8 = null;
                        }
                        if (var7_7 == null) throw var16_27;
                        try {
                            var7_7.close();
                        }
                        catch (Exception var18_23) {
                            // empty catch block
                        }
                        var7_7 = null;
                        throw var16_27;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [3 : 1175->1185)] { 
lbl142:
                // 1 sources

                var7_7.close();
                return;
lbl144:
                // 1 sources

                catch (Exception var18_20) {
                    // empty catch block
                }
                return;
            }
            var17_17 = null;
            this.excludeSysSchemas = false;
            if (var8_8 != null) {
                var8_8 = null;
            }
            if (var7_7 == null) return;
            ** try [egrp 2[TRYBLOCK] [3 : 1175->1185)] { 
lbl154:
            // 1 sources

            var7_7.close();
            return;
lbl156:
            // 1 sources

            catch (Exception var18_21) {
                // empty catch block
            }
            return;
        }
        var17_18 = null;
        this.excludeSysSchemas = false;
        if (var8_8 != null) {
            var8_8 = null;
        }
        if (var7_7 == null) return;
        ** try [egrp 2[TRYBLOCK] [3 : 1175->1185)] { 
lbl166:
        // 1 sources

        var7_7.close();
        return;
lbl168:
        // 1 sources

        catch (Exception var18_22) {
            // empty catch block
        }
    }

    private void processSQL() throws SQLException {
        String string = this.plMode ? this.dereference(this.curCommand, true) : this.curCommand;
        Statement statement = null;
        if (this.doPrepare) {
            if (string.indexOf(63) < 1) {
                throw new SQLException("Prepared statements must contain one '?'");
            }
            this.doPrepare = false;
            PreparedStatement preparedStatement = this.curConn.prepareStatement(string);
            if (this.prepareVar == null) {
                if (this.binBuffer == null) {
                    throw new SQLException("Binary SqlFile buffer is empty");
                }
                preparedStatement.setBytes(1, this.binBuffer);
            } else {
                String string2 = (String)this.userVars.get(this.prepareVar);
                if (string2 == null) {
                    throw new SQLException("PL Variable '" + this.prepareVar + "' is empty");
                }
                this.prepareVar = null;
                preparedStatement.setString(1, string2);
            }
            preparedStatement.executeUpdate();
            statement = preparedStatement;
        } else {
            statement = this.curConn.createStatement();
            statement.execute(string);
        }
        this.possiblyUncommitteds.set(true);
        try {
            this.displayResultSet(statement, statement.getResultSet(), null, null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (Exception exception) {}
    }

    /*
     * Unable to fully structure code
     */
    private void displayResultSet(Statement var1_1, ResultSet var2_2, int[] var3_3, String var4_4) throws SQLException {
        var6_5 = var1_1 == null ? -1 : var1_1.getUpdateCount();
        var7_6 = this.silentFetch;
        var8_7 = this.fetchBinary;
        this.silentFetch = false;
        this.fetchBinary = false;
        if (this.excludeSysSchemas) {
            this.stdprintln("*** WARNING:\n*** Omitting tables from system-supplied schemas\n*** (because Oracle(TM) doesn't differentiate them to JDBC).");
        }
        switch (var6_5) {
            case -1: {
                if (var2_2 == null) {
                    this.stdprintln("No result", true);
                    break;
                }
                var9_8 = var2_2.getMetaData();
                var10_9 = var9_8.getColumnCount();
                var11_10 = var3_3 == null ? var10_9 : var3_3.length;
                var13_11 = new ArrayList<String[]>();
                var14_12 = null;
                var16_13 = new int[var11_10];
                if (!this.htmlMode) {
                    var20_14 = 0;
                    while (var20_14 < var16_13.length) {
                        var16_13[var20_14] = 0;
                        ++var20_14;
                    }
                }
                var20_15 = new boolean[var11_10];
                var21_16 = new int[var11_10];
                var17_17 = -1;
                var14_12 = new String[var11_10];
                var22_18 = 1;
                while (var22_18 <= var10_9) {
                    if (var3_3 == null) ** GOTO lbl40
                    var18_19 = true;
                    var23_20 = 0;
                    while (var23_20 < var3_3.length) {
                        if (var22_18 == var3_3[var23_20]) {
                            var18_19 = false;
                        }
                        ++var23_20;
                    }
                    if (var18_19) ** GOTO lbl48
lbl40:
                    // 2 sources

                    var14_12[++var17_17] = var9_8.getColumnLabel(var22_18);
                    var21_16[var17_17] = var9_8.getColumnType(var22_18);
                    var20_15[var17_17] = false;
                    switch (var21_16[var17_17]) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            var20_15[var17_17] = true;
                        }
                    }
                    if (!this.htmlMode && var14_12[var17_17].length() > var16_13[var17_17]) {
                        var16_13[var17_17] = var14_12[var17_17].length();
                    }
lbl48:
                    // 4 sources

                    ++var22_18;
                }
                while (var2_2.next()) {
                    var15_23 = new String[var11_10];
                    var17_17 = -1;
                    var23_20 = var4_4 != null ? 1 : 0;
                    var24_24 = 1;
                    while (var24_24 <= var10_9) {
                        if (var3_3 == null) ** GOTO lbl65
                        var18_19 = true;
                        var25_25 = 0;
                        while (var25_25 < var3_3.length) {
                            if (var24_24 == var3_3[var25_25]) {
                                var18_19 = false;
                            }
                            ++var25_25;
                        }
                        if (var18_19) ** GOTO lbl107
lbl65:
                        // 2 sources

                        if (!SqlFile.canDisplayType(var21_16[++var17_17])) {
                            var8_7 = true;
                        }
                        var12_22 = null;
                        if (!var8_7) {
                            if (var21_16[var17_17] == 93) {
                                var5_21 = var2_2.getTimestamp(var24_24);
                                var12_22 = var5_21 == null ? null : var5_21.toString();
                            } else {
                                var12_22 = var2_2.getString(var24_24);
                                if (var12_22 == null) {
                                    try {
                                        var12_22 = this.streamToString(var2_2.getAsciiStream(var24_24));
                                    }
                                    catch (Exception var25_26) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        if (var8_7 || var12_22 == null && !var2_2.wasNull()) {
                            try {
                                this.binBuffer = this.streamToBytes(var2_2.getBinaryStream(var24_24));
                            }
                            catch (IOException var25_27) {
                                throw new SQLException("Failed to read value using stream");
                            }
                            this.stdprintln("Read " + this.binBuffer.length + " bytes from field '" + var14_12[var17_17] + "' (type " + SqlFile.sqlTypeToString(var21_16[var17_17]) + ") into binary buffer");
                            return;
                        }
                        if (this.excludeSysSchemas && var24_24 == 2) {
                            var25_28 = 0;
                            while (var25_28 < SqlFile.oracleSysSchemas.length) {
                                if (var12_22.equals(SqlFile.oracleSysSchemas[var25_28])) {
                                    var23_20 = 1;
                                    break;
                                }
                                ++var25_28;
                            }
                        }
                        if (this.fetchingVar != null) {
                            this.userVars.put(this.fetchingVar, var12_22);
                            this.fetchingVar = null;
                        }
                        if (var7_6) {
                            return;
                        }
                        if (var4_4 != null && (var12_22 == null || var12_22.indexOf(var4_4) > -1)) {
                            var23_20 = 0;
                        }
                        var15_23[var17_17] = var12_22 == null ? (var21_16[var17_17] == 12 ? (this.htmlMode != false ? "<I>null</I>" : "[null]") : "") : var12_22;
                        if (!this.htmlMode && var15_23[var17_17].length() > var16_13[var17_17]) {
                            var16_13[var17_17] = var15_23[var17_17].length();
                        }
lbl107:
                        // 4 sources

                        ++var24_24;
                    }
                    if (var23_20 != 0) continue;
                    var13_11.add(var15_23);
                }
                this.condlPrintln("<TABLE border='1'>", true);
                if (var11_10 > 1) {
                    this.condlPrint(SqlFile.htmlRow(0) + '\n' + SqlFile.PRE_TD, true);
                    var24_24 = 0;
                    while (var24_24 < var14_12.length) {
                        this.condlPrint("<TD>" + var14_12[var24_24] + "</TD>", true);
                        this.condlPrint((var24_24 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(var14_12[var24_24], var16_13[var24_24], var20_15[var24_24], var24_24 < var14_12.length - 1 || var20_15[var24_24] != false), false);
                        ++var24_24;
                    }
                    this.condlPrintln("\n" + SqlFile.PRE_TR + "</TR>", true);
                    this.condlPrintln("", false);
                    if (!this.htmlMode) {
                        var25_29 = 0;
                        while (var25_29 < var14_12.length) {
                            this.condlPrint((var25_29 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(var16_13[var25_29]), false);
                            ++var25_29;
                        }
                        this.condlPrintln("", false);
                    }
                }
                var24_24 = 0;
                while (var24_24 < var13_11.size()) {
                    this.condlPrint(SqlFile.htmlRow(var24_24 % 2 == 0 ? 2 : 1) + '\n' + SqlFile.PRE_TD, true);
                    var15_23 = (String[])var13_11.get(var24_24);
                    var25_30 = 0;
                    while (var25_30 < var15_23.length) {
                        this.condlPrint("<TD>" + var15_23[var25_30] + "</TD>", true);
                        this.condlPrint((var25_30 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(var15_23[var25_30], var16_13[var25_30], var20_15[var25_30], var25_30 < var15_23.length - 1 || var20_15[var25_30] != false), false);
                        ++var25_30;
                    }
                    this.condlPrintln("\n" + SqlFile.PRE_TR + "</TR>", true);
                    this.condlPrintln("", false);
                    ++var24_24;
                }
                this.condlPrintln("</TABLE>", true);
                if (var13_11.size() != 1) {
                    this.stdprintln("\n" + var13_11.size() + " rows", true);
                }
                this.condlPrintln("<HR>", true);
                break;
            }
            default: {
                if (this.fetchingVar != null) {
                    this.userVars.put(this.fetchingVar, Integer.toString(var6_5));
                    this.fetchingVar = null;
                }
                if (var6_5 == 0) break;
                this.stdprintln(Integer.toString(var6_5) + " row" + (var6_5 == 1 ? "" : "s") + " updated");
            }
        }
    }

    private static String htmlRow(int n) {
        switch (n) {
            case 0: {
                return PRE_TR + "<TR style='font-weight: bold;'>";
            }
            case 1: {
                return PRE_TR + "<TR style='background: #94d6ef; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
            case 2: {
                return PRE_TR + "<TR style='background: silver; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
        }
        return null;
    }

    private static String divider(int n) {
        return n > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, n);
    }

    private static String spaces(int n) {
        return n > SPACES.length() ? SPACES : SPACES.substring(0, n);
    }

    private static String pad(String string, int n, boolean bl, boolean bl2) {
        if (!bl2) {
            return string;
        }
        int n2 = n - string.length();
        if (n2 < 1) {
            return string;
        }
        String string2 = SqlFile.spaces(n2);
        return (bl ? string2 : "") + string + (bl ? "" : string2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showHistory() {
        var1_1 = -1;
        var3_2 = new String[this.statementHistory.length];
        try {
            var4_3 = this.curHist;
            while (true) {
                block13: {
                    block12: {
                        if (var4_3 >= 0) break block12;
                        var5_13 = this.statementHistory.length - 1;
                        if (true) ** GOTO lbl49
                    }
                    var2_4 = this.statementHistory[var4_3];
                    if (var2_4 != null) break block13;
                    var7_5 = null;
                    if (var1_1 < 0) {
                        this.stdprintln("<<<    No history yet    >>>");
                        return;
                    }
                    var8_9 = var1_1;
                    if (true) ** GOTO lbl34
                }
                var3_2[++var1_1] = var2_4;
                --var4_3;
            }
        }
        catch (Throwable var6_14) {
            var7_8 = null;
            if (var1_1 < 0) {
                this.stdprintln("<<<    No history yet    >>>");
                return;
            }
            var8_12 = var1_1;
            if (true) ** GOTO lbl72
        }
        do {
            this.psStd.println((var8_9 == 0 ? "BUFR" : "-" + var8_9 + "  ") + " **********************************************\n" + var3_2[var8_9]);
            --var8_9;
lbl34:
            // 2 sources

        } while (var8_9 >= 0);
        this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
        return;
        do {
            block14: {
                if ((var2_4 = this.statementHistory[var5_13]) != null) break block14;
                var7_6 = null;
                if (var1_1 < 0) {
                    this.stdprintln("<<<    No history yet    >>>");
                    return;
                }
                var8_10 = var1_1;
                if (true) ** GOTO lbl60
            }
            var3_2[++var1_1] = var2_4;
            --var5_13;
lbl49:
            // 2 sources

        } while (var5_13 > this.curHist);
        var7_7 = null;
        if (var1_1 < 0) {
            this.stdprintln("<<<    No history yet    >>>");
            return;
        }
        var8_11 = var1_1;
        if (true) ** GOTO lbl66
        do {
            this.psStd.println((var8_10 == 0 ? "BUFR" : "-" + var8_10 + "  ") + " **********************************************\n" + var3_2[var8_10]);
            --var8_10;
lbl60:
            // 2 sources

        } while (var8_10 >= 0);
        this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
        return;
        do {
            this.psStd.println((var8_11 == 0 ? "BUFR" : "-" + var8_11 + "  ") + " **********************************************\n" + var3_2[var8_11]);
            --var8_11;
lbl66:
            // 2 sources

        } while (var8_11 >= 0);
        this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
        return;
        do {
            this.psStd.println((var8_12 == 0 ? "BUFR" : "-" + var8_12 + "  ") + " **********************************************\n" + var3_2[var8_12]);
            --var8_12;
lbl72:
            // 2 sources

        } while (var8_12 >= 0);
        this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
        throw var6_14;
    }

    private String commandFromHistory(int n) throws BadSpecial {
        if (n >= this.statementHistory.length) {
            throw new BadSpecial("History can only hold up to " + this.statementHistory.length + " commands");
        }
        String string = this.statementHistory[(this.statementHistory.length + this.curHist - n) % this.statementHistory.length];
        if (string == null) {
            throw new BadSpecial("History doesn't go back that far");
        }
        return string;
    }

    private void setBuf(String string) {
        ++this.curHist;
        if (this.curHist == this.statementHistory.length) {
            this.curHist = 0;
        }
        this.statementHistory[this.curHist] = string;
    }

    private void describe(String string, String string2) throws SQLException {
        String string3 = string2;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = new String[]{"name", "datatype", "width", "no-nulls"};
        int[] nArray = new int[]{0, 0, 0, 0};
        boolean[] blArray = new boolean[]{false, false, true, false};
        int n = 0;
        while (n < stringArray.length) {
            if (!this.htmlMode && stringArray[n].length() > nArray[n]) {
                nArray[n] = stringArray[n].length();
            }
            ++n;
        }
        Statement statement = this.curConn.createStatement();
        ResultSet resultSet = null;
        try {
            int n2;
            int n3;
            String[] stringArray2;
            statement.execute("SELECT * FROM " + string + " WHERE 1 = 2");
            resultSet = statement.getResultSet();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n4 = resultSetMetaData.getColumnCount();
            int n5 = 0;
            while (n5 < n4) {
                stringArray2 = new String[4];
                stringArray2[0] = resultSetMetaData.getColumnName(n5 + 1);
                if (string3 == null || stringArray2[0].indexOf(string3) >= 0) {
                    stringArray2[1] = resultSetMetaData.getColumnTypeName(n5 + 1);
                    stringArray2[2] = Integer.toString(resultSetMetaData.getColumnDisplaySize(n5 + 1));
                    stringArray2[3] = resultSetMetaData.isNullable(n5 + 1) == 1 ? (this.htmlMode ? "&nbsp;" : "") : "*";
                    arrayList.add(stringArray2);
                    n3 = 0;
                    while (n3 < stringArray2.length) {
                        if (stringArray2[n3].length() > nArray[n3]) {
                            nArray[n3] = stringArray2[n3].length();
                        }
                        ++n3;
                    }
                }
                ++n5;
            }
            this.condlPrint("<TABLE border='1'>\n" + SqlFile.htmlRow(0) + '\n' + PRE_TD, true);
            n3 = 0;
            while (n3 < stringArray.length) {
                this.condlPrint("<TD>" + stringArray[n3] + "</TD>", true);
                this.condlPrint((n3 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray[n3], nArray[n3], blArray[n3], n3 < stringArray.length - 1 || blArray[n3]), false);
                ++n3;
            }
            this.condlPrintln("\n" + PRE_TR + "</TR>", true);
            this.condlPrintln("", false);
            if (!this.htmlMode) {
                n2 = 0;
                while (n2 < stringArray.length) {
                    this.condlPrint((n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(nArray[n2]), false);
                    ++n2;
                }
                this.condlPrintln("", false);
            }
            n2 = 0;
            while (n2 < arrayList.size()) {
                this.condlPrint(SqlFile.htmlRow(n2 % 2 == 0 ? 2 : 1) + '\n' + PRE_TD, true);
                stringArray2 = (String[])arrayList.get(n2);
                int n6 = 0;
                while (n6 < stringArray2.length) {
                    this.condlPrint("<TD>" + stringArray2[n6] + "</TD>", true);
                    this.condlPrint((n6 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray2[n6], nArray[n6], blArray[n6], n6 < stringArray2.length - 1 || blArray[n6]), false);
                    ++n6;
                }
                this.condlPrintln("\n" + PRE_TR + "</TR>", true);
                this.condlPrintln("", false);
                ++n2;
            }
            this.condlPrintln("\n</TABLE>\n<HR>", true);
            Object var20_18 = null;
        }
        catch (Throwable throwable) {
            Object var20_19 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            statement.close();
        }
        catch (Exception exception) {}
    }

    public static String[] getTokenArray(String string) {
        String[] stringArray = new String[]{};
        if (string == null) {
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray2;
    }

    private boolean eval(String[] stringArray) throws BadSpecial {
        boolean bl = stringArray.length > 0 && stringArray[0].equals("!");
        String[] stringArray2 = new String[bl ? stringArray.length - 1 : stringArray.length];
        int n = 0;
        while (n < stringArray2.length) {
            String string = stringArray[n + (bl ? 1 : 0)].length() > 1 && stringArray[n + (bl ? 1 : 0)].charAt(0) == '*' ? (String)this.userVars.get(stringArray[n + (bl ? 1 : 0)].substring(1)) : (stringArray2[n] = stringArray[n + (bl ? 1 : 0)]);
            if (stringArray2[n] == null) {
                stringArray2[n] = "";
            }
            ++n;
        }
        if (stringArray2.length == 1) {
            return (stringArray2[0].length() > 0 && !stringArray2[0].equals("0")) ^ bl;
        }
        if (stringArray2.length == 3) {
            if (stringArray2[1].equals("==")) {
                return stringArray2[0].equals(stringArray2[2]) ^ bl;
            }
            if (stringArray2[1].equals("!=") || stringArray2[1].equals("<>") || stringArray2[1].equals("><")) {
                return !stringArray2[0].equals(stringArray2[2]) ^ bl;
            }
            if (stringArray2[1].equals(">")) {
                return (stringArray2[0].length() > stringArray2[2].length() || stringArray2[0].length() == stringArray2[2].length() && stringArray2[0].compareTo(stringArray2[2]) > 0) ^ bl;
            }
            if (stringArray2[1].equals("<")) {
                return (stringArray2[2].length() > stringArray2[0].length() || stringArray2[2].length() == stringArray2[0].length() && stringArray2[2].compareTo(stringArray2[0]) > 0) ^ bl;
            }
        }
        throw new BadSpecial("Unrecognized logical operation");
    }

    private void closeQueryOutputStream() {
        if (this.pwQuery == null) {
            return;
        }
        if (this.htmlMode) {
            this.pwQuery.println("</BODY></HTML>");
            this.pwQuery.flush();
        }
        this.pwQuery.close();
        this.pwQuery = null;
    }

    private void condlPrintln(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        this.psStd.println(string);
        if (this.pwQuery != null) {
            this.pwQuery.println(string);
            this.pwQuery.flush();
        }
    }

    private void condlPrint(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        this.psStd.print(string);
        if (this.pwQuery != null) {
            this.pwQuery.print(string);
            this.pwQuery.flush();
        }
    }

    private static String formatNicely(Map map, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = new TreeMap(map).keySet().iterator();
        if (bl) {
            stringBuffer.append("The outermost parentheses are not part of the values.\n");
        } else {
            stringBuffer.append("Showing variable names and length of values (use 'listvalue' to see values).\n");
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            stringBuffer.append("    " + string + ": " + (bl ? "(" + string2 + ')' : Integer.toString(string2.length())) + '\n');
        }
        return stringBuffer.toString();
    }

    private void dump(String string, File file) throws IOException, BadSpecial {
        char c;
        String string2 = (String)this.userVars.get(string);
        if (string2 == null) {
            throw new BadSpecial("Variable '" + string + "' has no value set");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
        outputStreamWriter.write(string2);
        boolean bl = false;
        if (string2.length() > 0 && (c = string2.charAt(string2.length() - 1)) != '\n' && c != '\r') {
            bl = true;
            outputStreamWriter.write(10);
        }
        outputStreamWriter.flush();
        outputStreamWriter.close();
        this.stdprintln("Saved " + file.length() + " characters to '" + file + "'");
    }

    private void dump(File file) throws IOException, BadSpecial {
        if (this.binBuffer == null) {
            throw new BadSpecial("Binary SqlFile buffer is currently empty");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(this.binBuffer);
        int n = this.binBuffer.length;
        this.binBuffer = null;
        fileOutputStream.flush();
        fileOutputStream.close();
        this.stdprintln("Saved " + n + " bytes to '" + file + "'");
    }

    private String streamToString(InputStream inputStream) throws IOException {
        int n;
        char[] cArray = new char[10240];
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.charset);
        while ((n = inputStreamReader.read(cArray)) > 0) {
            stringWriter.write(cArray, 0, n);
        }
        return stringWriter.toString();
    }

    private byte[] streamToBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[10240];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void load(String string, File file) throws IOException {
        int n;
        char[] cArray = new char[10240];
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), this.charset);
        while ((n = inputStreamReader.read(cArray)) > 0) {
            stringWriter.write(cArray, 0, n);
        }
        inputStreamReader.close();
        this.userVars.put(string, stringWriter.toString());
    }

    private void load(File file) throws IOException {
        int n;
        byte[] byArray = new byte[10240];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = new FileInputStream(file);
        while ((n = fileInputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        this.binBuffer = byteArrayOutputStream.toByteArray();
        this.stdprintln("Loaded " + this.binBuffer.length + " bytes into Binary buffer");
    }

    public static boolean canDisplayType(int n) {
        switch (n) {
            case 1111: 
            case 2000: 
            case 2002: 
            case 2004: {
                return false;
            }
        }
        return true;
    }

    public static String sqlTypeToString(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTANCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "Unknown type " + n;
    }

    static {
        revnum = "$Revision: 1.124 $".substring("$Revision: ".length(), "$Revision: 1.124 $".length() - 2);
        BANNER = "(SqlFile processor v. " + revnum + ")\n" + "Distribution is permitted under the terms of the HSQLDB license.\n" + "(c) 2004-2005 Blaine Simpson and the HSQLDB Development Group.\n\n" + "    \\q    to Quit.\n" + "    \\?    lists Special Commands.\n" + "    :?    lists Buffer/Editing commands.\n" + "    *?    lists PL commands (including alias commands).\n\n" + "SPECIAL Commands begin with '\\' and execute when you hit ENTER.\n" + "BUFFER Commands begin with ':' and execute when you hit ENTER.\n" + "COMMENTS begin with '/*' and end with the very next '*/'.\n" + "PROCEDURAL LANGUAGE commands begin with '* ' and end when you hit ENTER.\n" + "All other lines comprise SQL Statements.\n" + "  SQL Statements are terminated by either a blank line (which moves the\n" + "  statement into the buffer without executing) or a line ending with ';'\n" + "  (which executes the statement).\n" + "  SQL Statements may begin with '/PLVARNAME' and/or contain *{PLVARNAME}s.\n";
        nonVarChars = new char[]{' ', '\t', '=', '}', '\n', '\r'};
        listMDSchemaCols = new int[]{1};
        listMDIndexCols = new int[]{2, 6, 3, 9, 4, 10, 11};
        listMDTableCols = new int[][]{{2, 3}, {2, 3}, {2, 3}};
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
        PRE_TR = SqlFile.spaces(4);
        PRE_TD = SqlFile.spaces(8);
    }

    private class BadSwitch
    extends Exception {
        private BadSwitch(int n) {
            super(Integer.toString(n));
        }
    }

    private class ContinueException
    extends SqlToolError {
        public ContinueException() {
        }

        public ContinueException(String string) {
            super(string);
        }
    }

    private class BreakException
    extends SqlToolError {
        public BreakException() {
        }

        public BreakException(String string) {
            super(string);
        }
    }

    private class QuitNow
    extends SqlToolError {
        public QuitNow(String string) {
            super(string);
        }

        public QuitNow() {
        }
    }

    private class BadSpecial
    extends Exception {
        private BadSpecial(String string) {
            super(string);
        }
    }

    private static class BooleanBucket {
        private boolean bPriv = false;

        private BooleanBucket() {
        }

        public void set(boolean bl) {
            this.bPriv = bl;
        }

        public boolean get() {
            return this.bPriv;
        }
    }
}

