/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api;

import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.api.AgroalDataSourceProvider;
import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.sql.DataSource;

public interface AgroalDataSource
extends AutoCloseable,
DataSource,
Serializable {
    public static AgroalDataSource from(Supplier<AgroalDataSourceConfiguration> configurationSupplier, AgroalDataSourceListener ... listeners) throws SQLException {
        return AgroalDataSource.from(configurationSupplier.get(), listeners);
    }

    public static AgroalDataSource from(AgroalDataSourceConfiguration configuration, AgroalDataSourceListener ... listeners) throws SQLException {
        for (AgroalDataSourceProvider provider : ServiceLoader.load(AgroalDataSourceProvider.class, AgroalDataSourceProvider.class.getClassLoader())) {
            AgroalDataSource implementation = provider.getDataSource(configuration, listeners);
            if (implementation == null) continue;
            return implementation;
        }
        try {
            Class<AgroalDataSource> dataSourceClass = AgroalDataSource.class.getClassLoader().loadClass(configuration.dataSourceImplementation().className()).asSubclass(AgroalDataSource.class);
            Constructor<AgroalDataSource> dataSourceConstructor = dataSourceClass.getConstructor(AgroalDataSourceConfiguration.class, AgroalDataSourceListener[].class);
            return dataSourceConstructor.newInstance(configuration, listeners);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SQLException("Could not load the required implementation", e);
        }
    }

    public Connection getReadOnlyConnection() throws SQLException;

    public AgroalDataSourceConfiguration getConfiguration();

    public AgroalDataSourceMetrics getMetrics();

    public void flush(FlushMode var1);

    public void setPoolInterceptors(Collection<? extends AgroalPoolInterceptor> var1);

    public List<AgroalPoolInterceptor> getPoolInterceptors();

    default public boolean isHealthy(boolean newConnection) throws SQLException {
        return true;
    }

    @Override
    public void close();

    public static enum FlushMode {
        ALL,
        IDLE,
        INVALID,
        GRACEFUL,
        LEAK,
        FILL;

    }
}

