/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration.supplier;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.exceptionsorter.DB2ExceptionSorter;
import io.agroal.api.exceptionsorter.MSSQLExceptionSorter;
import io.agroal.api.exceptionsorter.MySQLExceptionSorter;
import io.agroal.api.exceptionsorter.OracleExceptionSorter;
import io.agroal.api.exceptionsorter.PostgreSQLExceptionSorter;
import io.agroal.api.exceptionsorter.SybaseExceptionSorter;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgroalPropertiesReader
implements Supplier<AgroalDataSourceConfiguration> {
    public static final String IMPLEMENTATION = "implementation";
    public static final String METRICS_ENABLED = "metricsEnabled";
    public static final String MIN_SIZE = "minSize";
    public static final String MAX_SIZE = "maxSize";
    public static final String INITIAL_SIZE = "initialSize";
    public static final String FLUSH_ON_CLOSE = "flushOnClose";
    public static final String CONNECTION_VALIDATOR = "connectionValidator";
    public static final String ENHANCED_LEAK_REPORT = "enhancedLeakReport";
    public static final String EXCEPTION_SORTER = "exceptionSorter";
    public static final String MULTIPLE_ACQUISITION = "multipleAcquisition";
    public static final String TRANSACTION_REQUIREMENT = "transactionRequirement";
    public static final String VALIDATE_ON_BORROW = "validateOnBorrow";
    public static final String ACQUISITION_TIMEOUT = "acquisitionTimeout";
    public static final String ACQUISITION_TIMEOUT_MS = "acquisitionTimeout_ms";
    public static final String ACQUISITION_TIMEOUT_S = "acquisitionTimeout_s";
    public static final String ACQUISITION_TIMEOUT_M = "acquisitionTimeout_m";
    public static final String IDLE_VALIDATION = "idleValidation";
    public static final String IDLE_VALIDATION_MS = "idleValidation_ms";
    public static final String IDLE_VALIDATION_S = "idleValidation_s";
    public static final String IDLE_VALIDATION_M = "idleValidation_m";
    public static final String VALIDATION_TIMEOUT = "validationTimeout";
    public static final String VALIDATION_TIMEOUT_MS = "validationTimeout_ms";
    public static final String VALIDATION_TIMEOUT_S = "validationTimeout_s";
    public static final String VALIDATION_TIMEOUT_M = "validationTimeout_m";
    public static final String LEAK_TIMEOUT = "leakTimeout";
    public static final String LEAK_TIMEOUT_MS = "leakTimeout_ms";
    public static final String LEAK_TIMEOUT_S = "leakTimeout_s";
    public static final String LEAK_TIMEOUT_M = "leakTimeout_m";
    public static final String REAP_TIMEOUT = "reapTimeout";
    public static final String REAP_TIMEOUT_MS = "reapTimeout_ms";
    public static final String REAP_TIMEOUT_S = "reapTimeout_s";
    public static final String REAP_TIMEOUT_M = "reapTimeout_m";
    public static final String MAX_LIFETIME = "maxLifetime";
    public static final String MAX_LIFETIME_MS = "maxLifetime_ms";
    public static final String MAX_LIFETIME_S = "maxLifetime_s";
    public static final String MAX_LIFETIME_M = "maxLifetime_m";
    public static final String JDBC_URL = "jdbcUrl";
    public static final String AUTO_COMMIT = "autoCommit";
    public static final String READ_ONLY = "readOnly";
    public static final String TRACK_JDBC_RESOURCES = "trackJdbcResources";
    public static final String LOGIN_TIMEOUT = "loginTimeout";
    public static final String INITIAL_SQL = "initialSQL";
    public static final String PROVIDER_CLASS_NAME = "providerClassName";
    public static final String TRANSACTION_ISOLATION = "jdbcTransactionIsolation";
    public static final String PRINCIPAL = "principal";
    public static final String CREDENTIAL = "credential";
    public static final String POOL_RECOVERY = "poolRecovery";
    public static final String RECOVERY_PRINCIPAL = "recoveryPrincipal";
    public static final String RECOVERY_CREDENTIAL = "recoveryCredential";
    public static final String JDBC_PROPERTIES = "jdbcProperties";
    public static final String XA_PROPERTIES = "xaProperties";
    private static final Pattern SQL_VALIDATOR_PATTERN = Pattern.compile("^sql\\[(.+?)\\](\\d*)$");
    private final String prefix;
    private final AgroalDataSourceConfigurationSupplier dataSourceSupplier;

    public AgroalPropertiesReader() {
        this("");
    }

    public AgroalPropertiesReader(String readerPrefix) {
        this.prefix = readerPrefix;
        this.dataSourceSupplier = new AgroalDataSourceConfigurationSupplier();
    }

    @Override
    public AgroalDataSourceConfiguration get() {
        return this.dataSourceSupplier.get();
    }

    public AgroalDataSourceConfigurationSupplier modify() {
        return this.dataSourceSupplier;
    }

    public AgroalPropertiesReader readProperties(Path path) throws IOException {
        return this.readProperties(path.toFile());
    }

    public AgroalPropertiesReader readProperties(String filename) throws IOException {
        return this.readProperties(new File(filename));
    }

    public AgroalPropertiesReader readProperties(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(inputStream);
            AgroalPropertiesReader agroalPropertiesReader = this.readProperties(properties);
            return agroalPropertiesReader;
        }
    }

    public AgroalPropertiesReader readProperties(Properties properties) {
        return this.readProperties((Map<String, String>)properties);
    }

    public AgroalPropertiesReader readProperties(Map<String, String> properties) {
        AgroalConnectionPoolConfigurationSupplier connectionPoolSupplier = new AgroalConnectionPoolConfigurationSupplier();
        AgroalConnectionFactoryConfigurationSupplier connectionFactorySupplier = new AgroalConnectionFactoryConfigurationSupplier();
        this.apply(this.dataSourceSupplier::dataSourceImplementation, AgroalDataSourceConfiguration.DataSourceImplementation::valueOf, properties, IMPLEMENTATION);
        this.apply(this.dataSourceSupplier::metricsEnabled, Boolean::parseBoolean, properties, METRICS_ENABLED);
        this.apply(connectionPoolSupplier::minSize, Integer::parseInt, properties, MIN_SIZE);
        this.apply(connectionPoolSupplier::maxSize, Integer::parseInt, properties, MAX_SIZE);
        this.apply(connectionPoolSupplier::flushOnClose, Boolean::parseBoolean, properties, FLUSH_ON_CLOSE);
        this.apply(connectionPoolSupplier::initialSize, Integer::parseInt, properties, INITIAL_SIZE);
        this.apply(connectionPoolSupplier::connectionValidator, AgroalPropertiesReader::parseConnectionValidator, properties, CONNECTION_VALIDATOR);
        this.apply(connectionPoolSupplier::exceptionSorter, AgroalPropertiesReader::parseExceptionSorter, properties, EXCEPTION_SORTER);
        this.apply(connectionPoolSupplier::enhancedLeakReport, Boolean::parseBoolean, properties, ENHANCED_LEAK_REPORT);
        this.apply(connectionPoolSupplier::multipleAcquisition, AgroalConnectionPoolConfiguration.MultipleAcquisitionAction::valueOf, properties, MULTIPLE_ACQUISITION);
        this.apply(connectionPoolSupplier::transactionRequirement, AgroalConnectionPoolConfiguration.TransactionRequirement::valueOf, properties, TRANSACTION_REQUIREMENT);
        this.apply(connectionPoolSupplier::validateOnBorrow, Boolean::parseBoolean, properties, VALIDATE_ON_BORROW);
        this.apply(connectionPoolSupplier::acquisitionTimeout, Duration::parse, properties, ACQUISITION_TIMEOUT);
        this.apply(connectionPoolSupplier::acquisitionTimeout, AgroalPropertiesReader::parseDurationMs, properties, ACQUISITION_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::acquisitionTimeout, AgroalPropertiesReader::parseDurationS, properties, ACQUISITION_TIMEOUT_S);
        this.apply(connectionPoolSupplier::acquisitionTimeout, AgroalPropertiesReader::parseDurationM, properties, ACQUISITION_TIMEOUT_M);
        this.apply(connectionPoolSupplier::idleValidationTimeout, Duration::parse, properties, IDLE_VALIDATION);
        this.apply(connectionPoolSupplier::idleValidationTimeout, AgroalPropertiesReader::parseDurationMs, properties, IDLE_VALIDATION_MS);
        this.apply(connectionPoolSupplier::idleValidationTimeout, AgroalPropertiesReader::parseDurationS, properties, IDLE_VALIDATION_S);
        this.apply(connectionPoolSupplier::idleValidationTimeout, AgroalPropertiesReader::parseDurationM, properties, IDLE_VALIDATION_M);
        this.apply(connectionPoolSupplier::validationTimeout, Duration::parse, properties, VALIDATION_TIMEOUT);
        this.apply(connectionPoolSupplier::validationTimeout, AgroalPropertiesReader::parseDurationMs, properties, VALIDATION_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::validationTimeout, AgroalPropertiesReader::parseDurationS, properties, VALIDATION_TIMEOUT_S);
        this.apply(connectionPoolSupplier::validationTimeout, AgroalPropertiesReader::parseDurationM, properties, VALIDATION_TIMEOUT_M);
        this.apply(connectionPoolSupplier::leakTimeout, Duration::parse, properties, LEAK_TIMEOUT);
        this.apply(connectionPoolSupplier::leakTimeout, AgroalPropertiesReader::parseDurationMs, properties, LEAK_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::leakTimeout, AgroalPropertiesReader::parseDurationS, properties, LEAK_TIMEOUT_S);
        this.apply(connectionPoolSupplier::leakTimeout, AgroalPropertiesReader::parseDurationM, properties, LEAK_TIMEOUT_M);
        this.apply(connectionPoolSupplier::reapTimeout, Duration::parse, properties, REAP_TIMEOUT);
        this.apply(connectionPoolSupplier::reapTimeout, AgroalPropertiesReader::parseDurationMs, properties, REAP_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::reapTimeout, AgroalPropertiesReader::parseDurationS, properties, REAP_TIMEOUT_S);
        this.apply(connectionPoolSupplier::reapTimeout, AgroalPropertiesReader::parseDurationM, properties, REAP_TIMEOUT_M);
        this.apply(connectionPoolSupplier::maxLifetime, Duration::parse, properties, MAX_LIFETIME);
        this.apply(connectionPoolSupplier::maxLifetime, AgroalPropertiesReader::parseDurationMs, properties, MAX_LIFETIME_MS);
        this.apply(connectionPoolSupplier::maxLifetime, AgroalPropertiesReader::parseDurationS, properties, MAX_LIFETIME_S);
        this.apply(connectionPoolSupplier::maxLifetime, AgroalPropertiesReader::parseDurationM, properties, MAX_LIFETIME_M);
        this.apply(connectionFactorySupplier::jdbcUrl, Function.identity(), properties, JDBC_URL);
        this.apply(connectionFactorySupplier::autoCommit, Boolean::parseBoolean, properties, AUTO_COMMIT);
        this.apply(connectionFactorySupplier::readOnly, Boolean::parseBoolean, properties, READ_ONLY);
        this.apply(connectionFactorySupplier::trackJdbcResources, Boolean::parseBoolean, properties, TRACK_JDBC_RESOURCES);
        this.apply(connectionFactorySupplier::loginTimeout, Duration::parse, properties, LOGIN_TIMEOUT);
        this.apply(connectionFactorySupplier::initialSql, Function.identity(), properties, INITIAL_SQL);
        this.apply(connectionFactorySupplier::connectionProviderClassName, Function.identity(), properties, PROVIDER_CLASS_NAME);
        this.apply(connectionFactorySupplier::jdbcTransactionIsolation, AgroalConnectionFactoryConfiguration.TransactionIsolation::valueOf, properties, TRANSACTION_ISOLATION);
        this.apply(connectionFactorySupplier::principal, NamePrincipal::new, properties, PRINCIPAL);
        this.apply(connectionFactorySupplier::credential, SimplePassword::new, properties, CREDENTIAL);
        this.apply(connectionFactorySupplier::poolRecovery, Boolean::parseBoolean, properties, POOL_RECOVERY);
        this.apply(connectionFactorySupplier::recoveryPrincipal, NamePrincipal::new, properties, RECOVERY_PRINCIPAL);
        this.apply(connectionFactorySupplier::recoveryCredential, SimplePassword::new, properties, RECOVERY_CREDENTIAL);
        this.applyJdbcProperties(connectionFactorySupplier::jdbcProperty, properties, JDBC_PROPERTIES);
        this.applyJdbcProperties(connectionFactorySupplier::xaProperty, properties, XA_PROPERTIES);
        this.dataSourceSupplier.connectionPoolConfiguration(connectionPoolSupplier.connectionFactoryConfiguration(connectionFactorySupplier));
        return this;
    }

    private <T> void apply(Consumer<? super T> consumer, Function<? super String, T> converter, Map<String, String> properties, String key) {
        String value = properties.get(this.prefix + key);
        if (value != null) {
            consumer.accept(converter.apply(value));
        }
    }

    private void applyJdbcProperties(BiConsumer<? super String, ? super String> consumer, Map<String, String> properties, String key) {
        String propertiesArray = properties.get(this.prefix + key);
        if (propertiesArray != null && !propertiesArray.isEmpty()) {
            for (String property : propertiesArray.split(";")) {
                String[] keyValue = property.split("=");
                consumer.accept(keyValue[0], keyValue[1]);
            }
        }
    }

    public static AgroalConnectionPoolConfiguration.ConnectionValidator parseConnectionValidator(String connectionValidatorName) {
        if ("empty".equalsIgnoreCase(connectionValidatorName)) {
            return AgroalConnectionPoolConfiguration.ConnectionValidator.emptyValidator();
        }
        if ("default".equalsIgnoreCase(connectionValidatorName)) {
            return AgroalConnectionPoolConfiguration.ConnectionValidator.defaultValidator();
        }
        if (connectionValidatorName.regionMatches(true, 0, "default", 0, "default".length())) {
            return AgroalConnectionPoolConfiguration.ConnectionValidator.defaultValidatorWithTimeout((int)AgroalPropertiesReader.parseDurationS(connectionValidatorName.substring("default".length())).toSeconds());
        }
        if (connectionValidatorName.regionMatches(true, 0, "sql", 0, "sql".length())) {
            Matcher matcher = SQL_VALIDATOR_PATTERN.matcher(connectionValidatorName);
            if (matcher.matches()) {
                String query = matcher.group(1);
                String timeout = matcher.group(2);
                return AgroalConnectionPoolConfiguration.ConnectionValidator.sqlValidator(query, !timeout.isEmpty() ? (int)AgroalPropertiesReader.parseDurationS(timeout).toSeconds() : 0);
            }
            throw new IllegalArgumentException("Unparsable sql connection validator " + connectionValidatorName);
        }
        try {
            Class<AgroalConnectionPoolConfiguration.ConnectionValidator> validatorClass = Thread.currentThread().getContextClassLoader().loadClass(connectionValidatorName).asSubclass(AgroalConnectionPoolConfiguration.ConnectionValidator.class);
            return validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown connection validator " + connectionValidatorName);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(connectionValidatorName + " class is not a ConnectionValidator", e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to instantiate ConnectionValidator " + connectionValidatorName, e);
        }
    }

    public static AgroalConnectionPoolConfiguration.ExceptionSorter parseExceptionSorter(String exceptionSorterName) {
        if ("empty".equalsIgnoreCase(exceptionSorterName)) {
            return AgroalConnectionPoolConfiguration.ExceptionSorter.emptyExceptionSorter();
        }
        if ("default".equalsIgnoreCase(exceptionSorterName)) {
            return AgroalConnectionPoolConfiguration.ExceptionSorter.defaultExceptionSorter();
        }
        if ("fatal".equalsIgnoreCase(exceptionSorterName)) {
            return AgroalConnectionPoolConfiguration.ExceptionSorter.fatalExceptionSorter();
        }
        if ("DB2".equalsIgnoreCase(exceptionSorterName)) {
            return new DB2ExceptionSorter();
        }
        if ("MSSQL".equalsIgnoreCase(exceptionSorterName)) {
            return new MSSQLExceptionSorter();
        }
        if ("MySQL".equalsIgnoreCase(exceptionSorterName)) {
            return new MySQLExceptionSorter();
        }
        if ("Oracle".equalsIgnoreCase(exceptionSorterName)) {
            return new OracleExceptionSorter();
        }
        if ("Postgres".equalsIgnoreCase(exceptionSorterName) || "PostgreSQL".equalsIgnoreCase(exceptionSorterName)) {
            return new PostgreSQLExceptionSorter();
        }
        if ("Sybase".equalsIgnoreCase(exceptionSorterName)) {
            return new SybaseExceptionSorter();
        }
        try {
            Class<AgroalConnectionPoolConfiguration.ExceptionSorter> sorterClass = Thread.currentThread().getContextClassLoader().loadClass(exceptionSorterName).asSubclass(AgroalConnectionPoolConfiguration.ExceptionSorter.class);
            return sorterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown exception sorter " + exceptionSorterName);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(exceptionSorterName + " class is not a ExceptionSorter", e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to instantiate ExceptionSorter " + exceptionSorterName, e);
        }
    }

    private static Duration parseDurationMs(String value) {
        return Duration.ofMillis(Long.parseLong(value));
    }

    private static Duration parseDurationS(String value) {
        return Duration.ofSeconds(Long.parseLong(value));
    }

    private static Duration parseDurationM(String value) {
        return Duration.ofMinutes(Long.parseLong(value));
    }
}

