/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.configuration.InterruptProtection;
import io.agroal.api.transaction.TransactionAware;
import io.agroal.pool.ConnectionHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ConnectionWrapper
implements Connection,
TransactionAware {
    private static final InvocationHandler CLOSED_HANDLER = (proxy, method, args) -> {
        String methodName = method.getName();
        if ("abort".equals(methodName)) {
            return Void.TYPE;
        }
        if ("isClosed".equals(methodName)) {
            return Boolean.TRUE;
        }
        if ("isValid".equals(methodName)) {
            return Boolean.FALSE;
        }
        if ("toString".equals(methodName)) {
            return ConnectionWrapper.class.getSimpleName() + ".CLOSED_CONNECTION";
        }
        throw new SQLException("Connection is closed");
    };
    private static final Connection CLOSED_CONNECTION = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, CLOSED_HANDLER);
    private final ConnectionHandler handler;
    private final InterruptProtection interruptProtection;
    private Connection wrappedConnection;
    private boolean inTransaction;
    private boolean autocommitStashValue;

    public ConnectionWrapper(ConnectionHandler connectionHandler, InterruptProtection protection) {
        this.handler = connectionHandler;
        this.interruptProtection = protection;
        this.wrappedConnection = connectionHandler.getConnection();
        this.inTransaction = false;
    }

    public void transactionStart() throws SQLException {
        this.autocommitStashValue = this.wrappedConnection.getAutoCommit();
        this.wrappedConnection.setAutoCommit(false);
        this.inTransaction = true;
    }

    public void transactionCommit() throws SQLException {
        this.protect(() -> this.wrappedConnection.commit());
    }

    public void transactionRollback() throws SQLException {
        this.protect(() -> this.wrappedConnection.rollback());
    }

    public void transactionEnd() throws SQLException {
        this.inTransaction = false;
        this.wrappedConnection.setAutoCommit(this.autocommitStashValue);
    }

    private <T> T protect(InterruptProtection.SQLCallable<T> callable) throws SQLException {
        return (T)this.interruptProtection.protect(callable);
    }

    private void protect(InterruptProtection.SQLRunnable runnable) throws SQLException {
        this.interruptProtection.protect(runnable);
    }

    public ConnectionHandler getHandler() {
        return this.handler;
    }

    @Override
    public void close() throws SQLException {
        this.wrappedConnection = CLOSED_CONNECTION;
        if (!this.inTransaction) {
            this.handler.returnConnection();
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.wrappedConnection.abort(executor);
    }

    @Override
    public void commit() throws SQLException {
        if (this.inTransaction) {
            throw new SQLException("Attempting to commit while taking part in a transaction");
        }
        this.protect(() -> this.wrappedConnection.commit());
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.wrappedConnection.clearWarnings();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.wrappedConnection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.wrappedConnection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.wrappedConnection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.wrappedConnection.createSQLXML();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.wrappedConnection.createArrayOf(typeName, elements);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.wrappedConnection.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrappedConnection.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.wrappedConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.wrappedConnection.createStruct(typeName, attributes);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.wrappedConnection.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit && this.inTransaction) {
            throw new SQLException("Trying to set autocommit in connection taking part of transaction");
        }
        this.wrappedConnection.setAutoCommit(autoCommit);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.wrappedConnection.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.wrappedConnection.setCatalog(catalog);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.wrappedConnection.getHoldability();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.wrappedConnection.setHoldability(holdability);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.wrappedConnection.getClientInfo();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.wrappedConnection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.wrappedConnection.getClientInfo(name);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.wrappedConnection.getMetaData();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.wrappedConnection.getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        return this.wrappedConnection.getSchema();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.wrappedConnection.setSchema(schema);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.wrappedConnection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.wrappedConnection.setTypeMap(map);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.wrappedConnection.getTransactionIsolation();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.wrappedConnection.setTransactionIsolation(level);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.wrappedConnection.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.wrappedConnection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.wrappedConnection.isReadOnly();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.wrappedConnection.setReadOnly(readOnly);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.wrappedConnection.isValid(timeout);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.wrappedConnection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.wrappedConnection.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrappedConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.wrappedConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.wrappedConnection.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrappedConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.wrappedConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.wrappedConnection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.wrappedConnection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.wrappedConnection.prepareStatement(sql, columnNames);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.wrappedConnection.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        if (this.inTransaction) {
            throw new SQLException("Attempting to rollback while enlisted in a transaction");
        }
        this.protect(() -> this.wrappedConnection.rollback());
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.inTransaction) {
            throw new SQLException("Attempting to commit while enlisted in a transaction");
        }
        this.protect(() -> this.wrappedConnection.rollback(savepoint));
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.wrappedConnection.setClientInfo(name, value);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.wrappedConnection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.wrappedConnection.setSavepoint(name);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.wrappedConnection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public <T> T unwrap(Class<T> target) throws SQLException {
        return this.wrappedConnection.unwrap(target);
    }

    @Override
    public boolean isWrapperFor(Class<?> target) throws SQLException {
        return this.wrappedConnection.isWrapperFor(target);
    }

    public String toString() {
        return "wrapped[" + this.wrappedConnection + (this.inTransaction ? "]<<enrolled" : "]");
    }
}

