/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.pool.ConnectionPool;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.LongAdder;

public interface DataSourceMetricsRepository
extends AgroalDataSourceMetrics {
    default public long beforeConnectionCreation() {
        return 0L;
    }

    default public void afterConnectionCreation(long timestamp) {
    }

    default public long beforeConnectionAcquire() {
        return 0L;
    }

    default public void afterConnectionAcquire(long timestamp) {
    }

    default public void afterConnectionReturn() {
    }

    default public void afterLeakDetection() {
    }

    default public void afterConnectionInvalid() {
    }

    default public void afterConnectionFlush() {
    }

    default public void afterConnectionReap() {
    }

    default public void afterConnectionDestroy() {
    }

    public static class DefaultMetricsRepository
    implements DataSourceMetricsRepository {
        private static final AtomicLongFieldUpdater<DefaultMetricsRepository> maxCreated = AtomicLongFieldUpdater.newUpdater(DefaultMetricsRepository.class, "maxCreatedDuration");
        private static final AtomicLongFieldUpdater<DefaultMetricsRepository> maxAcquire = AtomicLongFieldUpdater.newUpdater(DefaultMetricsRepository.class, "maxAcquireDuration");
        private final ConnectionPool connectionPool;
        private final LongAdder creationCount = new LongAdder();
        private final LongAdder creationTotalTime = new LongAdder();
        private final LongAdder acquireCount = new LongAdder();
        private final LongAdder returnCount = new LongAdder();
        private final LongAdder acquireTotalTime = new LongAdder();
        private final LongAdder leakDetectionCount = new LongAdder();
        private final LongAdder invalidCount = new LongAdder();
        private final LongAdder flushCount = new LongAdder();
        private final LongAdder reapCount = new LongAdder();
        private final LongAdder destroyCount = new LongAdder();
        private volatile long maxCreatedDuration = 0L;
        private volatile long maxAcquireDuration = 0L;

        public DefaultMetricsRepository(ConnectionPool pool) {
            this.connectionPool = pool;
        }

        private void setMaxValue(AtomicLongFieldUpdater<DefaultMetricsRepository> updater, long value) {
            long oldMax;
            while (value > (oldMax = updater.get(this))) {
                if (!updater.compareAndSet(this, oldMax, value)) continue;
                return;
            }
        }

        @Override
        public long beforeConnectionCreation() {
            return System.nanoTime();
        }

        @Override
        public void afterConnectionCreation(long timestamp) {
            long duration = System.nanoTime() - timestamp;
            this.creationCount.increment();
            this.creationTotalTime.add(duration);
            this.setMaxValue(maxCreated, duration);
        }

        @Override
        public long beforeConnectionAcquire() {
            return System.nanoTime();
        }

        @Override
        public void afterConnectionAcquire(long timestamp) {
            long duration = System.nanoTime() - timestamp;
            this.acquireCount.increment();
            this.acquireTotalTime.add(duration);
            this.setMaxValue(maxAcquire, duration);
        }

        @Override
        public void afterConnectionReturn() {
            this.returnCount.increment();
        }

        @Override
        public void afterLeakDetection() {
            this.leakDetectionCount.increment();
        }

        @Override
        public void afterConnectionInvalid() {
            this.invalidCount.increment();
        }

        @Override
        public void afterConnectionFlush() {
            this.flushCount.increment();
        }

        @Override
        public void afterConnectionReap() {
            this.reapCount.increment();
        }

        @Override
        public void afterConnectionDestroy() {
            this.destroyCount.increment();
        }

        public long creationCount() {
            return this.creationCount.longValue();
        }

        public Duration averageCreationTime() {
            if (this.creationCount.longValue() == 0L) {
                return Duration.ZERO;
            }
            return Duration.ofNanos(this.creationTotalTime.longValue() / this.creationCount.longValue());
        }

        public Duration maxCreationTime() {
            return Duration.ofNanos(this.maxCreatedDuration);
        }

        public Duration totalCreationTime() {
            return Duration.ofNanos(this.creationTotalTime.longValue());
        }

        public long acquireCount() {
            return this.acquireCount.longValue();
        }

        public long leakDetectionCount() {
            return this.leakDetectionCount.longValue();
        }

        public long invalidCount() {
            return this.invalidCount.longValue();
        }

        public long flushCount() {
            return this.flushCount.longValue();
        }

        public long reapCount() {
            return this.reapCount.longValue();
        }

        public long destroyCount() {
            return this.destroyCount.longValue();
        }

        public long activeCount() {
            return this.connectionPool.activeCount();
        }

        public long maxUsedCount() {
            return this.connectionPool.maxUsedCount();
        }

        public long availableCount() {
            return this.connectionPool.availableCount();
        }

        public Duration averageBlockingTime() {
            if (this.acquireCount.longValue() == 0L) {
                return Duration.ZERO;
            }
            return Duration.ofNanos(this.acquireTotalTime.longValue() / this.acquireCount.longValue());
        }

        public Duration maxBlockingTime() {
            return Duration.ofNanos(this.maxAcquireDuration);
        }

        public Duration totalBlockingTime() {
            return Duration.ofNanos(this.acquireTotalTime.longValue());
        }

        public long awaitingCount() {
            return this.connectionPool.awaitingCount();
        }

        public void reset() {
            this.creationCount.reset();
            this.creationTotalTime.reset();
            this.acquireCount.reset();
            this.acquireTotalTime.reset();
            this.leakDetectionCount.reset();
            this.invalidCount.reset();
            this.maxCreatedDuration = 0L;
            this.maxAcquireDuration = 0L;
            this.connectionPool.resetMaxUsedCount();
        }

        public String toString() {
            double avgCreationMs = (double)this.averageCreationTime().toNanos() / (double)TimeUnit.MILLISECONDS.toNanos(1L);
            double avgBlockingMs = (double)this.averageBlockingTime().toNanos() / (double)TimeUnit.MILLISECONDS.toNanos(1L);
            String s1 = MessageFormat.format("Connections: {0} created / {1} invalid / {2} reap / {3} flush / {4} destroyed", this.creationCount, this.invalidCount, this.reapCount, this.flushCount, this.destroyCount);
            String s2 = MessageFormat.format("Pool: {0} available / {1} active / {2} max / {3} acquired / {4} returned", this.availableCount(), this.activeCount(), this.maxUsedCount(), this.acquireCount, this.returnCount);
            String s3 = MessageFormat.format("Created duration: {0,number,000.000}ms average / {1}ms max / {2}ms total", avgCreationMs, this.maxCreationTime().toMillis(), this.totalCreationTime().toMillis());
            String s4 = MessageFormat.format("Acquire duration: {0,number,000.000}ms average / {1}ms max / {2}ms total", avgBlockingMs, this.maxBlockingTime().toMillis(), this.totalBlockingTime().toMillis());
            String s5 = MessageFormat.format("Threads awaiting: {0}", this.awaitingCount());
            String nl = System.lineSeparator();
            return nl + "===" + nl + s1 + nl + s2 + nl + s3 + nl + s4 + nl + s5 + nl + "===";
        }
    }

    public static class EmptyMetricsRepository
    implements DataSourceMetricsRepository {
        public String toString() {
            return "Metrics Disabled";
        }
    }
}

