/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.util;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;

public class PriorityScheduledExecutor
extends ScheduledThreadPoolExecutor {
    private static final AtomicLong THREAD_COUNT = new AtomicLong();
    private Queue<RunnableFuture<?>> priorityTasks = new ConcurrentLinkedQueue();

    public PriorityScheduledExecutor(int executorSize, String threadPrefix) {
        super(executorSize, (Runnable r) -> {
            Thread thread = new Thread(r, threadPrefix + THREAD_COUNT.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        });
    }

    public Future<?> executeNow(Runnable priorityTask) {
        FutureTask<Object> priorityFuture = new FutureTask<Object>(priorityTask, null);
        this.priorityTasks.add(priorityFuture);
        this.submit(() -> {});
        return priorityFuture;
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable lowPriorityTask) {
        RunnableFuture<?> priorityTask;
        while ((priorityTask = this.priorityTasks.poll()) != null) {
            priorityTask.run();
        }
        super.beforeExecute(thread, lowPriorityTask);
    }

    @Override
    public void shutdown() {
        this.submit(() -> {});
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.priorityTasks.forEach(runnableFuture -> runnableFuture.cancel(true));
        this.priorityTasks.clear();
        return super.shutdownNow();
    }
}

