/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.util;

import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.pool.ConnectionHandler;
import io.agroal.pool.wrapper.ConnectionWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public final class InterceptorHelper {
    private InterceptorHelper() {
    }

    public static void fireOnConnectionAcquiredInterceptor(List<? extends AgroalPoolInterceptor> interceptors, ConnectionHandler handler) throws SQLException {
        if (interceptors != null && !interceptors.isEmpty()) {
            for (AgroalPoolInterceptor agroalPoolInterceptor : interceptors) {
                try (ConnectionWrapper connection = handler.newDetachedConnectionWrapper();){
                    agroalPoolInterceptor.onConnectionAcquire((Connection)connection);
                }
            }
        }
    }

    public static void fireOnConnectionReturnInterceptor(List<? extends AgroalPoolInterceptor> interceptors, ConnectionHandler handler) throws SQLException {
        if (interceptors != null && !interceptors.isEmpty()) {
            int i = interceptors.size();
            while (i > 0) {
                try (ConnectionWrapper connection = handler.newDetachedConnectionWrapper();){
                    interceptors.get(--i).onConnectionReturn((Connection)connection);
                }
            }
        }
    }
}

