/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.transaction.TransactionAware;
import io.agroal.pool.ConnectionPool;
import io.agroal.pool.util.ListenerHelper;
import io.agroal.pool.wrapper.ConnectionWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public final class ConnectionHandler
implements TransactionAware {
    private static final AtomicReferenceFieldUpdater<ConnectionHandler, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(ConnectionHandler.class, State.class, "state");
    private static final TransactionAware.SQLCallable<Boolean> NO_ACTIVE_TRANSACTION = new TransactionAware.SQLCallable<Boolean>(){

        public Boolean call() throws SQLException {
            return false;
        }
    };
    private final Connection connection;
    private final XAResource xaResource;
    private final ConnectionPool connectionPool;
    private final Set<DirtyAttribute> dirtyAttributes = EnumSet.noneOf(DirtyAttribute.class);
    private volatile State state;
    private Thread holdingThread;
    private long lastAccess;
    private boolean enlisted;
    private Future<?> maxLifetimeTask;
    private Collection<ConnectionWrapper> enlistedOpenWrappers = new CopyOnWriteArrayList<ConnectionWrapper>();
    private TransactionAware.SQLCallable<Boolean> transactionActiveCheck = NO_ACTIVE_TRANSACTION;

    public ConnectionHandler(XAConnection xaConnection, ConnectionPool pool) throws SQLException {
        this.connection = xaConnection.getConnection();
        this.xaResource = xaConnection.getXAResource();
        this.connectionPool = pool;
        this.state = State.NEW;
        this.lastAccess = System.nanoTime();
    }

    public ConnectionWrapper newConnectionWrapper() {
        ConnectionWrapper newWrapper = new ConnectionWrapper(this);
        if (this.enlisted) {
            this.enlistedOpenWrappers.add(newWrapper);
        }
        return newWrapper;
    }

    public void onConnectionWrapperClose(ConnectionWrapper wrapper) throws SQLException {
        if (this.enlisted) {
            this.enlistedOpenWrappers.remove(wrapper);
        } else {
            this.connectionPool.returnConnectionHandler(this);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public XAResource getXaResource() {
        return this.xaResource;
    }

    public void resetConnection() throws SQLException {
        this.transactionActiveCheck = NO_ACTIVE_TRANSACTION;
        if (!this.dirtyAttributes.isEmpty()) {
            AgroalConnectionFactoryConfiguration connectionFactoryConfiguration = this.connectionPool.getConfiguration().connectionFactoryConfiguration();
            if (this.dirtyAttributes.contains((Object)DirtyAttribute.AUTOCOMMIT)) {
                this.connection.setAutoCommit(connectionFactoryConfiguration.autoCommit());
            }
            if (this.dirtyAttributes.contains((Object)DirtyAttribute.TRANSACTION_ISOLATION)) {
                this.connection.setTransactionIsolation(connectionFactoryConfiguration.jdbcTransactionIsolation().level());
            }
            this.dirtyAttributes.clear();
        }
        AgroalConnectionPoolConfiguration.ExceptionSorter exceptionSorter = this.connectionPool.getConfiguration().exceptionSorter();
        for (SQLWarning warning = this.connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
            if (exceptionSorter == null || !exceptionSorter.isFatal((SQLException)warning)) continue;
            this.setState(State.FLUSH);
        }
        this.connection.clearWarnings();
    }

    public void closeConnection() throws SQLException {
        if (this.maxLifetimeTask != null && !this.maxLifetimeTask.isDone()) {
            this.maxLifetimeTask.cancel(false);
        }
        this.maxLifetimeTask = null;
        try {
            if (this.state != State.FLUSH) {
                throw new SQLException("Closing connection in incorrect state " + (Object)((Object)this.state));
            }
        }
        finally {
            this.connection.close();
        }
    }

    public boolean setState(State expected, State newState) {
        if (expected == State.DESTROYED) {
            throw new IllegalArgumentException("Trying to move out of state DESTROYED");
        }
        switch (newState) {
            case NEW: {
                throw new IllegalArgumentException("Trying to set invalid state NEW");
            }
            case CHECKED_IN: 
            case CHECKED_OUT: 
            case VALIDATION: 
            case FLUSH: 
            case DESTROYED: {
                return stateUpdater.compareAndSet(this, expected, newState);
            }
        }
        throw new IllegalArgumentException("Trying to set invalid state " + (Object)((Object)newState));
    }

    public void setState(State newState) {
        stateUpdater.set(this, newState);
    }

    public boolean isActive() {
        return stateUpdater.get(this) == State.CHECKED_OUT;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public void setMaxLifetimeTask(Future<?> maxLifetimeTask) {
        this.maxLifetimeTask = maxLifetimeTask;
    }

    public Thread getHoldingThread() {
        return this.holdingThread;
    }

    public void setHoldingThread(Thread holdingThread) {
        this.holdingThread = holdingThread;
    }

    public void setDirtyAttribute(DirtyAttribute attribute) {
        this.dirtyAttributes.add(attribute);
    }

    public boolean isEnlisted() {
        return this.enlisted;
    }

    public void transactionStart() throws SQLException {
        if (!this.enlisted && this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
            this.setDirtyAttribute(DirtyAttribute.AUTOCOMMIT);
        }
        this.enlisted = true;
    }

    public void transactionCommit() throws SQLException {
        for (ConnectionWrapper wrapper : this.enlistedOpenWrappers) {
            ListenerHelper.fireOnWarning(this.connectionPool.getListeners(), "Closing open connection prior to commit");
            wrapper.close();
        }
        this.deferredEnlistmentCheck();
        this.connection.commit();
    }

    public void transactionRollback() throws SQLException {
        for (ConnectionWrapper wrapper : this.enlistedOpenWrappers) {
            ListenerHelper.fireOnWarning(this.connectionPool.getListeners(), "Closing open connection prior to rollback");
            wrapper.close();
        }
        this.deferredEnlistmentCheck();
        this.connection.rollback();
    }

    public void transactionEnd() throws SQLException {
        this.enlisted = false;
        this.connectionPool.returnConnectionHandler(this);
    }

    public void transactionCheckCallback(TransactionAware.SQLCallable<Boolean> transactionCheck) {
        this.transactionActiveCheck = transactionCheck;
    }

    public void deferredEnlistmentCheck() throws SQLException {
        if (!this.enlisted && ((Boolean)this.transactionActiveCheck.call()).booleanValue()) {
            throw new SQLException("Deferred enlistment not supported");
        }
    }

    public void setFlushOnly() {
        this.setState(State.FLUSH);
    }

    public void setFlushOnly(SQLException se) {
        AgroalConnectionPoolConfiguration.ExceptionSorter exceptionSorter = this.connectionPool.getConfiguration().exceptionSorter();
        if (exceptionSorter != null && exceptionSorter.isFatal(se)) {
            this.setState(State.FLUSH);
        }
    }

    public static enum DirtyAttribute {
        AUTOCOMMIT,
        TRANSACTION_ISOLATION,
        NETWORK_TIMEOUT,
        SCHEMA,
        CATALOG;

    }

    public static enum State {
        NEW,
        CHECKED_IN,
        CHECKED_OUT,
        VALIDATION,
        FLUSH,
        DESTROYED;

    }
}

