/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.cache.Acquirable;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.transaction.TransactionAware;
import io.agroal.pool.Pool;
import io.agroal.pool.util.AutoCloseableElement;
import io.agroal.pool.util.ListenerHelper;
import io.agroal.pool.util.UncheckedArrayList;
import io.agroal.pool.wrapper.ConnectionWrapper;
import io.agroal.pool.wrapper.XAConnectionWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.time.Duration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public final class ConnectionHandler
implements TransactionAware,
Acquirable {
    private static final AtomicReferenceFieldUpdater<ConnectionHandler, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(ConnectionHandler.class, State.class, "state");
    private static final TransactionAware.SQLCallable<Boolean> NO_ACTIVE_TRANSACTION = () -> false;
    private final XAConnection xaConnection;
    private final Connection connection;
    private final XAResource xaResource;
    private final Pool connectionPool;
    private final Set<DirtyAttribute> dirtyAttributes = EnumSet.noneOf(DirtyAttribute.class);
    private final AutoCloseableElement enlistedOpenWrappers = AutoCloseableElement.newHead();
    private volatile State state = State.NEW;
    private Thread holdingThread;
    private volatile StackTraceElement[] acquisitionStackTrace;
    private StackTraceElement[] lastOperationStackTrace;
    private List<String> connectionOperations;
    private long lastAccess;
    private boolean enlisted;
    private Future<?> maxLifetimeTask;
    private TransactionAware.SQLCallable<Boolean> transactionActiveCheck = NO_ACTIVE_TRANSACTION;

    public ConnectionHandler(XAConnection xa, Pool pool) throws SQLException {
        this.xaConnection = xa;
        this.connection = this.xaConnection.getConnection();
        this.xaResource = this.xaConnection.getXAResource();
        this.connectionPool = pool;
        this.touch();
    }

    public XAConnectionWrapper xaConnectionWrapper() {
        return new XAConnectionWrapper(this, this.xaConnection, this.connectionPool.getConfiguration().connectionFactoryConfiguration().trackJdbcResources());
    }

    public ConnectionWrapper connectionWrapper() {
        return new ConnectionWrapper(this, this.connectionPool.getConfiguration().connectionFactoryConfiguration().trackJdbcResources(), this.enlisted ? this.enlistedOpenWrappers : null);
    }

    public ConnectionWrapper detachedWrapper() {
        return new ConnectionWrapper(this, this.connectionPool.getConfiguration().connectionFactoryConfiguration().trackJdbcResources(), true);
    }

    public void onConnectionWrapperClose(ConnectionWrapper wrapper, ConnectionWrapper.JdbcResourcesLeakReport leakReport) throws SQLException {
        if (leakReport.hasLeak()) {
            ListenerHelper.fireOnWarning(this.connectionPool.getListeners(), "JDBC resources leaked: " + leakReport.resultSetCount() + " ResultSet(s) and " + leakReport.statementCount() + " Statement(s)");
        }
        if (!this.enlisted && !wrapper.isDetached()) {
            this.transactionEnd();
        }
    }

    public Connection rawConnection() {
        return this.connection;
    }

    public XAResource getXaResource() {
        return this.xaResource;
    }

    public void resetConnection() throws SQLException {
        this.transactionActiveCheck = NO_ACTIVE_TRANSACTION;
        if (!this.dirtyAttributes.isEmpty()) {
            AgroalConnectionFactoryConfiguration connectionFactoryConfiguration = this.connectionPool.getConfiguration().connectionFactoryConfiguration();
            try {
                if (this.dirtyAttributes.contains((Object)DirtyAttribute.AUTOCOMMIT)) {
                    this.connection.setAutoCommit(connectionFactoryConfiguration.autoCommit());
                }
                if (this.dirtyAttributes.contains((Object)DirtyAttribute.TRANSACTION_ISOLATION)) {
                    AgroalConnectionFactoryConfiguration.IsolationLevel isolation = connectionFactoryConfiguration.jdbcTransactionIsolation();
                    this.connection.setTransactionIsolation(isolation.isDefined() ? isolation.level() : this.connectionPool.defaultJdbcIsolationLevel());
                }
                if (this.dirtyAttributes.contains((Object)DirtyAttribute.READ_ONLY)) {
                    this.connection.setReadOnly(connectionFactoryConfiguration.readOnly());
                }
            }
            catch (SQLException se) {
                this.setFlushOnly(se);
                throw se;
            }
            finally {
                this.dirtyAttributes.clear();
            }
        }
        try {
            SQLWarning warning;
            if (warning != null) {
                AgroalConnectionPoolConfiguration.ExceptionSorter exceptionSorter = this.connectionPool.getConfiguration().exceptionSorter();
                for (warning = this.connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    if (exceptionSorter == null || !exceptionSorter.isFatal((SQLException)warning)) continue;
                    this.setState(State.FLUSH);
                }
                this.connection.clearWarnings();
            }
        }
        catch (SQLException se) {
            this.setFlushOnly(se);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws SQLException {
        if (this.maxLifetimeTask != null && !this.maxLifetimeTask.isDone()) {
            this.maxLifetimeTask.cancel(false);
        }
        this.maxLifetimeTask = null;
        try {
            State observedState = stateUpdater.get(this);
            if (observedState != State.FLUSH) {
                throw new SQLException("Closing connection in incorrect state " + String.valueOf((Object)observedState));
            }
        }
        finally {
            try {
                this.xaConnection.close();
            }
            finally {
                stateUpdater.set(this, State.DESTROYED);
            }
        }
    }

    public boolean acquire() {
        return this.setState(State.CHECKED_IN, State.CHECKED_OUT);
    }

    public boolean isAcquirable() {
        State observedState = stateUpdater.get(this);
        return observedState != State.FLUSH && observedState != State.DESTROYED;
    }

    public boolean setState(State expected, State newState) {
        if (expected == State.DESTROYED) {
            throw new IllegalArgumentException("Trying to move out of state DESTROYED");
        }
        switch (newState) {
            case NEW: {
                throw new IllegalArgumentException("Trying to set invalid state NEW");
            }
            case CHECKED_IN: 
            case CHECKED_OUT: 
            case VALIDATION: 
            case FLUSH: 
            case DESTROYED: {
                return stateUpdater.compareAndSet(this, expected, newState);
            }
        }
        throw new IllegalArgumentException("Trying to set invalid state " + String.valueOf((Object)newState));
    }

    public void setState(State newState) {
        stateUpdater.set(this, newState);
    }

    private boolean isActive() {
        State observedState = stateUpdater.get(this);
        return observedState == State.CHECKED_OUT || observedState == State.FLUSH;
    }

    public void touch() {
        this.lastAccess = System.nanoTime();
    }

    public boolean isLeak(Duration timeout) {
        return this.isActive() && !this.enlisted && this.isIdle(timeout);
    }

    public boolean isIdle(Duration timeout) {
        return System.nanoTime() - this.lastAccess > timeout.toNanos();
    }

    public void setMaxLifetimeTask(Future<?> maxLifetimeTask) {
        this.maxLifetimeTask = maxLifetimeTask;
    }

    public boolean isValid() {
        try {
            return this.connectionPool.getConfiguration().connectionValidator().isValid((Connection)this.detachedWrapper());
        }
        catch (Throwable t) {
            ListenerHelper.fireOnWarning(this.connectionPool.getListeners(), t);
            return false;
        }
    }

    public void verifyReadOnly(boolean readOnly) throws SQLException {
        if (this.enlisted) {
            throw new SQLException("Attempted to modify read-only state while enlisted in transaction");
        }
        if (this.connectionPool.getConfiguration().connectionFactoryConfiguration().readOnly() && !readOnly) {
            throw new SQLException("Attempted to modify read-only state of read-only connection");
        }
    }

    public Thread getHoldingThread() {
        return this.holdingThread;
    }

    public void setHoldingThread(Thread holdingThread) {
        this.holdingThread = holdingThread;
    }

    public void traceConnectionOperation(String operation) {
        if (this.acquisitionStackTrace != null) {
            this.connectionOperations.add(operation);
            this.lastOperationStackTrace = Thread.currentThread().getStackTrace();
        }
    }

    public List<String> getConnectionOperations() {
        return this.connectionOperations;
    }

    public StackTraceElement[] getAcquisitionStackTrace() {
        return this.acquisitionStackTrace == null ? null : Arrays.copyOfRange(this.acquisitionStackTrace, 4, this.acquisitionStackTrace.length);
    }

    public void setAcquisitionStackTrace(StackTraceElement[] stackTrace) {
        this.lastOperationStackTrace = null;
        if (this.connectionOperations == null) {
            this.connectionOperations = new UncheckedArrayList<String>(String.class);
        }
        this.connectionOperations.clear();
        this.acquisitionStackTrace = stackTrace;
    }

    public StackTraceElement[] getLastOperationStackTrace() {
        return this.lastOperationStackTrace == null ? null : Arrays.copyOfRange(this.lastOperationStackTrace, 3, this.lastOperationStackTrace.length);
    }

    public void setDirtyAttribute(DirtyAttribute attribute) {
        this.dirtyAttributes.add(attribute);
    }

    public boolean isEnlisted() {
        return this.enlisted;
    }

    public Connection getConnection() {
        return this.detachedWrapper();
    }

    public void transactionStart() throws SQLException {
        try {
            if (!this.enlisted && this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
                this.setDirtyAttribute(DirtyAttribute.AUTOCOMMIT);
            }
            this.enlisted = true;
        }
        catch (SQLException se) {
            this.setFlushOnly(se);
            throw se;
        }
    }

    public void transactionBeforeCompletion(boolean successful) {
        if (this.enlistedOpenWrappers.closeAllAutocloseableElements() != 0 && successful) {
            ListenerHelper.fireOnWarning(this.connectionPool.getListeners(), "Closing open connection(s) prior to commit");
        }
    }

    public void transactionCommit() throws SQLException {
        this.verifyEnlistment();
        try {
            this.connection.commit();
        }
        catch (SQLException se) {
            this.setFlushOnly(se);
            throw se;
        }
    }

    public void transactionRollback() throws SQLException {
        this.verifyEnlistment();
        try {
            this.connection.rollback();
        }
        catch (SQLException se) {
            this.setFlushOnly(se);
            throw se;
        }
    }

    public void transactionEnd() throws SQLException {
        if (this.enlistedOpenWrappers.closeAllAutocloseableElements() != 0) {
            ListenerHelper.fireOnWarning(this.connectionPool.getListeners(), "Closing open connection(s) on after completion");
        }
        this.enlisted = false;
        this.connectionPool.returnConnectionHandler(this);
    }

    public void transactionCheckCallback(TransactionAware.SQLCallable<Boolean> transactionCheck) {
        this.transactionActiveCheck = transactionCheck;
    }

    public void verifyEnlistment() throws SQLException {
        if (!this.enlisted && ((Boolean)this.transactionActiveCheck.call()).booleanValue()) {
            throw new SQLException("Deferred enlistment not supported");
        }
        if (this.enlisted && !((Boolean)this.transactionActiveCheck.call()).booleanValue()) {
            throw new SQLException("Enlisted connection used without active transaction");
        }
    }

    public void setFlushOnly() {
        this.setState(State.FLUSH);
    }

    public void setFlushOnly(SQLException se) {
        AgroalConnectionPoolConfiguration.ExceptionSorter exceptionSorter = this.connectionPool.getConfiguration().exceptionSorter();
        if (exceptionSorter != null && exceptionSorter.isFatal(se)) {
            this.setState(State.FLUSH);
        }
    }

    public static enum DirtyAttribute {
        AUTOCOMMIT,
        TRANSACTION_ISOLATION,
        NETWORK_TIMEOUT,
        SCHEMA,
        CATALOG,
        READ_ONLY;

    }

    public static enum State {
        NEW,
        CHECKED_IN,
        CHECKED_OUT,
        VALIDATION,
        FLUSH,
        DESTROYED;

    }
}

