/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot;

import io.agroal.api.AgroalDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.jdbc.datasource.IsolationLevelDataSourceAdapter;

public class AgroalIsolationLevelDataSourceAdapter
extends IsolationLevelDataSourceAdapter {
    public AgroalIsolationLevelDataSourceAdapter(DataSource targetDataSource) {
        this.setTargetDataSource(targetDataSource);
    }

    protected Connection doGetConnection(@Nullable String username, @Nullable String password) throws SQLException {
        AgroalDataSource agroalDataSource = (AgroalDataSource)DataSourceUnwrapper.unwrap((DataSource)this.obtainTargetDataSource(), AgroalDataSource.class);
        if (agroalDataSource != null) {
            Boolean readOnlyToUse = this.getCurrentReadOnlyFlag();
            Connection con = readOnlyToUse == null ? agroalDataSource.getConnection() : agroalDataSource.getReadOnlyConnection();
            Integer isolationLevelToUse = this.getCurrentIsolationLevel();
            if (isolationLevelToUse != null) {
                con.setTransactionIsolation(isolationLevelToUse);
            }
            return con;
        }
        return super.doGetConnection(username, password);
    }
}

