/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot;

import io.agroal.springframework.boot.AgroalDataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.core.PriorityOrdered;
import org.springframework.transaction.jta.JtaTransactionManager;

class AgroalJdbcConnectionDetailsBeanPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private final ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider;
    private final ObjectProvider<JtaTransactionManager> jtaPlatformProvider;

    public AgroalJdbcConnectionDetailsBeanPostProcessor(ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider, ObjectProvider<JtaTransactionManager> jtaPlatformProvider) {
        this.connectionDetailsProvider = connectionDetailsProvider;
        this.jtaPlatformProvider = jtaPlatformProvider;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        JdbcConnectionDetails connectionDetails;
        if (AgroalDataSource.class.isAssignableFrom(bean.getClass()) && "dataSource".equals(beanName) && (connectionDetails = (JdbcConnectionDetails)this.connectionDetailsProvider.getIfAvailable()) != null) {
            return this.processDataSource((AgroalDataSource)bean, connectionDetails);
        }
        return bean;
    }

    private Object processDataSource(AgroalDataSource dataSource, JdbcConnectionDetails connectionDetails) {
        dataSource.setUrl(connectionDetails.getJdbcUrl());
        dataSource.setUsername(connectionDetails.getUsername());
        dataSource.setPassword(connectionDetails.getPassword());
        JtaTransactionManager jtaPlatform = (JtaTransactionManager)this.jtaPlatformProvider.getIfAvailable();
        if (jtaPlatform != null && jtaPlatform.getTransactionManager() != null && jtaPlatform.getTransactionSynchronizationRegistry() != null) {
            dataSource.setDriverClassName(connectionDetails.getXaDataSourceClassName());
        } else {
            dataSource.setDriverClassName(connectionDetails.getDriverClassName());
        }
        return dataSource;
    }

    public int getOrder() {
        return -2147483646;
    }
}

