/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot.health;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.Status;
import org.springframework.boot.jdbc.DatabaseDriver;

public class AgroalDataSourceHealthIndicator
extends AbstractHealthIndicator {
    private final AgroalDataSource dataSource;

    public AgroalDataSourceHealthIndicator(AgroalDataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        AgroalConnectionPoolConfiguration agroalConnectionPoolConfiguration = this.dataSource.getConfiguration().connectionPoolConfiguration();
        builder.withDetail("provider", (Object)"Agroal");
        builder.withDetail("database", (Object)DatabaseDriver.fromJdbcUrl((String)agroalConnectionPoolConfiguration.connectionFactoryConfiguration().jdbcUrl()));
        builder.withDetail("validator", agroalConnectionPoolConfiguration.connectionValidator().getClass());
        boolean healthy = this.dataSource.isHealthy(false);
        builder.status(healthy ? Status.UP : Status.DOWN);
    }
}

