/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot.metrics;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceMetrics;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.TimeUnit;

public class AgroalDataSourcePoolMetrics
implements MeterBinder {
    public static final String AGROAL_METRIC_NAME_PREFIX = "agroal";
    private static final String METRIC_CATEGORY = "pool";
    private static final String METRIC_CREATION_COUNT = "agroal.connections.creation.count";
    private static final String METRIC_CREATION_TIME_AVG = "agroal.connections.creation.time.average";
    private static final String METRIC_CREATION_TIME_MAX = "agroal.connections.creation.time.max";
    private static final String METRIC_CREATION_TIME_TOTAL = "agroal.connections.creation.time.total";
    private static final String METRIC_LEAK_DETECTION_COUNT = "agroal.leak.detection.count";
    private static final String METRIC_INVALID_COUNT = "agroal.connections.invalid.count";
    private static final String METRIC_FLUSH_COUNT = "agroal.connections.flush.count";
    private static final String METRIC_REAP_COUNT = "agroal.connections.reap.count";
    private static final String METRIC_DESTROY_COUNT = "agroal.connections.destroy.count";
    private static final String METRIC_ACTIVE_COUNT = "agroal.connections.active.count";
    private static final String METRIC_MAX_USED_COUNT = "agroal.connections.max.used.count";
    private static final String METRIC_AVAILABLE_COUNT = "agroal.connections.available.count";
    private static final String METRIC_ACQUIRE_COUNT = "agroal.acquire.count";
    private static final String METRIC_BLOCKING_TIME_AVG = "agroal.blocking.time.average";
    private static final String METRIC_BLOCKING_TIME_MAX = "agroal.blocking.time.max";
    private static final String METRIC_BLOCKING_TIME_TOTAL = "agroal.blocking.time.total";
    private static final String METRIC_AWAITING_COUNT = "agroal.awaiting.count";
    private final String name;
    private final AgroalDataSource dataSource;

    public AgroalDataSourcePoolMetrics(String name, AgroalDataSource dataSource) {
        this.name = name;
        this.dataSource = dataSource;
    }

    public void bindTo(MeterRegistry registry) {
        AgroalDataSourceMetrics metrics = this.dataSource.getMetrics();
        Gauge.builder((String)METRIC_CREATION_COUNT, (Object)metrics, AgroalDataSourceMetrics::creationCount).description("Number of created connections").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        TimeGauge.builder((String)METRIC_CREATION_TIME_AVG, () -> metrics.creationTimeAverage().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS).description("Average time for a connection to be created").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        TimeGauge.builder((String)METRIC_CREATION_TIME_MAX, () -> metrics.creationTimeMax().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS).description("Maximum time for a connection to be created").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        TimeGauge.builder((String)METRIC_CREATION_TIME_TOTAL, () -> metrics.creationTimeTotal().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS).description("Total time waiting for a connections to be created").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        Gauge.builder((String)METRIC_LEAK_DETECTION_COUNT, (Object)metrics, AgroalDataSourceMetrics::leakDetectionCount).description("Number of times a leak was detected").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        Gauge.builder((String)METRIC_INVALID_COUNT, (Object)metrics, AgroalDataSourceMetrics::invalidCount).description("Number of connections removed from the pool for being invalid").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        Gauge.builder((String)METRIC_FLUSH_COUNT, (Object)metrics, AgroalDataSourceMetrics::flushCount).description("Number of connections removed from the pool, not counting invalid / idle").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        Gauge.builder((String)METRIC_REAP_COUNT, (Object)metrics, AgroalDataSourceMetrics::reapCount).description("Number of connections removed from the pool for being idle").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        Gauge.builder((String)METRIC_DESTROY_COUNT, (Object)metrics, AgroalDataSourceMetrics::destroyCount).description("Number of destroyed connections").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        Gauge.builder((String)METRIC_ACTIVE_COUNT, (Object)metrics, AgroalDataSourceMetrics::activeCount).description("Number of active connections").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        Gauge.builder((String)METRIC_MAX_USED_COUNT, (Object)metrics, AgroalDataSourceMetrics::maxUsedCount).description("Maximum number of connections active simultaneously").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        Gauge.builder((String)METRIC_AVAILABLE_COUNT, (Object)metrics, AgroalDataSourceMetrics::availableCount).description("Number of idle connections in the pool, available to be acquired").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        Gauge.builder((String)METRIC_ACQUIRE_COUNT, (Object)metrics, AgroalDataSourceMetrics::acquireCount).description("Number of times an acquire operation succeeded").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        TimeGauge.builder((String)METRIC_BLOCKING_TIME_AVG, () -> metrics.blockingTimeAverage().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS).description("Average time an application waited to acquire a connection").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        TimeGauge.builder((String)METRIC_BLOCKING_TIME_MAX, () -> metrics.blockingTimeMax().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS).description("Maximum time an application waited to acquire a connection").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        TimeGauge.builder((String)METRIC_BLOCKING_TIME_TOTAL, () -> metrics.blockingTimeTotal().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS).description("Total time applications waited to acquire a connection").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
        Gauge.builder((String)METRIC_AWAITING_COUNT, (Object)metrics, AgroalDataSourceMetrics::awaitingCount).description("Approximate number of threads blocked, waiting to acquire a connection").tags(new String[]{METRIC_CATEGORY, this.name}).register(registry);
    }
}

