/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot;

import io.agroal.api.security.AgroalSecurityProvider;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.narayana.NarayanaTransactionIntegration;
import io.agroal.springframework.boot.AgroalDataSource;
import io.agroal.springframework.boot.AgroalJdbcConnectionDetailsBeanPostProcessor;
import io.agroal.springframework.boot.jndi.AgroalDataSourceJndiBinder;
import io.agroal.springframework.boot.jndi.DefaultAgroalDataSourceJndiBinder;
import io.agroal.springframework.boot.metadata.AgroalPoolDataSourceMetadataProviderConfiguration;
import java.util.List;
import javax.sql.DataSource;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jdbc.autoconfigure.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.autoconfigure.DataSourceProperties;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.StringUtils;

@AutoConfiguration(before={DataSourceAutoConfiguration.class})
@ConditionalOnClass(value={AgroalDataSource.class})
@ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="io.agroal.springframework.boot.AgroalDataSource", matchIfMissing=true)
@EnableConfigurationProperties(value={DataSourceProperties.class})
@Import(value={AgroalPoolDataSourceMetadataProviderConfiguration.class})
public class AgroalDataSourceAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(AgroalDataSourceAutoConfiguration.class);
    private final ObjectProvider<JtaTransactionManager> jtaPlatformProvider;
    private final ObjectProvider<XAResourceRecoveryRegistry> recoveryRegistryProvider;
    private final ObjectProvider<AgroalDataSourceJndiBinder> jndiBinder;
    private final ObjectProvider<AgroalSecurityProvider> securityProvider;

    public AgroalDataSourceAutoConfiguration(ObjectProvider<JtaTransactionManager> jtaPlatformProvider, ObjectProvider<XAResourceRecoveryRegistry> recoveryRegistryProvider, ObjectProvider<AgroalDataSourceJndiBinder> jndiBinder, ObjectProvider<AgroalSecurityProvider> securityProvider) {
        this.jtaPlatformProvider = jtaPlatformProvider;
        this.recoveryRegistryProvider = recoveryRegistryProvider;
        this.jndiBinder = jndiBinder;
        this.securityProvider = securityProvider;
    }

    @Bean
    static AgroalJdbcConnectionDetailsBeanPostProcessor agroalJdbcConnectionDetailsBeanPostProcessor(ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider, ObjectProvider<JtaTransactionManager> jtaPlatformProvider) {
        return new AgroalJdbcConnectionDetailsBeanPostProcessor(connectionDetailsProvider, jtaPlatformProvider);
    }

    @Bean
    @ConfigurationProperties(prefix="spring.datasource.agroal")
    @ConditionalOnMissingBean(value={DataSource.class})
    public AgroalDataSource dataSource(DataSourceProperties properties, @Value(value="${spring.datasource.agroal.jta:true}") boolean jta, @Value(value="${spring.datasource.agroal.connectable:false}") boolean connectable, @Value(value="${spring.datasource.agroal.first-resource:false}") boolean firstResource, @Value(value="${spring.datasource.agroal.credentials:#{{}}}") List<Object> credentials, @Value(value="${spring.datasource.agroal.recovery-credentials:#{{}}}") List<Object> recoveryCredentials) {
        AgroalDataSource dataSource = (AgroalDataSource)((Object)properties.initializeDataSourceBuilder().type(AgroalDataSource.class).build());
        if (!StringUtils.hasLength((String)properties.getDriverClassName())) {
            if (connectable) {
                dataSource.setDriverClassName(DatabaseDriver.fromJdbcUrl((String)properties.determineUrl()).getDriverClassName());
            } else if (StringUtils.hasLength((String)properties.getXa().getDataSourceClassName())) {
                dataSource.setDriverClassName(properties.getXa().getDataSourceClassName());
            } else {
                dataSource.setDriverClassName(DatabaseDriver.fromJdbcUrl((String)properties.determineUrl()).getXaDataSourceClassName());
            }
        }
        String name = properties.determineDatabaseName();
        dataSource.setName(name);
        JtaTransactionManager jtaPlatform = (JtaTransactionManager)this.jtaPlatformProvider.getIfAvailable();
        if (jta && jtaPlatform != null && jtaPlatform.getTransactionManager() != null && jtaPlatform.getTransactionSynchronizationRegistry() != null) {
            Object jndiName = properties.getJndiName() != null ? properties.getJndiName() : "java:comp/env/jdbc/" + name;
            dataSource.setJtaTransactionIntegration((TransactionIntegration)new NarayanaTransactionIntegration(jtaPlatform.getTransactionManager(), jtaPlatform.getTransactionSynchronizationRegistry(), (String)jndiName, connectable, firstResource, connectable ? null : (XAResourceRecoveryRegistry)this.recoveryRegistryProvider.getIfAvailable()));
            if (connectable && ((AgroalDataSourceJndiBinder)this.jndiBinder.getIfUnique(DefaultAgroalDataSourceJndiBinder::new)).bindToJndi((String)jndiName, dataSource)) {
                this.logger.info("Bind DataSource {} as {} to JNDI registry", (Object)name, jndiName);
            }
        }
        if (!connectable && !properties.getXa().getProperties().isEmpty()) {
            dataSource.setXaProperties(properties.getXa().getProperties());
        }
        this.securityProvider.orderedStream().forEach(dataSource::addSecurityProvider);
        credentials.forEach(dataSource::addCredential);
        recoveryCredentials.forEach(dataSource::addRecoveryCredential);
        return dataSource;
    }
}

