/*
 * Decompiled with CFR 0.152.
 */
package io.scepta.builder;

import io.scepta.model.Tag;
import io.scepta.server.BuildServer;
import io.scepta.server.DeploymentServer;
import io.scepta.server.DesignRepository;
import io.scepta.server.GeneratedResult;
import io.scepta.server.Generator;
import io.scepta.server.GeneratorFactory;
import io.scepta.server.PolicyGroupInterchange;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DefaultBuildServer
implements BuildServer {
    private static final int POOL_SIZE = 10;
    private DesignRepository _repository;
    private Generator _generator;
    private DeploymentServer _deploymentServer;
    private ExecutorService _executorService = Executors.newFixedThreadPool(10);

    public void setRepository(DesignRepository repo) {
        this._repository = repo;
    }

    public DesignRepository getRepository() {
        if (this._repository == null) {
            ServiceLoader<DesignRepository> sl = ServiceLoader.load(DesignRepository.class);
            this._repository = sl.iterator().next();
        }
        return this._repository;
    }

    public void setDeploymentServer(DeploymentServer ds) {
        this._deploymentServer = ds;
    }

    public DeploymentServer getDeploymentServer() {
        if (this._deploymentServer == null) {
            ServiceLoader<DeploymentServer> sl = ServiceLoader.load(DeploymentServer.class);
            this._deploymentServer = sl.iterator().next();
        }
        return this._deploymentServer;
    }

    protected Generator getGenerator() {
        if (this._generator == null) {
            this._generator = GeneratorFactory.get();
        }
        return this._generator;
    }

    public void schedule(final String org, final String group, final String tagName) {
        Tag tag = this.getRepository().getTag(org, group, tagName);
        if (tag == null) {
            throw new RuntimeException("Could not find tag '" + tagName + "'");
        }
        tag.setBuildStatus(Tag.BuildStatus.Scheduled);
        this.getRepository().updateTag(org, group, tag);
        this._executorService.execute(new Runnable(){

            @Override
            public void run() {
                PolicyGroupInterchange pgi = DefaultBuildServer.this.getRepository().exportPolicyGroup(org, group, tagName);
                Tag tag = DefaultBuildServer.this.getRepository().getTag(org, group, tagName);
                if (pgi != null && tag != null) {
                    tag.setBuildStatus(Tag.BuildStatus.Building);
                    DefaultBuildServer.this.getRepository().updateTag(org, group, tag);
                    Generator gen = DefaultBuildServer.this.getGenerator();
                    if (gen != null) {
                        GeneratedResult result = gen.generate(pgi);
                        if (result != null) {
                            try {
                                ByteArrayOutputStream os = new ByteArrayOutputStream();
                                result.asZip((OutputStream)os);
                                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                                os.close();
                                DefaultBuildServer.this.getDeploymentServer().deploy(org, group, tag.getName(), (InputStream)is);
                                is.close();
                                tag.setBuildStatus(Tag.BuildStatus.Successful);
                                DefaultBuildServer.this.getRepository().updateTag(org, group, tag);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                tag.setBuildStatus(Tag.BuildStatus.Failed);
                                DefaultBuildServer.this.getRepository().updateTag(org, group, tag);
                            }
                        } else {
                            tag.setBuildStatus(Tag.BuildStatus.Failed);
                            DefaultBuildServer.this.getRepository().updateTag(org, group, tag);
                            System.err.println("NO GENERATED RESULT");
                        }
                    } else {
                        tag.setBuildStatus(Tag.BuildStatus.Failed);
                        DefaultBuildServer.this.getRepository().updateTag(org, group, tag);
                        System.err.println("NO GENERATOR");
                    }
                } else {
                    tag.setBuildStatus(Tag.BuildStatus.Failed);
                    DefaultBuildServer.this.getRepository().updateTag(org, group, tag);
                    System.err.println("COULD NOT FIND POLICY GROUP INTERCHANGE (" + pgi + ") OR TAG (" + tag + ")");
                }
            }
        });
    }
}

