/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.protocol;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpResponseInterceptor;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.entity.DeflateDecompressingEntity;
import ch.boye.httpclientandroidlib.client.entity.GzipDecompressingEntity;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.io.IOException;
import java.util.Locale;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HeaderElement[] codecs;
        HeaderElement[] arr$;
        int len$;
        int i$;
        Header ceheader;
        HttpEntity entity = response.getEntity();
        if (entity != null && (ceheader = entity.getContentEncoding()) != null && (i$ = 0) < (len$ = (arr$ = (codecs = ceheader.getElements())).length)) {
            HeaderElement codec = arr$[i$];
            String codecname = codec.getName().toLowerCase(Locale.US);
            if ("gzip".equals(codecname) || "x-gzip".equals(codecname)) {
                response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                if (context != null) {
                    context.setAttribute(UNCOMPRESSED, true);
                }
                return;
            }
            if ("deflate".equals(codecname)) {
                response.setEntity(new DeflateDecompressingEntity(response.getEntity()));
                if (context != null) {
                    context.setAttribute(UNCOMPRESSED, true);
                }
                return;
            }
            if ("identity".equals(codecname)) {
                return;
            }
            throw new HttpException("Unsupported Content-Coding: " + codec.getName());
        }
    }
}

