/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class JaasAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_REALM = "CAS";
    private String realm;
    static /* synthetic */ Class class$javax$security$auth$callback$NameCallback;
    static /* synthetic */ Class class$javax$security$auth$callback$PasswordCallback;

    protected boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials credentials) throws AuthenticationException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting authentication for: " + credentials.getUsername()));
            }
            LoginContext lc = new LoginContext(this.realm, new UsernamePasswordCallbackHandler(credentials.getUsername(), credentials.getPassword()));
            lc.login();
            lc.logout();
        }
        catch (LoginException fle) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Authentication failed for: " + credentials.getUsername()));
            }
            fle.printStackTrace();
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication succeeded for: " + credentials.getUsername()));
        }
        return true;
    }

    protected void afterPropertiesSetInternal() throws Exception {
        if (!StringUtils.hasText((String)this.realm)) {
            this.log.info((Object)"No default realm set.  Using default realm of: CAS");
            this.realm = DEFAULT_REALM;
        }
        Assert.notNull((Object)Configuration.getConfiguration(), (String)"Static Configuration cannot be null. Did you remember to specify \"java.security.auth.login.config\"?");
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    protected class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final String password;

        protected UsernamePasswordCallbackHandler(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                Callback callback = callbacks[i];
                if (callback.getClass().equals(class$javax$security$auth$callback$NameCallback == null ? JaasAuthenticationHandler.class$("javax.security.auth.callback.NameCallback") : class$javax$security$auth$callback$NameCallback)) {
                    ((NameCallback)callback).setName(this.userName);
                    continue;
                }
                if (callback.getClass().equals(class$javax$security$auth$callback$PasswordCallback == null ? JaasAuthenticationHandler.class$("javax.security.auth.callback.PasswordCallback") : class$javax$security$auth$callback$PasswordCallback)) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
        }
    }
}

