/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.web.flow.util.ContextUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class AutomaticCookiePathSetterAction
extends AbstractAction
implements InitializingBean {
    private CookieGenerator warnCookieGenerator;
    private CookieGenerator ticketGrantingTicketCookieGenerator;
    private boolean pathPopulated = false;

    protected Event doExecute(RequestContext context) throws Exception {
        if (!this.pathPopulated) {
            HttpServletRequest request = ContextUtils.getHttpServletRequest(context);
            this.logger.info((Object)("Setting ContextPath for cookies to: " + request.getContextPath()));
            this.warnCookieGenerator.setCookiePath(request.getContextPath());
            this.ticketGrantingTicketCookieGenerator.setCookiePath(request.getContextPath());
            this.pathPopulated = true;
        }
        return this.result("success");
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.warnCookieGenerator, (String)"warnCookieGenerator cannot be null.");
        Assert.notNull((Object)this.ticketGrantingTicketCookieGenerator, (String)"ticketGrantingTicketCookieGenerator cannot be null.");
    }

    public void setTicketGrantingTicketCookieGenerator(CookieGenerator ticketGrantingTicketCookieGenerator) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    public void setWarnCookieGenerator(CookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }
}

