/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.IORInterceptorIterator;
import org.jacorb.orb.portableInterceptor.PICurrentImpl;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorManager {
    private static final Comparator INTERCEPTOR_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            Interceptor interceptor = (Interceptor)object;
            Interceptor interceptor2 = (Interceptor)object2;
            return interceptor.name().compareTo(interceptor2.name());
        }
    };
    private final Interceptor[] client_req_interceptors;
    private final Interceptor[] server_req_interceptors;
    private final Interceptor[] ior_interceptors;
    private int[] profile_tags = null;
    private final org.omg.CORBA.ORB orb;
    private final int current_slots;
    private final Logger logger;
    private static final ThreadLocal piCurrent = new ThreadLocal();
    public static final PICurrentImpl EMPTY_CURRENT = new PICurrentImpl(null, 0);

    public InterceptorManager(List list, List list2, List list3, int n, ORB oRB) {
        this.logger = oRB.getConfiguration().getNamedLogger("jacorb.orb.interceptors");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("InterceptorManager started with " + list2.size() + " Server Interceptors, " + list.size() + " Client Interceptors and " + list3.size() + " IOR Interceptors");
        }
        this.client_req_interceptors = list.toArray(new ClientRequestInterceptor[list.size()]);
        Arrays.sort(this.client_req_interceptors, INTERCEPTOR_COMPARATOR);
        this.server_req_interceptors = list2.toArray(new ServerRequestInterceptor[list2.size()]);
        Arrays.sort(this.server_req_interceptors, INTERCEPTOR_COMPARATOR);
        this.ior_interceptors = list3.toArray(new IORInterceptor[list3.size()]);
        Arrays.sort(this.ior_interceptors, INTERCEPTOR_COMPARATOR);
        this.orb = oRB;
        this.current_slots = n;
    }

    public Current getCurrent() {
        Current current = (Current)piCurrent.get();
        if (current == null) {
            current = this.getEmptyCurrent();
            piCurrent.set(current);
        }
        return current;
    }

    public void setTSCurrent(Current current) {
        piCurrent.set(current);
    }

    public void removeTSCurrent() {
        piCurrent.set(null);
    }

    public Current getEmptyCurrent() {
        return new PICurrentImpl(this.orb, this.current_slots);
    }

    public ClientInterceptorIterator getClientIterator() {
        return new ClientInterceptorIterator(this.logger, this.client_req_interceptors);
    }

    public ServerInterceptorIterator getServerIterator() {
        return new ServerInterceptorIterator(this.server_req_interceptors);
    }

    public IORInterceptorIterator getIORIterator() {
        return new IORInterceptorIterator(this.logger, this.ior_interceptors, this.profile_tags);
    }

    public void setProfileTags(int[] nArray) {
        this.profile_tags = nArray;
    }

    public boolean hasClientRequestInterceptors() {
        return this.client_req_interceptors.length > 0;
    }

    public boolean hasServerRequestInterceptors() {
        return this.server_req_interceptors.length > 0;
    }

    public boolean hasIORInterceptors() {
        return this.ior_interceptors.length > 0;
    }

    public void destroy() {
        int n;
        if (this.hasClientRequestInterceptors()) {
            for (n = 0; n < this.client_req_interceptors.length; ++n) {
                this.client_req_interceptors[n].destroy();
            }
        }
        if (this.hasServerRequestInterceptors()) {
            for (n = 0; n < this.server_req_interceptors.length; ++n) {
                this.server_req_interceptors[n].destroy();
            }
        }
        if (this.hasIORInterceptors()) {
            for (n = 0; n < this.ior_interceptors.length; ++n) {
                this.ior_interceptors[n].destroy();
            }
        }
        if (null != piCurrent.get()) {
            this.removeTSCurrent();
        }
    }
}

