/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.defaults.ComponentMonitorStrategy;
import org.picocontainer.monitors.DefaultComponentMonitor;

public class DelegatingComponentMonitor
implements ComponentMonitor,
ComponentMonitorStrategy,
Serializable {
    private ComponentMonitor delegate;

    public DelegatingComponentMonitor(ComponentMonitor componentMonitor) {
        this.checkMonitor(componentMonitor);
        this.delegate = componentMonitor;
    }

    public DelegatingComponentMonitor() {
        this(DefaultComponentMonitor.getInstance());
    }

    public void instantiating(Constructor constructor) {
        this.delegate.instantiating(constructor);
    }

    public void instantiated(Constructor constructor, long l) {
        this.delegate.instantiated(constructor, l);
    }

    public void instantiationFailed(Constructor constructor, Exception exception) {
        this.delegate.instantiationFailed(constructor, exception);
    }

    public void invoking(Method method, Object object) {
        this.delegate.invoking(method, object);
    }

    public void invoked(Method method, Object object, long l) {
        this.delegate.invoked(method, object, l);
    }

    public void invocationFailed(Method method, Object object, Exception exception) {
        this.delegate.invocationFailed(method, object, exception);
    }

    public void lifecycleInvocationFailed(Method method, Object object, RuntimeException runtimeException) {
        this.delegate.lifecycleInvocationFailed(method, object, runtimeException);
    }

    public void changeMonitor(ComponentMonitor componentMonitor) {
        this.checkMonitor(componentMonitor);
        if (this.delegate instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.delegate)).changeMonitor(componentMonitor);
        } else {
            this.delegate = componentMonitor;
        }
    }

    public ComponentMonitor currentMonitor() {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)((Object)this.delegate)).currentMonitor();
        }
        return this.delegate;
    }

    private void checkMonitor(ComponentMonitor componentMonitor) {
        if (componentMonitor == null) {
            throw new NullPointerException("monitor");
        }
    }
}

