/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1999-2004 Gerald Brose
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
package org.jacorb.ir.gui.typesystem;


/**
 * This class was generated by a SmartGuide.
 *
 */

import java.lang.reflect.Method;

import javax.swing.tree.DefaultMutableTreeNode;

public abstract class TypeSystemNode
    extends ModelParticipant
{
    protected DefaultMutableTreeNode treeNode;
    protected String name = "";
    protected String absoluteName = "";

    /**
     */
    public TypeSystemNode ( ) {
    }

    protected TypeSystemNode ( DefaultMutableTreeNode treeNode) {
        this();
        this.treeNode = treeNode;
    }

    /**
     * @param name java.lang.String
     */

    public TypeSystemNode ( String name) {
    this();
    this.name = name;
    }

    /**
     * Gibt Array mit Strings zurück: die Node-Typen, die zu dieser Node
     * hinzugefügt werden können.
     * IRModule z.B. gibt "module", "interface" usw. zurück.
     * @return java.util.Enumeration
     */

    public String[] allowedToAdd ( )
    {
        return null;
    }

    /**
     * @return int
     * @param other org.jacorb.ir.gui.typesystem.ModelParticipant
     */
    public int compareTo(ModelParticipant other) {
    return this.toString().compareTo(other.toString());
    }

    /**
     * @return java.lang.String
     */

    public  String description() {
    return  getInstanceNodeTypeName() + " " + getAbsoluteName();
    }

    /**
     * @return java.lang.String
     */
    public String getAbsoluteName() {
    return absoluteName;
    }

    /**
     * @return java.lang.String
     */

    public String getInstanceNodeTypeName ( )
    {
    // Für die Textrepräsentation einer Node kann nodeTypeName abhängig vom Zustand sein,
    // z.B. bei IRAttribute: gegebenenfalls muß es dort "readonly attribute" heißen und nicht "attribute"
    // Dynamischen Lookup einer static Methode simulieren:
    Method nodeTypeNameMethod;
    String nodeTypeName = "";
    try {
            nodeTypeNameMethod = getClass().getMethod("nodeTypeName", new Class[0]);
            nodeTypeName = (String) nodeTypeNameMethod.invoke(null, new Object[0]) ;
    }
    catch (Exception e) {
            e.printStackTrace();
    }
    return nodeTypeName;
    }

    /**
     * @return java.lang.String
     */

    public String getName ( )
    {
        return name;
    }

    /**
     * Füge neues Child zu Node hinzu. Wird nur von TypeSystem.insertChild(..) aufgerufen.
     * Macht hier nichts als Exception zu werfen, wenn newChild nicht zugelassen ist, muß also
     * von Unterklassen überschrieben werden, um z.B. entsprechende Methode auf IR aufzurufen.
     * Bei illegalem Child-Typ wird IllegalChildException geworfen.
     * @param newChild TypeSystemNode
     */

    protected void insertChild ( TypeSystemNode newChild)
        throws IllegalChildException
    {
    String[] allowedTypes = allowedToAdd();
    int i;
    for (i = 0;
             i <allowedTypes.length && !allowedTypes[i].equals(TypeSystemNode.nodeTypeName());
             i++);

    if (!allowedTypes[i].equals(TypeSystemNode.nodeTypeName())) {
            throw new IllegalChildException();
    }
    // Das eigentliche Einfügen der DefaultMutableTreeNode wird von TypeSystem vorgenommen,
    // um entsprechende Events des TreeModels wird sich dort gekümmert.
    // Unterklassen müssen Methode überschreiben (inkl. Aufruf von super.addChild(..)) und z.B.
    // entsprechende Methode auf dem InterfaceRepository aufrufen
    }

    /**
     * Gib den Namen des Typen der Node zurück, z.B. den IDL-Bezeichner "Module"
     * @return java.lang.String
     */

    public static String nodeTypeName ( ) {
    // static Methoden können nicht abstract sein
    return null;
    }

    /**
     */
    protected void setAbsoluteName(String absoluteName ) {
    this.absoluteName = absoluteName;
    }

    /**
     * wird von Unterklassen von TypeSystemNode aufgerufen, deswegen protected
     * @param name java.lang.String
     */

    protected void setName( String name) {
    this.name = name;
    }

    /**
     * Soll möglichst IDL-ähnliche komplette Textrepräsentation zurückgeben
     * aber nur der Node selbst.
     * @return java.lang.String
     */
    public String toString ( ) {
    return getInstanceNodeTypeName() + " " + getName();
    }
}













