/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1999-2004 Gerald Brose
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
package org.jacorb.ir.gui.typesystem.remote;


import org.omg.CORBA.*;
import org.jacorb.ir.gui.typesystem.*;

/**
 * This class was generated by a SmartGuide.
 * 
 */
public class IRNodeWithType extends IRNode implements TypeAssociator{
	private String associatedType;
	private TypeSystemNode associatedTypeNode = null;



/**
 * IRNodeWithType constructor comment.
 */
protected IRNodeWithType() {
	super();
}
/**
 * IRNodeWithType constructor comment.
 * @param irObject org.omg.CORBA.IRObject
 */
protected IRNodeWithType(org.omg.CORBA.IRObject irObject) {
	super(irObject);
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String description() {
	String result = super.description();
	if (getAssociatedType()!=null) {
		result = result + "\nType:\t" + getAssociatedType();
	}	
	return result;	
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getAssociatedType ( ) {
	if (getAssociatedTypeSystemNode()!=null) {
		return getAssociatedTypeSystemNode().getAbsoluteName();
	}
	else return "--";
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public TypeSystemNode getAssociatedTypeSystemNode() {
	return associatedTypeNode;
}
/**
 * This method was created by a SmartGuide.
 */
protected void setAssociatedTypeSystemNode(TypeSystemNode typeNode) {
	this.associatedTypeNode = typeNode;
}
}

















