/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.ResponseStateManagerImpl;
import com.sun.faces.renderkit.html_basic.HtmlResponseWriter;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitImpl
extends RenderKit {
    private static final String[] SUPPORTED_CONTENT_TYPES_ARRAY = new String[]{"text/html", "application/xhtml+xml", "application/xml", "text/xml"};
    private static final String SUPPORTED_CONTENT_TYPES = "text/html,application/xhtml+xml,application/xml,text/xml";
    private ConcurrentHashMap<String, HashMap<String, Renderer>> rendererFamilies = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ClientBehaviorRenderer> behaviorRenderers = new ConcurrentHashMap();
    private ResponseStateManager responseStateManager = new ResponseStateManagerImpl();
    private WebConfiguration webConfig;

    public RenderKitImpl() {
        FacesContext context = FacesContext.getCurrentInstance();
        this.webConfig = WebConfiguration.getInstance(context.getExternalContext());
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        if (family == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "family");
            throw new NullPointerException(message);
        }
        if (rendererType == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "rendererType");
            throw new NullPointerException(message);
        }
        if (renderer == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "renderer");
            throw new NullPointerException(message);
        }
        HashMap<String, Object> renderers = this.rendererFamilies.get(family);
        if (renderers == null) {
            renderers = new HashMap();
            this.rendererFamilies.put(family, renderers);
        }
        renderers.put(rendererType, renderer);
    }

    public Renderer getRenderer(String family, String rendererType) {
        if (rendererType == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "rendererType");
            throw new NullPointerException(message);
        }
        if (family == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "family");
            throw new NullPointerException(message);
        }
        assert (this.rendererFamilies != null);
        HashMap<String, Renderer> renderers = this.rendererFamilies.get(family);
        return renderers != null ? renderers.get(rendererType) : null;
    }

    public void addClientBehaviorRenderer(String behaviorRendererType, ClientBehaviorRenderer behaviorRenderer) {
        if (behaviorRendererType == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "behaviorRendererType");
            throw new NullPointerException(message);
        }
        if (behaviorRenderer == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "behaviorRenderer");
            throw new NullPointerException(message);
        }
        this.behaviorRenderers.put(behaviorRendererType, behaviorRenderer);
    }

    public ClientBehaviorRenderer getClientBehaviorRenderer(String behaviorRendererType) {
        if (behaviorRendererType == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "behaviorRendererType");
            throw new NullPointerException(message);
        }
        return this.behaviorRenderers != null ? this.behaviorRenderers.get(behaviorRendererType) : null;
    }

    public synchronized ResponseStateManager getResponseStateManager() {
        if (this.responseStateManager == null) {
            this.responseStateManager = new ResponseStateManagerImpl();
        }
        return this.responseStateManager;
    }

    public ResponseWriter createResponseWriter(Writer writer, String desiredContentTypeList, String characterEncoding) {
        if (writer == null) {
            return null;
        }
        String contentType = null;
        boolean contentTypeNullFromResponse = false;
        FacesContext context = FacesContext.getCurrentInstance();
        if (null != desiredContentTypeList) {
            contentType = this.findMatch(desiredContentTypeList, SUPPORTED_CONTENT_TYPES_ARRAY);
        }
        if (null == desiredContentTypeList && null != (desiredContentTypeList = context.getExternalContext().getResponseContentType()) && null == (contentType = this.findMatch(desiredContentTypeList, SUPPORTED_CONTENT_TYPES_ARRAY))) {
            contentTypeNullFromResponse = true;
        }
        if (null == desiredContentTypeList || contentTypeNullFromResponse) {
            String[] typeArray = (String[])context.getExternalContext().getRequestHeaderValuesMap().get("Accept");
            if (typeArray.length > 0) {
                StringBuffer buff = new StringBuffer();
                buff.append(typeArray[0]);
                int len = typeArray.length;
                for (int i = 1; i < len; ++i) {
                    buff.append(',');
                    buff.append(typeArray[i]);
                }
                desiredContentTypeList = buff.toString();
            }
            if (null != desiredContentTypeList && null != (desiredContentTypeList = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.PreferXHTMLContentType) ? RenderKitUtils.determineContentType(desiredContentTypeList, SUPPORTED_CONTENT_TYPES, "application/xhtml+xml") : RenderKitUtils.determineContentType(desiredContentTypeList, SUPPORTED_CONTENT_TYPES, null))) {
                contentType = this.findMatch(desiredContentTypeList, SUPPORTED_CONTENT_TYPES_ARRAY);
            }
        }
        if (contentType == null) {
            if (null == desiredContentTypeList) {
                contentType = "text/html";
            } else {
                String[] desiredContentTypes;
                for (String desiredContentType : desiredContentTypes = this.contentTypeSplit(desiredContentTypeList)) {
                    if (!"*/*".equals(desiredContentType.trim())) continue;
                    contentType = "text/html";
                }
            }
        }
        if (null == contentType) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.CONTENT_TYPE_ERROR", new Object[0]));
        }
        if (characterEncoding == null) {
            characterEncoding = "ISO-8859-1";
        }
        boolean scriptHiding = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableJSStyleHiding);
        boolean scriptInAttributes = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableScriptInAttributeValue);
        WebConfiguration.DisableUnicodeEscaping escaping = WebConfiguration.DisableUnicodeEscaping.getByValue(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.DisableUnicodeEscaping));
        return new HtmlResponseWriter(writer, contentType, characterEncoding, scriptHiding, scriptInAttributes, escaping);
    }

    private String[] contentTypeSplit(String contentTypeString) {
        String[] result = Util.split(contentTypeString, ",");
        for (int i = 0; i < result.length; ++i) {
            int semicolon = result[i].indexOf(";");
            if (-1 == semicolon) continue;
            result[i] = result[i].substring(0, semicolon);
        }
        return result;
    }

    private String findMatch(String desiredContentTypeList, String[] supportedTypes) {
        String contentType = null;
        for (String curDesiredType : this.contentTypeSplit(desiredContentTypeList)) {
            int jlen = supportedTypes.length;
            for (int j = 0; j < jlen; ++j) {
                String curContentType = supportedTypes[j].trim();
                if (!curDesiredType.contains(curContentType)) continue;
                if (curContentType.contains("text/html")) {
                    contentType = "text/html";
                    break;
                }
                if (!curContentType.contains("application/xhtml+xml") && !curContentType.contains("application/xml") && !curContentType.contains("text/xml")) break;
                contentType = "application/xhtml+xml";
                break;
            }
            if (null != contentType) break;
        }
        return contentType;
    }

    public ResponseStream createResponseStream(OutputStream out) {
        final OutputStream output = out;
        return new ResponseStream(){

            public void write(int b) throws IOException {
                output.write(b);
            }

            public void write(byte[] b) throws IOException {
                output.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                output.write(b, off, len);
            }

            public void flush() throws IOException {
                output.flush();
            }

            public void close() throws IOException {
                output.close();
            }
        };
    }

    public Iterator<String> getComponentFamilies() {
        return this.rendererFamilies.keySet().iterator();
    }

    public Iterator<String> getRendererTypes(String componentFamily) {
        Map family = this.rendererFamilies.get(componentFamily);
        if (family != null) {
            return family.keySet().iterator();
        }
        Set empty = Collections.emptySet();
        return empty.iterator();
    }
}

