/*
 * Decompiled with CFR 0.152.
 */
package javax.time;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.TimeZone;
import javax.time.calendar.YearMonth;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.field.Year;

public abstract class Clock {
    public static Clock system() {
        return Clock.system(TimeZone.UTC);
    }

    public static Clock system(TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("timeZone must not be null");
        }
        return new SystemMillis(timeZone);
    }

    public abstract Instant instant();

    public abstract TimeZone timeZone();

    public Year currentYear() {
        return this.today().getYear();
    }

    public YearMonth currentMonth() {
        return this.today().getYearMonth();
    }

    public LocalDate today() {
        return this.currentZonedDateTime().localDate();
    }

    public LocalDate yesterday() {
        return this.today().plusDays(-1L);
    }

    public LocalDate tomorrow() {
        return this.today().plusDays(1L);
    }

    public LocalTime currentTime() {
        return this.currentZonedDateTime().localTime();
    }

    public LocalDateTime currentDateTime() {
        return this.currentZonedDateTime().localDateTime();
    }

    public ZonedDateTime currentZonedDateTime() {
        return ZonedDateTime.dateTime((Instant)this.instant(), (TimeZone)this.timeZone());
    }

    private static final class SystemMillis
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final TimeZone timeZone;

        SystemMillis(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public Instant instant() {
            return Instant.millisInstant(System.currentTimeMillis());
        }

        @Override
        public TimeZone timeZone() {
            return this.timeZone;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof SystemMillis)) {
                return false;
            }
            SystemMillis systemMillis = (SystemMillis)object;
            return this.timeZone == systemMillis.timeZone || this.timeZone.equals(systemMillis.timeZone);
        }

        public int hashCode() {
            int n = 7;
            n = 41 * n + this.timeZone.hashCode();
            return n;
        }
    }
}

