/*
 * Decompiled with CFR 0.152.
 */
package javax.time;

import java.io.Serializable;
import java.math.BigInteger;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.MathUtils;
import javax.time.calendar.format.CalendricalParseException;

public final class Duration
implements Comparable<Duration>,
Serializable {
    public static final Duration ZERO = new Duration(0L, 0);
    private static final BigInteger BILLION = BigInteger.valueOf(1000000000L);
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final long serialVersionUID = -835275378278L;
    private final long seconds;
    private final int nanoAdjustment;

    public static Duration seconds(long l) {
        if (l == 0L) {
            return ZERO;
        }
        return new Duration(l, 0);
    }

    public static Duration seconds(long l, long l2) {
        if (l == 0L && l2 == 0L) {
            return ZERO;
        }
        long l3 = MathUtils.safeAdd(l, l2 / 1000000000L);
        int n = (int)(l2 % 1000000000L);
        if (n < 0) {
            n += 1000000000;
            l3 = MathUtils.safeDecrement(l3);
        }
        return new Duration(l3, n);
    }

    public static Duration millis(long l) {
        if (l == 0L) {
            return ZERO;
        }
        long l2 = l / 1000L;
        int n = (int)(l % 1000L);
        if (n < 0) {
            n += 1000;
            --l2;
        }
        return new Duration(l2, n * 1000000);
    }

    public static Duration millis(long l, long l2) {
        if (l == 0L && l2 == 0L) {
            return ZERO;
        }
        long l3 = l / 1000L + l2 / 1000000000L;
        long l4 = l % 1000L * 1000000L + l2 % 1000000000L;
        l3 += l4 / 1000000000L;
        int n = (int)(l4 % 1000000000L);
        if (n < 0) {
            n += 1000000000;
            --l3;
        }
        return new Duration(l3, n);
    }

    public static Duration nanos(long l) {
        if (l == 0L) {
            return ZERO;
        }
        long l2 = l / 1000000000L;
        int n = (int)(l % 1000000000L);
        if (n < 0) {
            n += 1000000000;
            --l2;
        }
        return new Duration(l2, n);
    }

    public static Duration nanos(BigInteger bigInteger) {
        Instant.checkNotNull(bigInteger, "Nanos must not be null");
        if (bigInteger.equals(BigInteger.ZERO)) {
            return ZERO;
        }
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BILLION);
        if (bigIntegerArray[0].bitLength() > 63) {
            throw new ArithmeticException("Exceeds capacity of Duration: " + bigInteger);
        }
        return Duration.seconds(bigIntegerArray[0].longValue(), bigIntegerArray[1].intValue());
    }

    public static Duration standardMinutes(long l) {
        if (l == 0L) {
            return ZERO;
        }
        return new Duration(MathUtils.safeMultiply(l, 60), 0);
    }

    public static Duration standardHours(long l) {
        if (l == 0L) {
            return ZERO;
        }
        return new Duration(MathUtils.safeMultiply(l, 3600), 0);
    }

    public static Duration standardDays(long l) {
        if (l == 0L) {
            return ZERO;
        }
        return new Duration(MathUtils.safeMultiply(l, 86400), 0);
    }

    public static Duration durationBetween(InstantProvider instantProvider, InstantProvider instantProvider2) {
        Instant instant = Instant.instant(instantProvider);
        Instant instant2 = Instant.instant(instantProvider2);
        long l = MathUtils.safeSubtract(instant2.getEpochSeconds(), instant.getEpochSeconds());
        int n = instant2.getNanoOfSecond() - instant.getNanoOfSecond();
        if (n < 0) {
            n += 1000000000;
            l = MathUtils.safeDecrement(l);
        }
        return Duration.create(l, n);
    }

    public static Duration parse(String string) {
        Instant.checkNotNull(string, "Text to parse must not be null");
        int n = string.length();
        if (n < 4 || string.charAt(0) != 'P' && string.charAt(0) != 'p' || string.charAt(1) != 'T' && string.charAt(1) != 't' || string.charAt(n - 1) != 'S' && string.charAt(n - 1) != 's' || n == 5 && string.charAt(2) == '-' && string.charAt(3) == '0') {
            throw new CalendricalParseException("Duration could not be parsed: " + string, string, 0);
        }
        String string2 = string.substring(2, n - 1).replace(',', '.');
        int n2 = string2.indexOf(46);
        try {
            if (n2 == -1) {
                return Duration.create(Long.parseLong(string2), 0);
            }
            boolean bl = false;
            if (string2.charAt(0) == '-') {
                bl = true;
            }
            long l = Long.parseLong(string2.substring(0, n2));
            n = (string2 = string2.substring(n2 + 1)).length();
            if (n == 0 || n > 9 || string2.charAt(0) == '-') {
                throw new CalendricalParseException("Duration could not be parsed: " + string, string, 2);
            }
            int n3 = Integer.parseInt(string2);
            switch (n) {
                case 1: {
                    n3 *= 100000000;
                    break;
                }
                case 2: {
                    n3 *= 10000000;
                    break;
                }
                case 3: {
                    n3 *= 1000000;
                    break;
                }
                case 4: {
                    n3 *= 100000;
                    break;
                }
                case 5: {
                    n3 *= 10000;
                    break;
                }
                case 6: {
                    n3 *= 1000;
                    break;
                }
                case 7: {
                    n3 *= 100;
                    break;
                }
                case 8: {
                    n3 *= 10;
                }
            }
            return bl ? Duration.seconds(l, -n3) : Duration.create(l, n3);
        }
        catch (ArithmeticException arithmeticException) {
            throw new CalendricalParseException("Duration could not be parsed: " + string, string, 2, arithmeticException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CalendricalParseException("Duration could not be parsed: " + string, string, 2, numberFormatException);
        }
    }

    private static Duration create(long l, int n) {
        if (l == 0L && n == 0) {
            return ZERO;
        }
        return new Duration(l, n);
    }

    private Duration(long l, int n) {
        this.seconds = l;
        this.nanoAdjustment = n;
    }

    private Object readResolve() {
        if (this.seconds == 0L && this.nanoAdjustment == 0) {
            return ZERO;
        }
        return this;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanosAdjustment() {
        return this.nanoAdjustment;
    }

    public Duration plus(Duration duration) {
        long l = duration.seconds;
        int n = duration.nanoAdjustment;
        if (l == 0L && n == 0) {
            return this;
        }
        long l2 = MathUtils.safeAdd(this.seconds, l);
        int n2 = this.nanoAdjustment + n;
        if (n2 >= 1000000000) {
            n2 -= 1000000000;
            l2 = MathUtils.safeIncrement(l2);
        }
        return Duration.create(l2, n2);
    }

    public Duration plusSeconds(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = MathUtils.safeAdd(this.seconds, l);
        return Duration.create(l2, this.nanoAdjustment);
    }

    public Duration plusMillis(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = l / 1000L;
        int n = (int)(l % 1000L) * 1000000;
        if ((n += this.nanoAdjustment) < 0) {
            n += 1000000000;
            --l2;
        } else if (n >= 1000000000) {
            n -= 1000000000;
            ++l2;
        }
        return Duration.create(MathUtils.safeAdd(this.seconds, l2), n);
    }

    public Duration plusNanos(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = l / 1000000000L;
        int n = (int)(l % 1000000000L);
        if ((n += this.nanoAdjustment) < 0) {
            n += 1000000000;
            --l2;
        } else if (n >= 1000000000) {
            n -= 1000000000;
            ++l2;
        }
        return Duration.create(MathUtils.safeAdd(this.seconds, l2), n);
    }

    public Duration minus(Duration duration) {
        long l = duration.seconds;
        int n = duration.nanoAdjustment;
        if (l == 0L && n == 0) {
            return this;
        }
        long l2 = MathUtils.safeSubtract(this.seconds, l);
        int n2 = this.nanoAdjustment - n;
        if (n2 < 0) {
            n2 += 1000000000;
            l2 = MathUtils.safeDecrement(l2);
        }
        return Duration.create(l2, n2);
    }

    public Duration minusSeconds(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = MathUtils.safeSubtract(this.seconds, l);
        return Duration.create(l2, this.nanoAdjustment);
    }

    public Duration minusMillis(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = l / 1000L;
        int n = (int)(l % 1000L) * 1000000;
        if ((n = this.nanoAdjustment - n) < 0) {
            n += 1000000000;
            ++l2;
        } else if (n >= 1000000000) {
            n -= 1000000000;
            --l2;
        }
        return Duration.create(MathUtils.safeSubtract(this.seconds, l2), n);
    }

    public Duration minusNanos(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = l / 1000000000L;
        int n = (int)(l % 1000000000L);
        if ((n = this.nanoAdjustment - n) < 0) {
            n += 1000000000;
            ++l2;
        } else if (n >= 1000000000) {
            n -= 1000000000;
            --l2;
        }
        return Duration.create(MathUtils.safeSubtract(this.seconds, l2), n);
    }

    public Duration multipliedBy(long l) {
        if (l == 0L) {
            return ZERO;
        }
        if (l == 1L) {
            return this;
        }
        BigInteger bigInteger = this.toNanosBigInteger();
        BigInteger[] bigIntegerArray = (bigInteger = bigInteger.multiply(BigInteger.valueOf(l))).divideAndRemainder(BILLION);
        if (bigIntegerArray[0].bitLength() > 63) {
            throw new ArithmeticException("Multiplication result exceeds capacity of Duration: " + this + " * " + l);
        }
        return Duration.seconds(bigIntegerArray[0].longValue(), bigIntegerArray[1].intValue());
    }

    public Duration dividedBy(long l) {
        if (l == 0L) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        if (l == 1L) {
            return this;
        }
        BigInteger bigInteger = this.toNanosBigInteger();
        bigInteger = bigInteger.divide(BigInteger.valueOf(l));
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BILLION);
        return Duration.seconds(bigIntegerArray[0].longValue(), bigIntegerArray[1].intValue());
    }

    @Override
    public int compareTo(Duration duration) {
        int n = MathUtils.safeCompare(this.seconds, duration.seconds);
        if (n != 0) {
            return n;
        }
        return MathUtils.safeCompare(this.nanoAdjustment, duration.nanoAdjustment);
    }

    public boolean isLongerThan(Duration duration) {
        return this.compareTo(duration) > 0;
    }

    public boolean isShorterThan(Duration duration) {
        return this.compareTo(duration) < 0;
    }

    public long toMillis() {
        long l = MathUtils.safeMultiply(this.seconds, 1000);
        l = MathUtils.safeAdd(l, (long)(this.nanoAdjustment / 1000000));
        return l;
    }

    public long toNanos() {
        long l = MathUtils.safeMultiply(this.seconds, 1000000000);
        l = MathUtils.safeAdd(l, (long)this.nanoAdjustment);
        return l;
    }

    public BigInteger toNanosBigInteger() {
        return BigInteger.valueOf(this.seconds).multiply(BILLION).add(BigInteger.valueOf(this.nanoAdjustment));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return this.seconds == duration.seconds && this.nanoAdjustment == duration.nanoAdjustment;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32) + 51 * this.nanoAdjustment;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(24);
        stringBuilder.append("PT");
        if (this.seconds < 0L && this.nanoAdjustment > 0) {
            if (this.seconds == -1L) {
                stringBuilder.append("-0");
            } else {
                stringBuilder.append(this.seconds + 1L);
            }
        } else {
            stringBuilder.append(this.seconds);
        }
        if (this.nanoAdjustment > 0) {
            int n = stringBuilder.length();
            if (this.seconds < 0L) {
                stringBuilder.append(2000000000 - this.nanoAdjustment);
            } else {
                stringBuilder.append(this.nanoAdjustment + 1000000000);
            }
            while (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            stringBuilder.setCharAt(n, '.');
        }
        stringBuilder.append('S');
        return stringBuilder.toString();
    }
}

