/*
 * Decompiled with CFR 0.152.
 */
package javax.time;

public final class MathUtils {
    private MathUtils() {
    }

    public static int safeNegate(int n) {
        if (n == Integer.MIN_VALUE) {
            throw new ArithmeticException("Integer.MIN_VALUE cannot be negated");
        }
        return -n;
    }

    public static int safeAdd(int n, int n2) {
        int n3 = n + n2;
        if ((n ^ n3) < 0 && (n ^ n2) >= 0) {
            throw new ArithmeticException("Addition overflows an int: " + n + " + " + n2);
        }
        return n3;
    }

    public static long safeAdd(long l, long l2) {
        long l3 = l + l2;
        if ((l ^ l3) < 0L && (l ^ l2) >= 0L) {
            throw new ArithmeticException("Addition overflows a long: " + l + " + " + l2);
        }
        return l3;
    }

    public static int safeSubtract(int n, int n2) {
        int n3 = n - n2;
        if ((n ^ n3) < 0 && (n ^ n2) < 0) {
            throw new ArithmeticException("Subtraction overflows an int: " + n + " - " + n2);
        }
        return n3;
    }

    public static long safeSubtract(long l, long l2) {
        long l3 = l - l2;
        if ((l ^ l3) < 0L && (l ^ l2) < 0L) {
            throw new ArithmeticException("Subtraction overflows a long: " + l + " - " + l2);
        }
        return l3;
    }

    public static int safeMultiply(int n, int n2) {
        long l = (long)n * (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("Multiplication overflows an int: " + n + " * " + n2);
        }
        return (int)l;
    }

    public static long safeMultiply(long l, int n) {
        switch (n) {
            case -1: {
                if (l == Long.MIN_VALUE) {
                    throw new ArithmeticException("Multiplication overflows a long: " + l + " * " + n);
                }
                return -l;
            }
            case 0: {
                return 0L;
            }
            case 1: {
                return l;
            }
        }
        long l2 = l * (long)n;
        if (l2 / (long)n != l) {
            throw new ArithmeticException("Multiplication overflows a long: " + l + " * " + n);
        }
        return l2;
    }

    public static long safeMultiply(long l, long l2) {
        if (l2 == 1L) {
            return l;
        }
        if (l == 1L) {
            return l2;
        }
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        long l3 = l * l2;
        if (l3 / l2 != l) {
            throw new ArithmeticException("Multiplication overflows a long: " + l + " * " + l2);
        }
        return l3;
    }

    public static int safeIncrement(int n) {
        if (n == Integer.MAX_VALUE) {
            throw new ArithmeticException("Integer.MAX_VALUE cannot be incremented");
        }
        return n + 1;
    }

    public static long safeIncrement(long l) {
        if (l == Long.MAX_VALUE) {
            throw new ArithmeticException("Long.MAX_VALUE cannot be incremented");
        }
        return l + 1L;
    }

    public static int safeDecrement(int n) {
        if (n == Integer.MIN_VALUE) {
            throw new ArithmeticException("Integer.MIN_VALUE cannot be decremented");
        }
        return n - 1;
    }

    public static long safeDecrement(long l) {
        if (l == Long.MIN_VALUE) {
            throw new ArithmeticException("Long.MIN_VALUE cannot be decremented");
        }
        return l - 1L;
    }

    public static int safeToInt(long l) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new ArithmeticException("Calculation overflows an int: " + l);
        }
        return (int)l;
    }

    public static int safeCompare(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public static int safeCompare(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return 0;
    }
}

