/*
 * Decompiled with CFR 0.152.
 */
package javax.time;

import java.io.Serializable;
import javax.time.Duration;
import javax.time.Instant;
import javax.time.InstantProvider;

public abstract class TimeSource {
    public static TimeSource system() {
        return SystemTimeSource.INSTANCE;
    }

    public static TimeSource fixed(InstantProvider instantProvider) {
        Instant.checkNotNull(instantProvider, "InstantProvider must not be null");
        Instant instant = Instant.instant(instantProvider);
        return new FixedTimeSource(instant);
    }

    public static TimeSource offsetSystem(Duration duration) {
        Instant.checkNotNull(duration, "Duration must not be null");
        if (duration.equals(Duration.ZERO)) {
            return SystemTimeSource.INSTANCE;
        }
        return new OffsetSystemTimeSource(duration);
    }

    protected TimeSource() {
    }

    public abstract Instant instant();

    private static final class OffsetSystemTimeSource
    extends TimeSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Duration offset;

        private OffsetSystemTimeSource(Duration duration) {
            this.offset = duration;
        }

        @Override
        public Instant instant() {
            return Instant.millisInstant(System.currentTimeMillis()).plus(this.offset);
        }

        public boolean equals(Object object) {
            if (object instanceof OffsetSystemTimeSource) {
                return this.offset.equals(((OffsetSystemTimeSource)object).offset);
            }
            return false;
        }

        public int hashCode() {
            return this.offset.hashCode();
        }

        public String toString() {
            return "OffsetSystemTimeSource[" + this.offset + ']';
        }
    }

    private static final class FixedTimeSource
    extends TimeSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Instant instant;

        private FixedTimeSource(Instant instant) {
            this.instant = instant;
        }

        @Override
        public Instant instant() {
            return this.instant;
        }

        public boolean equals(Object object) {
            if (object instanceof FixedTimeSource) {
                return this.instant.equals(((FixedTimeSource)object).instant);
            }
            return false;
        }

        public int hashCode() {
            return this.instant.hashCode();
        }

        public String toString() {
            return "FixedTimeSource[" + this.instant + ']';
        }
    }

    private static final class SystemTimeSource
    extends TimeSource
    implements Serializable {
        static final SystemTimeSource INSTANCE = new SystemTimeSource();
        private static final long serialVersionUID = 1L;

        private SystemTimeSource() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Instant instant() {
            return Instant.millisInstant(System.currentTimeMillis());
        }

        public String toString() {
            return "SystemTimeSource";
        }
    }
}

