/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.util.TimeZone;
import javax.time.Clock;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.YearMonth;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.Era;
import javax.time.calendar.field.HourOfDay;
import javax.time.calendar.field.MinuteOfHour;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.SecondOfMinute;
import javax.time.calendar.field.Year;

public final class Calendars {
    private Calendars() {
    }

    public static Clock clock() {
        return Clock.system();
    }

    public static Year year(int n) {
        return Year.isoYear(n);
    }

    public static Year year(Era era, int n) {
        return Year.year((Era)era, (int)n);
    }

    public static MonthOfYear monthOfYear(int n) {
        return MonthOfYear.monthOfYear(n);
    }

    public static MonthOfYear january() {
        return MonthOfYear.JANUARY;
    }

    public static MonthOfYear february() {
        return MonthOfYear.FEBRUARY;
    }

    public static MonthOfYear march() {
        return MonthOfYear.MARCH;
    }

    public static DayOfMonth dayOfMonth(int n) {
        return DayOfMonth.dayOfMonth(n);
    }

    public static HourOfDay hourOfDay(int n) {
        return HourOfDay.hourOfDay(n);
    }

    public static MinuteOfHour minuteOfHour(int n) {
        return MinuteOfHour.minuteOfHour(n);
    }

    public static SecondOfMinute secondOfMinute(int n) {
        return SecondOfMinute.secondOfMinute(n);
    }

    public static LocalDate date(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth) {
        return LocalDate.date(year, monthOfYear, dayOfMonth);
    }

    public static LocalDate date(int n, MonthOfYear monthOfYear, int n2) {
        return LocalDate.date(n, monthOfYear, n2);
    }

    public static LocalDate date(int n, int n2, int n3) {
        return LocalDate.date(n, n2, n3);
    }

    public static OffsetDate date(int n, MonthOfYear monthOfYear, int n2, ZoneOffset zoneOffset) {
        return OffsetDate.date(n, monthOfYear, n2, zoneOffset);
    }

    public static OffsetDate date(int n, int n2, int n3, ZoneOffset zoneOffset) {
        return OffsetDate.date(n, n2, n3, zoneOffset);
    }

    public static LocalTime time(int n, int n2) {
        return LocalTime.time(n, n2);
    }

    public static LocalTime time(int n, int n2, int n3) {
        return LocalTime.time(n, n2, n3);
    }

    public static LocalTime time(int n, int n2, int n3, int n4) {
        return LocalTime.time(n, n2, n3, n4);
    }

    public static OffsetTime time(int n, int n2, ZoneOffset zoneOffset) {
        return OffsetTime.time(n, n2, zoneOffset);
    }

    public static OffsetTime time(int n, int n2, int n3, ZoneOffset zoneOffset) {
        return OffsetTime.time(n, n2, n3, zoneOffset);
    }

    public static OffsetTime time(int n, int n2, int n3, int n4, ZoneOffset zoneOffset) {
        return OffsetTime.time(n, n2, n3, n4, zoneOffset);
    }

    public static CalendarBuilder calendar() {
        return new CalendarBuilder();
    }

    public static class CalendarWithYearMonthDayBuilder {
        public LocalDate build() {
            return LocalDate.date(2007, 6, 1);
        }

        public LocalDate buildLenient() {
            return LocalDate.date(2007, 6, 1);
        }
    }

    public static class CalendarWithYearMonthBuilder {
        public CalendarWithYearMonthDayBuilder dayOfMonth(int n) {
            return new CalendarWithYearMonthDayBuilder();
        }

        public YearMonth build() {
            return YearMonth.yearMonth(2007, 6);
        }

        public YearMonth buildLenient() {
            return YearMonth.yearMonth(2007, 6);
        }
    }

    public static class CalendarWithYearBuilder {
        public CalendarWithYearMonthBuilder monthOfYear(int n) {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder january() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder february() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder march() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder april() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder may() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder june() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder july() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder august() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder september() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder october() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder november() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthBuilder december() {
            return new CalendarWithYearMonthBuilder();
        }

        public CalendarWithYearMonthDayBuilder dayOfYear(int n) {
            return new CalendarWithYearMonthDayBuilder();
        }
    }

    public static class CalendarBuilder {
        public CalendarWithYearBuilder year(int n) {
            return new CalendarWithYearBuilder();
        }

        public CalendarWithYearBuilder currentYear() {
            return new CalendarWithYearBuilder();
        }

        public CalendarWithYearBuilder nextYear() {
            return new CalendarWithYearBuilder();
        }

        public CalendarWithYearBuilder previousYear() {
            return new CalendarWithYearBuilder();
        }

        public CalendarBuilder zone(TimeZone timeZone) {
            return new CalendarBuilder();
        }

        public CalendarBuilder zoneID(String string) {
            return new CalendarBuilder();
        }

        public CalendarBuilder defaultZone() {
            return new CalendarBuilder();
        }
    }
}

