/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.TimeSource;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.TimeZone;
import javax.time.calendar.YearMonth;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.field.Year;

public abstract class Clock {
    public static Clock systemDefaultZone() {
        TimeZone timeZone = TimeZone.timeZone(java.util.TimeZone.getDefault().getID());
        return new TimeSourceClock(TimeSource.system(), timeZone);
    }

    public static Clock system(TimeZone timeZone) {
        ISOChronology.checkNotNull(timeZone, "TimeZone must not be null");
        return new TimeSourceClock(TimeSource.system(), timeZone);
    }

    public static Clock clockDefaultZone(TimeSource timeSource) {
        ISOChronology.checkNotNull(timeSource, "TimeSource must not be null");
        TimeZone timeZone = TimeZone.timeZone(java.util.TimeZone.getDefault().getID());
        return new TimeSourceClock(timeSource, timeZone);
    }

    public static Clock clock(TimeSource timeSource, TimeZone timeZone) {
        ISOChronology.checkNotNull(timeSource, "TimeSource must not be null");
        ISOChronology.checkNotNull(timeZone, "TimeZone must not be null");
        return new TimeSourceClock(timeSource, timeZone);
    }

    protected Clock() {
    }

    public TimeSource getSource() {
        throw new UnsupportedOperationException("Clock.getSource is not supported");
    }

    public Clock withSource(TimeSource timeSource) {
        throw new UnsupportedOperationException("Clock.withSource is not supported");
    }

    public TimeZone getZone() {
        throw new UnsupportedOperationException("Clock.getZone is not supported");
    }

    public Clock withZone(TimeZone timeZone) {
        throw new UnsupportedOperationException("Clock.withZone is not supported");
    }

    public Instant instant() {
        return this.getSource().instant();
    }

    public LocalDate today() {
        return this.offsetDate().toLocalDate();
    }

    public LocalDate yesterday() {
        return this.today().minusDays(1L);
    }

    public LocalDate tomorrow() {
        return this.today().plusDays(1L);
    }

    public YearMonth yearMonth() {
        LocalDate localDate = this.today();
        return YearMonth.yearMonth(localDate.getYear(), localDate.getMonthOfYear());
    }

    public Year year() {
        return Year.isoYear(this.today().getYear());
    }

    public LocalTime time() {
        return this.offsetTime().toLocalTime();
    }

    public LocalTime timeToSecond() {
        return this.time().withNanoOfSecond(0);
    }

    public LocalTime timeToMinute() {
        return this.time().withSecondOfMinute(0).withNanoOfSecond(0);
    }

    public LocalDateTime dateTime() {
        return this.offsetDateTime().toLocalDateTime();
    }

    public LocalDateTime dateTimeToSecond() {
        return this.dateTime().withNanoOfSecond(0);
    }

    public LocalDateTime dateTimeToMinute() {
        return this.dateTime().withSecondOfMinute(0).withNanoOfSecond(0);
    }

    public OffsetDate offsetDate() {
        Instant instant = this.instant();
        return OffsetDate.fromInstant(instant, this.getZone().getRules().getOffset(instant));
    }

    public OffsetTime offsetTime() {
        Instant instant = this.instant();
        return OffsetTime.fromInstant(instant, this.getZone().getRules().getOffset(instant));
    }

    public OffsetTime offsetTimeToSecond() {
        return this.offsetTime().withNanoOfSecond(0);
    }

    public OffsetTime offsetTimeToMinute() {
        return this.offsetTime().withSecondOfMinute(0).withNanoOfSecond(0);
    }

    public OffsetDateTime offsetDateTime() {
        Instant instant = this.instant();
        return OffsetDateTime.fromInstant(instant, this.getZone().getRules().getOffset(instant));
    }

    public OffsetDateTime offsetDateTimeToSecond() {
        return this.offsetDateTime().withNanoOfSecond(0);
    }

    public OffsetDateTime offsetDateTimeToMinute() {
        return this.offsetDateTime().withSecondOfMinute(0).withNanoOfSecond(0);
    }

    public ZonedDateTime zonedDateTime() {
        return ZonedDateTime.fromInstant(this.instant(), this.getZone());
    }

    public ZonedDateTime zonedDateTimeToSecond() {
        return this.zonedDateTime().withNanoOfSecond(0);
    }

    public ZonedDateTime zonedDateTimeToMinute() {
        return this.zonedDateTime().withSecondOfMinute(0).withNanoOfSecond(0);
    }

    private static final class TimeSourceClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final TimeSource timeSource;
        private final TimeZone zone;

        private TimeSourceClock(TimeSource timeSource, TimeZone timeZone) {
            this.timeSource = timeSource;
            this.zone = timeZone;
        }

        @Override
        public TimeSource getSource() {
            return this.timeSource;
        }

        @Override
        public Clock withSource(TimeSource timeSource) {
            ISOChronology.checkNotNull(timeSource, "TimeSource must not be null");
            if (timeSource.equals(this.timeSource)) {
                return this;
            }
            return new TimeSourceClock(timeSource, this.zone);
        }

        @Override
        public TimeZone getZone() {
            return this.zone;
        }

        @Override
        public Clock withZone(TimeZone timeZone) {
            ISOChronology.checkNotNull(timeZone, "TimeZone must not be null");
            if (timeZone.equals(this.zone)) {
                return this;
            }
            return new TimeSourceClock(this.timeSource, timeZone);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof TimeSourceClock) {
                TimeSourceClock timeSourceClock = (TimeSourceClock)object;
                return this.timeSource.equals(timeSourceClock.timeSource) && this.zone.equals(timeSourceClock.zone);
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n = 41 * n + this.timeSource.hashCode();
            n = 41 * n + this.zone.hashCode();
            return n;
        }

        public String toString() {
            return "TimeSourceClock[" + this.timeSource + ", " + this.zone + ']';
        }
    }
}

