/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.util.Comparator;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeProvider;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.TimeProvider;

public final class DateTimes {
    private DateTimes() {
    }

    public static Comparator<InstantProvider> instantComparator() {
        return InstantProviderComparator.INSTANCE;
    }

    public static Comparator<DateTimeProvider> localDateTimeComparator() {
        return DateTimeProviderComparator.INSTANCE;
    }

    public static Comparator<DateProvider> localDateComparator() {
        return DateProviderComparator.INSTANCE;
    }

    public static Comparator<TimeProvider> localTimeComparator() {
        return TimeProviderComparator.INSTANCE;
    }

    private static final class TimeProviderComparator
    implements Comparator<TimeProvider>,
    Serializable {
        static final Comparator<TimeProvider> INSTANCE = new TimeProviderComparator();
        private static final long serialVersionUID = 1L;

        private TimeProviderComparator() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int compare(TimeProvider timeProvider, TimeProvider timeProvider2) {
            return LocalTime.time(timeProvider).compareTo(LocalTime.time(timeProvider2));
        }
    }

    private static final class DateProviderComparator
    implements Comparator<DateProvider>,
    Serializable {
        static final Comparator<DateProvider> INSTANCE = new DateProviderComparator();
        private static final long serialVersionUID = 1L;

        private DateProviderComparator() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int compare(DateProvider dateProvider, DateProvider dateProvider2) {
            return LocalDate.date(dateProvider).compareTo(LocalDate.date(dateProvider2));
        }
    }

    private static final class DateTimeProviderComparator
    implements Comparator<DateTimeProvider>,
    Serializable {
        static final Comparator<DateTimeProvider> INSTANCE = new DateTimeProviderComparator();
        private static final long serialVersionUID = 1L;

        private DateTimeProviderComparator() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int compare(DateTimeProvider dateTimeProvider, DateTimeProvider dateTimeProvider2) {
            return LocalDateTime.dateTime(dateTimeProvider).compareTo(LocalDateTime.dateTime(dateTimeProvider2));
        }
    }

    private static final class InstantProviderComparator
    implements Comparator<InstantProvider>,
    Serializable {
        static final Comparator<InstantProvider> INSTANCE = new InstantProviderComparator();
        private static final long serialVersionUID = 1L;

        private InstantProviderComparator() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int compare(InstantProvider instantProvider, InstantProvider instantProvider2) {
            return Instant.instant(instantProvider).compareTo(Instant.instant(instantProvider2));
        }
    }
}

