/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.CalendricalException;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.Chronology;
import javax.time.calendar.DateAdjusters;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalTime;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.DayOfYear;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.WeekBasedYear;
import javax.time.calendar.field.WeekOfWeekBasedYear;
import javax.time.calendar.field.Year;
import javax.time.period.PeriodUnits;

public final class ISOChronology
extends Chronology
implements Serializable {
    public static final ISOChronology INSTANCE = new ISOChronology();
    private static final long serialVersionUID = 1L;
    static final int SECONDS_PER_DAY = 86400;
    static final int DAYS_PER_CYCLE = 146097;
    static final long DAYS_0000_TO_1970 = 719528L;
    static final long DAYS_0000_TO_MJD_EPOCH = 678941L;

    public static boolean isLeapYear(int n) {
        return (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    static int addYears(int n, int n2) {
        int n3 = n + n2;
        if ((n ^ n3) < 0 && (n ^ n2) >= 0 || !ISOChronology.yearRule().isValidValue(n3)) {
            throw new CalendricalException("Addition exceeds the supported year range: " + n + " + " + n2);
        }
        return n3;
    }

    static int subtractYears(int n, int n2) {
        int n3 = n - n2;
        if ((n ^ n3) < 0 && (n ^ n2) < 0 || !ISOChronology.yearRule().isValidValue(n3)) {
            throw new CalendricalException("Subtraction exceeds the supported year range: " + n + " - " + n2);
        }
        return n3;
    }

    private ISOChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "ISO";
    }

    @Override
    public DateTimeFieldRule year() {
        return YearRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule monthOfYear() {
        return MonthOfYearRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule dayOfMonth() {
        return DayOfMonthRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule dayOfYear() {
        return DayOfYearRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule dayOfWeek() {
        return DayOfWeekRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule hourOfDay() {
        return HourOfDayRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule minuteOfHour() {
        return MinuteOfHourRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule secondOfMinute() {
        return SecondOfMinuteRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule nanoOfSecond() {
        return NanoOfSecondRule.INSTANCE;
    }

    public static DateTimeFieldRule yearRule() {
        return YearRule.INSTANCE;
    }

    public static DateTimeFieldRule monthOfYearRule() {
        return MonthOfYearRule.INSTANCE;
    }

    public static DateTimeFieldRule dayOfMonthRule() {
        return DayOfMonthRule.INSTANCE;
    }

    public static DateTimeFieldRule dayOfYearRule() {
        return DayOfYearRule.INSTANCE;
    }

    public static DateTimeFieldRule weekBasedYearRule() {
        return WeekBasedYearRule.INSTANCE;
    }

    public static DateTimeFieldRule weekOfWeekBasedYearRule() {
        return WeekOfWeekBasedYearRule.INSTANCE;
    }

    public static DateTimeFieldRule dayOfWeekRule() {
        return DayOfWeekRule.INSTANCE;
    }

    public static DateTimeFieldRule weekOfYearRule() {
        return WeekOfYearRule.INSTANCE;
    }

    public static DateTimeFieldRule quarterOfYearRule() {
        return QuarterOfYearRule.INSTANCE;
    }

    public static DateTimeFieldRule monthOfQuarterRule() {
        return MonthOfQuarterRule.INSTANCE;
    }

    public static DateTimeFieldRule weekOfMonthRule() {
        return WeekOfMonthRule.INSTANCE;
    }

    public static DateTimeFieldRule hourOfDayRule() {
        return HourOfDayRule.INSTANCE;
    }

    public static DateTimeFieldRule minuteOfHourRule() {
        return MinuteOfHourRule.INSTANCE;
    }

    public static DateTimeFieldRule secondOfMinuteRule() {
        return SecondOfMinuteRule.INSTANCE;
    }

    public static DateTimeFieldRule nanoOfSecondRule() {
        return NanoOfSecondRule.INSTANCE;
    }

    public static DateTimeFieldRule secondOfDayRule() {
        return SecondOfDayRule.INSTANCE;
    }

    public static DateTimeFieldRule milliOfDayRule() {
        return MilliOfDayRule.INSTANCE;
    }

    public static DateTimeFieldRule milliOfSecondRule() {
        return MilliOfSecondRule.INSTANCE;
    }

    public static DateTimeFieldRule amPmOfDayRule() {
        return AmPmOfDayRule.INSTANCE;
    }

    public static DateTimeFieldRule hourOfAmPmRule() {
        return HourOfAmPmRule.INSTANCE;
    }

    private static final class HourOfAmPmRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new HourOfAmPmRule();
        private static final long serialVersionUID = 1L;

        private HourOfAmPmRule() {
            super(INSTANCE, "HourOfAmPm", PeriodUnits.HOURS, PeriodUnits.TWELVE_HOURS, 0, 11);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localTime == null ? null : Integer.valueOf(localTime.toHourOfDay().getHourOfAmPm());
        }

        @Override
        protected Integer deriveValue(Calendrical.FieldMap fieldMap) {
            Integer n = ISOChronology.hourOfDayRule().getValueQuiet(fieldMap);
            if (n == null) {
                return null;
            }
            int n2 = n;
            n2 = n2 < 0 ? 0x40000008 + n2 + 0x40000008 : n2;
            return n2 % 12;
        }
    }

    private static final class AmPmOfDayRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new AmPmOfDayRule();
        private static final long serialVersionUID = 1L;

        private AmPmOfDayRule() {
            super(INSTANCE, "AmPmOfDay", PeriodUnits.TWELVE_HOURS, PeriodUnits.DAYS, 0, 1);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localTime == null ? null : Integer.valueOf(localTime.toHourOfDay().getAmPm().getValue());
        }

        @Override
        protected Integer deriveValue(Calendrical.FieldMap fieldMap) {
            Integer n = ISOChronology.hourOfDayRule().getValueQuiet(fieldMap);
            if (n == null) {
                return null;
            }
            int n2 = n;
            n2 = n2 < 0 ? 0x40000008 + n2 + 0x40000008 : n2;
            return n2 % 24 / 2;
        }

        @Override
        protected void mergeFields(Calendrical.Merger merger) {
            Integer n = merger.getValueQuiet(ISOChronology.hourOfAmPmRule());
            if (n != null) {
                int n2 = merger.getValue(this);
                int n3 = MathUtils.safeAdd(MathUtils.safeMultiply(n2, 12), n);
                merger.storeMergedField(ISOChronology.hourOfDayRule(), n3);
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(ISOChronology.hourOfAmPmRule());
            }
        }
    }

    private static final class MilliOfSecondRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new MilliOfSecondRule();
        private static final long serialVersionUID = 1L;

        private MilliOfSecondRule() {
            super(INSTANCE, "MilliOfSecond", PeriodUnits.MILLIS, PeriodUnits.SECONDS, 0, 999);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localTime == null ? null : Integer.valueOf(localTime.getNanoOfSecond() / 1000000);
        }

        @Override
        protected void mergeFields(Calendrical.Merger merger) {
            int n = merger.getValue(this);
            int n2 = MathUtils.safeMultiply(n, 1000000);
            merger.storeMergedField(ISOChronology.nanoOfSecondRule(), n2);
            merger.markFieldAsProcessed(this);
        }
    }

    private static final class MilliOfDayRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new MilliOfDayRule();
        private static final long serialVersionUID = 1L;

        private MilliOfDayRule() {
            super(INSTANCE, "MilliOfDay", PeriodUnits.MILLIS, PeriodUnits.DAYS, 0, 86399999);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localTime == null ? null : Integer.valueOf((int)(localTime.toNanoOfDay() / 1000000L));
        }

        @Override
        protected void mergeDateTime(Calendrical.Merger merger) {
            long l = merger.getValue(this);
            if (merger.isStrict()) {
                merger.storeMergedTime(LocalTime.fromNanoOfDay(l * 1000000L));
            } else {
                merger.storeMergedTime(LocalTime.MIDNIGHT.plusNanosWithOverflow(l * 1000000L));
            }
            merger.markFieldAsProcessed(this);
        }
    }

    private static final class SecondOfDayRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new SecondOfDayRule();
        private static final long serialVersionUID = 1L;

        private SecondOfDayRule() {
            super(INSTANCE, "SecondOfDay", PeriodUnits.SECONDS, PeriodUnits.DAYS, 0, 86399);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localTime == null ? null : Integer.valueOf(localTime.toSecondOfDay());
        }

        @Override
        protected void mergeDateTime(Calendrical.Merger merger) {
            int n = merger.getValue(this);
            Integer n2 = merger.getValueQuiet(ISOChronology.nanoOfSecondRule());
            int n3 = 0;
            if (n2 != null) {
                n3 = n2;
            }
            if (merger.isStrict()) {
                merger.storeMergedTime(LocalTime.fromSecondOfDay(n, n3));
            } else {
                merger.storeMergedTime(LocalTime.MIDNIGHT.plusWithOverflow(0, 0, n, n3));
            }
            merger.markFieldAsProcessed(this);
        }
    }

    private static final class NanoOfSecondRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new NanoOfSecondRule();
        private static final long serialVersionUID = 1L;

        private NanoOfSecondRule() {
            super(INSTANCE, "NanoOfSecond", PeriodUnits.NANOS, PeriodUnits.SECONDS, 0, 999999999);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localTime == null ? null : Integer.valueOf(localTime.getNanoOfSecond());
        }
    }

    private static final class SecondOfMinuteRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new SecondOfMinuteRule();
        private static final long serialVersionUID = 1L;

        private SecondOfMinuteRule() {
            super(INSTANCE, "SecondOfMinute", PeriodUnits.SECONDS, PeriodUnits.MINUTES, 0, 59);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localTime == null ? null : Integer.valueOf(localTime.getSecondOfMinute());
        }
    }

    private static final class MinuteOfHourRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new MinuteOfHourRule();
        private static final long serialVersionUID = 1L;

        private MinuteOfHourRule() {
            super(INSTANCE, "MinuteOfHour", PeriodUnits.MINUTES, PeriodUnits.HOURS, 0, 59);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localTime == null ? null : Integer.valueOf(localTime.getMinuteOfHour());
        }
    }

    private static final class HourOfDayRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new HourOfDayRule();
        private static final long serialVersionUID = 1L;

        private HourOfDayRule() {
            super(INSTANCE, "HourOfDay", PeriodUnits.HOURS, PeriodUnits.DAYS, 0, 23);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localTime == null ? null : Integer.valueOf(localTime.getHourOfDay());
        }

        @Override
        protected void mergeDateTime(Calendrical.Merger merger) {
            int n = merger.getValue(this);
            Integer n2 = merger.getValueQuiet(ISOChronology.minuteOfHourRule());
            Integer n3 = merger.getValueQuiet(ISOChronology.secondOfMinuteRule());
            Integer n4 = merger.getValueQuiet(ISOChronology.nanoOfSecondRule());
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (n2 != null && n3 != null && n4 != null) {
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(ISOChronology.minuteOfHourRule());
                merger.markFieldAsProcessed(ISOChronology.secondOfMinuteRule());
                merger.markFieldAsProcessed(ISOChronology.nanoOfSecondRule());
                n5 = n2;
                n6 = n3;
                n7 = n4;
            } else if (n2 != null && n3 != null && n4 == null) {
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(ISOChronology.minuteOfHourRule());
                merger.markFieldAsProcessed(ISOChronology.secondOfMinuteRule());
                n5 = n2;
                n6 = n3;
            } else if (n2 != null && n3 == null && n4 == null) {
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(ISOChronology.minuteOfHourRule());
                n5 = n2;
            } else if (n2 == null && n3 == null && n4 == null) {
                merger.markFieldAsProcessed(this);
            } else {
                return;
            }
            if (merger.isStrict()) {
                merger.storeMergedTime(LocalTime.time(n, n5, n6, n7));
            } else {
                merger.storeMergedTime(LocalTime.MIDNIGHT.plusWithOverflow(n, n5, n6, n7));
            }
        }
    }

    private static final class WeekOfMonthRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new WeekOfMonthRule();
        private static final long serialVersionUID = 1L;

        private WeekOfMonthRule() {
            super(INSTANCE, "WeekOfMonth", PeriodUnits.WEEKS, PeriodUnits.MONTHS, 1, 5);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 4;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            Integer n = calendrical.deriveValueQuiet(ISOChronology.yearRule());
            if (n != null) {
                return Year.isoYear(n).isLeap() ? 5 : 4;
            }
            return this.getMaximumValue();
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf((localDate.getDayOfMonth() - 1) % 7 + 1);
        }

        @Override
        protected void mergeDateTime(Calendrical.Merger merger) {
            Integer n = merger.getValueQuiet(ISOChronology.yearRule());
            Integer n2 = merger.getValueQuiet(ISOChronology.monthOfYearRule());
            Integer n3 = merger.getValueQuiet(ISOChronology.dayOfWeekRule());
            if (n != null && n2 != null && n3 != null) {
                int n4 = merger.getValue(this);
                LocalDate localDate = LocalDate.date((int)n, 1, 1).plusMonths(n2).plusDays(((long)n4 - 1L) * 7L);
                localDate = localDate.with(DateAdjusters.nextOrCurrent(DayOfWeek.dayOfWeek(n3)));
                merger.storeMergedDate(localDate);
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(ISOChronology.yearRule());
                merger.markFieldAsProcessed(ISOChronology.monthOfYearRule());
                merger.markFieldAsProcessed(ISOChronology.dayOfWeekRule());
            }
        }
    }

    private static final class MonthOfQuarterRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new MonthOfQuarterRule();
        private static final long serialVersionUID = 1L;

        private MonthOfQuarterRule() {
            super(INSTANCE, "MonthOfQuarter", PeriodUnits.MONTHS, PeriodUnits.QUARTERS, 1, 3);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(localDate.getMonthOfYear().getMonthOfQuarter());
        }

        @Override
        protected Integer deriveValue(Calendrical.FieldMap fieldMap) {
            Integer n = ISOChronology.monthOfYearRule().getValueQuiet(fieldMap);
            if (n == null) {
                return null;
            }
            int n2 = n;
            return n2 >= 1 ? (n2 - 1) % 3 + 1 : 3 + n2 % 3;
        }
    }

    private static final class QuarterOfYearRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new QuarterOfYearRule();
        private static final long serialVersionUID = 1L;

        private QuarterOfYearRule() {
            super(INSTANCE, "QuarterOfYear", PeriodUnits.QUARTERS, PeriodUnits.YEARS, 1, 4);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(localDate.getMonthOfYear().getQuarterOfYear().getValue());
        }

        @Override
        protected Integer deriveValue(Calendrical.FieldMap fieldMap) {
            Integer n = ISOChronology.monthOfYearRule().getValueQuiet(fieldMap);
            if (n == null) {
                return null;
            }
            int n2 = n;
            return n2 >= 1 ? (n2 - 1) / 3 + 1 : 0;
        }

        @Override
        protected void mergeFields(Calendrical.Merger merger) {
            Integer n = merger.getValueQuiet(ISOChronology.monthOfQuarterRule());
            if (n != null) {
                int n2 = merger.getValue(this);
                n2 = MathUtils.safeDecrement(n2);
                int n3 = MathUtils.safeDecrement(n);
                int n4 = MathUtils.safeAdd(MathUtils.safeMultiply(n2, 3), n3);
                n4 = MathUtils.safeIncrement(n4);
                merger.storeMergedField(ISOChronology.monthOfYearRule(), n4);
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(ISOChronology.monthOfQuarterRule());
            }
        }
    }

    private static final class WeekOfYearRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new WeekOfYearRule();
        private static final long serialVersionUID = 1L;

        private WeekOfYearRule() {
            super(INSTANCE, "WeekOfYear", PeriodUnits.WEEKS, PeriodUnits.YEARS, 1, 53);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf((localDate.getDayOfYear() - 1) % 7 + 1);
        }

        @Override
        protected Integer deriveValue(Calendrical.FieldMap fieldMap) {
            Integer n = ISOChronology.monthOfYearRule().getValueQuiet(fieldMap);
            if (n == null) {
                return null;
            }
            int n2 = n;
            return n2 >= 1 ? (n2 - 1) / 7 + 1 : 0;
        }

        @Override
        protected void mergeDateTime(Calendrical.Merger merger) {
            Integer n = merger.getValueQuiet(ISOChronology.yearRule());
            Integer n2 = merger.getValueQuiet(ISOChronology.dayOfWeekRule());
            if (n != null && n2 != null) {
                int n3 = merger.getValue(this);
                LocalDate localDate = LocalDate.date((int)n, 1, 1).plusDays(((long)n3 - 1L) * 7L);
                localDate = localDate.with(DateAdjusters.nextOrCurrent(DayOfWeek.dayOfWeek(n2)));
                merger.storeMergedDate(localDate);
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(ISOChronology.yearRule());
                merger.markFieldAsProcessed(ISOChronology.dayOfWeekRule());
            }
        }
    }

    private static final class DayOfWeekRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new DayOfWeekRule();
        private static final long serialVersionUID = 1L;

        private DayOfWeekRule() {
            super(INSTANCE, "DayOfWeek", PeriodUnits.DAYS, PeriodUnits.WEEKS, 1, 7);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(localDate.getDayOfWeek().getValue());
        }
    }

    private static final class WeekOfWeekBasedYearRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new WeekOfWeekBasedYearRule();
        private static final long serialVersionUID = 1L;

        private WeekOfWeekBasedYearRule() {
            super(INSTANCE, "WeekOfWeekBasedYear", PeriodUnits.WEEKS, PeriodUnits.WEEKYEARS, 1, 53);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 52;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(WeekOfWeekBasedYear.weekOfWeekyear(localDate).getValue());
        }
    }

    private static final class WeekBasedYearRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new WeekBasedYearRule();
        private static final long serialVersionUID = 1L;

        private WeekBasedYearRule() {
            super(INSTANCE, "WeekBasedYear", PeriodUnits.WEEKYEARS, null, -2147483646, Integer.MAX_VALUE);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(WeekBasedYear.weekyear(localDate).getValue());
        }

        @Override
        protected void mergeDateTime(Calendrical.Merger merger) {
            Integer n = merger.getValueQuiet(ISOChronology.weekOfWeekBasedYearRule());
            Integer n2 = merger.getValueQuiet(ISOChronology.dayOfWeekRule());
            if (n != null && n2 != null) {
                int n3 = merger.getValue(this);
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(ISOChronology.weekOfWeekBasedYearRule());
                merger.markFieldAsProcessed(ISOChronology.dayOfWeekRule());
            }
        }
    }

    private static final class DayOfYearRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new DayOfYearRule();
        private static final long serialVersionUID = 1L;

        private DayOfYearRule() {
            super(INSTANCE, "DayOfYear", PeriodUnits.DAYS, PeriodUnits.YEARS, 1, 366);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 365;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            Integer n = calendrical.deriveValueQuiet(ISOChronology.yearRule());
            if (n != null) {
                return Year.isoYear(n).lengthInDays();
            }
            return this.getMaximumValue();
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(localDate.getDayOfYear());
        }

        @Override
        protected void mergeDateTime(Calendrical.Merger merger) {
            Integer n = merger.getValueQuiet(ISOChronology.yearRule());
            if (n != null) {
                int n2 = merger.getValue(this);
                if (merger.isStrict() || n2 >= 1 && n2 <= 365) {
                    merger.storeMergedDate(DayOfYear.dayOfYear(n2).atYear(n));
                } else {
                    merger.storeMergedDate(LocalDate.date((int)n, 1, 1).plusDays((long)n2 - 1L));
                }
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(ISOChronology.yearRule());
            }
        }
    }

    private static final class DayOfMonthRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new DayOfMonthRule();
        private static final long serialVersionUID = 1L;

        private DayOfMonthRule() {
            super(INSTANCE, "DayOfMonth", PeriodUnits.DAYS, PeriodUnits.MONTHS, 1, 31);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 28;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            Integer n = calendrical.deriveValueQuiet(ISOChronology.yearRule());
            Integer n2 = calendrical.deriveValueQuiet(ISOChronology.monthOfYearRule());
            if (n != null && n2 != null) {
                MonthOfYear monthOfYear = MonthOfYear.monthOfYear(n2);
                return monthOfYear.lengthInDays(n);
            }
            return this.getMaximumValue();
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(localDate.getDayOfMonth());
        }
    }

    private static final class MonthOfYearRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new MonthOfYearRule();
        private static final long serialVersionUID = 1L;

        private MonthOfYearRule() {
            super(INSTANCE, "MonthOfYear", PeriodUnits.MONTHS, PeriodUnits.YEARS, 1, 12);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(localDate.getMonthOfYear().getValue());
        }
    }

    private static final class YearRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new YearRule();
        private static final long serialVersionUID = 1L;

        private YearRule() {
            super(INSTANCE, "Year", PeriodUnits.YEARS, null, -2147483646, Integer.MAX_VALUE);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(localDate.getYear());
        }

        @Override
        protected void mergeDateTime(Calendrical.Merger merger) {
            Integer n = merger.getValueQuiet(ISOChronology.monthOfYearRule());
            Integer n2 = merger.getValueQuiet(ISOChronology.dayOfMonthRule());
            if (n != null && n2 != null) {
                int n3 = merger.getValue(this);
                LocalDate localDate = merger.getContext().resolveDate(n3, n, n2);
                merger.storeMergedDate(localDate);
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(ISOChronology.monthOfYearRule());
                merger.markFieldAsProcessed(ISOChronology.dayOfMonthRule());
            }
        }
    }
}

