/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.DateTimeProvider;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthDay;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.TimeZone;
import javax.time.calendar.YearMonth;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZoneResolver;
import javax.time.calendar.ZoneResolvers;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.DayOfYear;
import javax.time.calendar.field.HourOfDay;
import javax.time.calendar.field.MinuteOfHour;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.NanoOfSecond;
import javax.time.calendar.field.SecondOfMinute;
import javax.time.calendar.field.Year;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.PeriodProvider;

public final class LocalDateTime
implements DateTimeProvider,
CalendricalProvider,
Comparable<LocalDateTime>,
DateMatcher,
TimeMatcher,
DateAdjuster,
TimeAdjuster,
Serializable {
    private static final long serialVersionUID = 1153828870L;
    private final LocalDate date;
    private final LocalTime time;

    public static LocalDateTime dateMidnight(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth) {
        LocalDate localDate = LocalDate.date(year, monthOfYear, dayOfMonth);
        return new LocalDateTime(localDate, LocalTime.MIDNIGHT);
    }

    public static LocalDateTime dateMidnight(int n, MonthOfYear monthOfYear, int n2) {
        LocalDate localDate = LocalDate.date(n, monthOfYear, n2);
        return new LocalDateTime(localDate, LocalTime.MIDNIGHT);
    }

    public static LocalDateTime dateMidnight(int n, int n2, int n3) {
        LocalDate localDate = LocalDate.date(n, n2, n3);
        return new LocalDateTime(localDate, LocalTime.MIDNIGHT);
    }

    public static LocalDateTime dateMidnight(DateProvider dateProvider) {
        LocalDate localDate = LocalDate.date(dateProvider);
        return new LocalDateTime(localDate, LocalTime.MIDNIGHT);
    }

    public static LocalDateTime dateTime(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth, HourOfDay hourOfDay, MinuteOfHour minuteOfHour) {
        LocalDate localDate = LocalDate.date(year, monthOfYear, dayOfMonth);
        LocalTime localTime = LocalTime.time(hourOfDay, minuteOfHour);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime dateTime(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth, HourOfDay hourOfDay, MinuteOfHour minuteOfHour, SecondOfMinute secondOfMinute) {
        LocalDate localDate = LocalDate.date(year, monthOfYear, dayOfMonth);
        LocalTime localTime = LocalTime.time(hourOfDay, minuteOfHour, secondOfMinute);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime dateTime(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth, HourOfDay hourOfDay, MinuteOfHour minuteOfHour, SecondOfMinute secondOfMinute, NanoOfSecond nanoOfSecond) {
        LocalDate localDate = LocalDate.date(year, monthOfYear, dayOfMonth);
        LocalTime localTime = LocalTime.time(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime dateTime(int n, MonthOfYear monthOfYear, int n2, int n3, int n4) {
        LocalDate localDate = LocalDate.date(n, monthOfYear, n2);
        LocalTime localTime = LocalTime.time(n3, n4);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime dateTime(int n, MonthOfYear monthOfYear, int n2, int n3, int n4, int n5) {
        LocalDate localDate = LocalDate.date(n, monthOfYear, n2);
        LocalTime localTime = LocalTime.time(n3, n4, n5);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime dateTime(int n, MonthOfYear monthOfYear, int n2, int n3, int n4, int n5, int n6) {
        LocalDate localDate = LocalDate.date(n, monthOfYear, n2);
        LocalTime localTime = LocalTime.time(n3, n4, n5, n6);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime dateTime(int n, int n2, int n3, int n4, int n5) {
        LocalDate localDate = LocalDate.date(n, n2, n3);
        LocalTime localTime = LocalTime.time(n4, n5);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime dateTime(int n, int n2, int n3, int n4, int n5, int n6) {
        LocalDate localDate = LocalDate.date(n, n2, n3);
        LocalTime localTime = LocalTime.time(n4, n5, n6);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime dateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        LocalDate localDate = LocalDate.date(n, n2, n3);
        LocalTime localTime = LocalTime.time(n4, n5, n6, n7);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime dateTime(DateProvider dateProvider, TimeProvider timeProvider) {
        LocalDate localDate = LocalDate.date(dateProvider);
        LocalTime localTime = LocalTime.time(timeProvider);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime dateTime(DateTimeProvider dateTimeProvider) {
        ISOChronology.checkNotNull(dateTimeProvider, "DateTimeProvider must not be null");
        LocalDateTime localDateTime = dateTimeProvider.toLocalDateTime();
        ISOChronology.checkNotNull(localDateTime, "DateTimeProvider implementation must not return null");
        return localDateTime;
    }

    public static LocalDateTime parse(String string) {
        return DateTimeFormatters.isoLocalDateTime().parse(string).mergeStrict().toLocalDateTime();
    }

    private LocalDateTime(LocalDate localDate, LocalTime localTime) {
        this.date = localDate;
        this.time = localTime;
    }

    private LocalDateTime withDateTime(LocalDate localDate, LocalTime localTime) {
        if (this.date == localDate && this.time == localTime) {
            return this;
        }
        return new LocalDateTime(localDate, localTime);
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    public boolean isSupported(DateTimeFieldRule dateTimeFieldRule) {
        return dateTimeFieldRule != null && dateTimeFieldRule.isSupported(this.date, this.time);
    }

    public int get(DateTimeFieldRule dateTimeFieldRule) {
        ISOChronology.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        return dateTimeFieldRule.getValue(this.date, this.time);
    }

    public YearMonth getYearMonth() {
        return this.date.getYearMonth();
    }

    public MonthDay getMonthDay() {
        return this.date.getMonthDay();
    }

    public LocalDate getDate() {
        return this.date;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public Year toYear() {
        return this.date.toYear();
    }

    public MonthOfYear toMonthOfYear() {
        return this.date.toMonthOfYear();
    }

    public DayOfMonth toDayOfMonth() {
        return this.date.toDayOfMonth();
    }

    public DayOfYear toDayOfYear() {
        return this.date.toDayOfYear();
    }

    public DayOfWeek toDayOfWeek() {
        return this.date.toDayOfWeek();
    }

    public HourOfDay toHourOfDay() {
        return this.time.toHourOfDay();
    }

    public MinuteOfHour toMinuteOfHour() {
        return this.time.toMinuteOfHour();
    }

    public SecondOfMinute toSecondOfMinute() {
        return this.time.toSecondOfMinute();
    }

    public NanoOfSecond toNanoOfSecond() {
        return this.time.toNanoOfSecond();
    }

    public int getYear() {
        return this.date.getYear();
    }

    public MonthOfYear getMonthOfYear() {
        return this.date.getMonthOfYear();
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.date.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    public int getHourOfDay() {
        return this.time.getHourOfDay();
    }

    public int getMinuteOfHour() {
        return this.time.getMinuteOfHour();
    }

    public int getSecondOfMinute() {
        return this.time.getSecondOfMinute();
    }

    public int getNanoOfSecond() {
        return this.time.getNanoOfSecond();
    }

    public LocalDateTime with(DateAdjuster dateAdjuster) {
        return this.withDateTime(this.date.with(dateAdjuster), this.time);
    }

    public LocalDateTime with(TimeAdjuster timeAdjuster) {
        return this.withDateTime(this.date, this.time.with(timeAdjuster));
    }

    public LocalDateTime withYear(int n) {
        LocalDate localDate = this.date.withYear(n);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime withYear(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.withYear(n, dateResolver);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime withMonthOfYear(int n) {
        LocalDate localDate = this.date.withMonthOfYear(n);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime withMonthOfYear(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.withMonthOfYear(n, dateResolver);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime withDayOfMonth(int n) {
        LocalDate localDate = this.date.withDayOfMonth(n);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime withDate(int n, MonthOfYear monthOfYear, int n2) {
        if (n == this.getYear() && monthOfYear == this.getMonthOfYear() && n2 == this.getDayOfMonth()) {
            return this;
        }
        LocalDate localDate = LocalDate.date(n, monthOfYear, n2);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime withDate(int n, int n2, int n3) {
        if (n == this.getYear() && n2 == this.getMonthOfYear().getValue() && n3 == this.getDayOfMonth()) {
            return this;
        }
        LocalDate localDate = LocalDate.date(n, n2, n3);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime withHourOfDay(int n) {
        LocalTime localTime = this.time.withHourOfDay(n);
        return this.withDateTime(this.date, localTime);
    }

    public LocalDateTime withMinuteOfHour(int n) {
        LocalTime localTime = this.time.withMinuteOfHour(n);
        return this.withDateTime(this.date, localTime);
    }

    public LocalDateTime withSecondOfMinute(int n) {
        LocalTime localTime = this.time.withSecondOfMinute(n);
        return this.withDateTime(this.date, localTime);
    }

    public LocalDateTime withNanoOfSecond(int n) {
        LocalTime localTime = this.time.withNanoOfSecond(n);
        return this.withDateTime(this.date, localTime);
    }

    public LocalDateTime withTime(int n, int n2) {
        return this.withTime(n, n2, 0, 0);
    }

    public LocalDateTime withTime(int n, int n2, int n3) {
        return this.withTime(n, n2, n3, 0);
    }

    public LocalDateTime withTime(int n, int n2, int n3, int n4) {
        if (n == this.getHourOfDay() && n2 == this.getMinuteOfHour() && n3 == this.getSecondOfMinute() && n4 == this.getNanoOfSecond()) {
            return this;
        }
        LocalTime localTime = LocalTime.time(n, n2, n3, n4);
        return this.withDateTime(this.date, localTime);
    }

    public LocalDateTime plus(PeriodProvider periodProvider) {
        LocalDate localDate = this.date.plus(periodProvider);
        LocalTime.Overflow overflow = this.time.plusWithOverflow(periodProvider);
        return this.withDateTime(localDate.plusDays(overflow.getOverflowDays()), overflow.getResultTime());
    }

    public LocalDateTime plusYears(int n) {
        LocalDate localDate = this.date.plusYears(n);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime plusYears(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.plusYears(n, dateResolver);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime plusMonths(int n) {
        LocalDate localDate = this.date.plusMonths(n);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime plusMonths(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.plusMonths(n, dateResolver);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime plusWeeks(int n) {
        LocalDate localDate = this.date.plusWeeks(n);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime plusDays(long l) {
        LocalDate localDate = this.date.plusDays(l);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime plusHours(int n) {
        LocalTime.Overflow overflow = this.time.plusWithOverflow(n, 0, 0, 0);
        LocalDate localDate = this.date.plusDays(overflow.getOverflowDays());
        return this.withDateTime(localDate, overflow.getResultTime());
    }

    public LocalDateTime plusMinutes(int n) {
        LocalTime.Overflow overflow = this.time.plusWithOverflow(0, n, 0, 0);
        LocalDate localDate = this.date.plusDays(overflow.getOverflowDays());
        return this.withDateTime(localDate, overflow.getResultTime());
    }

    public LocalDateTime plusSeconds(int n) {
        LocalTime.Overflow overflow = this.time.plusWithOverflow(0, 0, n, 0);
        LocalDate localDate = this.date.plusDays(overflow.getOverflowDays());
        return this.withDateTime(localDate, overflow.getResultTime());
    }

    public LocalDateTime plusNanos(long l) {
        LocalTime.Overflow overflow = this.time.plusNanosWithOverflow(l);
        LocalDate localDate = this.date.plusDays(overflow.getOverflowDays());
        return this.withDateTime(localDate, overflow.getResultTime());
    }

    public LocalDateTime minus(PeriodProvider periodProvider) {
        LocalDate localDate = this.date.minus(periodProvider);
        LocalTime.Overflow overflow = this.time.minusWithOverflow(periodProvider);
        return this.withDateTime(localDate.plusDays(overflow.getOverflowDays()), overflow.getResultTime());
    }

    public LocalDateTime minusYears(int n) {
        LocalDate localDate = this.date.minusYears(n);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime minusYears(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.minusYears(n, dateResolver);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime minusMonths(int n) {
        LocalDate localDate = this.date.minusMonths(n);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime minusMonths(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.minusMonths(n, dateResolver);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime minusWeeks(int n) {
        LocalDate localDate = this.date.minusWeeks(n);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime minusDays(long l) {
        LocalDate localDate = this.date.minusDays(l);
        return this.withDateTime(localDate, this.time);
    }

    public LocalDateTime minusHours(int n) {
        LocalTime.Overflow overflow = this.time.minusWithOverflow(n, 0, 0, 0);
        LocalDate localDate = this.date.plusDays(overflow.getOverflowDays());
        return this.withDateTime(localDate, overflow.getResultTime());
    }

    public LocalDateTime minusMinutes(int n) {
        LocalTime.Overflow overflow = this.time.minusWithOverflow(0, n, 0, 0);
        LocalDate localDate = this.date.plusDays(overflow.getOverflowDays());
        return this.withDateTime(localDate, overflow.getResultTime());
    }

    public LocalDateTime minusSeconds(int n) {
        LocalTime.Overflow overflow = this.time.minusWithOverflow(0, 0, n, 0);
        LocalDate localDate = this.date.plusDays(overflow.getOverflowDays());
        return this.withDateTime(localDate, overflow.getResultTime());
    }

    public LocalDateTime minusNanos(long l) {
        LocalTime.Overflow overflow = this.time.minusNanosWithOverflow(l);
        LocalDate localDate = this.date.plusDays(overflow.getOverflowDays());
        return this.withDateTime(localDate, overflow.getResultTime());
    }

    public boolean matches(DateMatcher dateMatcher) {
        return this.date.matches(dateMatcher);
    }

    public boolean matches(TimeMatcher timeMatcher) {
        return this.time.matches(timeMatcher);
    }

    @Override
    public LocalDate adjustDate(LocalDate localDate) {
        return this.matchesDate(localDate) ? localDate : this.date;
    }

    @Override
    public LocalTime adjustTime(LocalTime localTime) {
        return this.matchesTime(localTime) ? localTime : this.time;
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return this.date.matchesDate(localDate);
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        return this.time.matchesTime(localTime);
    }

    public OffsetDateTime atOffset(ZoneOffset zoneOffset) {
        return OffsetDateTime.dateTime(this, zoneOffset);
    }

    public ZonedDateTime atZone(TimeZone timeZone) {
        return ZonedDateTime.dateTime(this, timeZone, ZoneResolvers.postTransition());
    }

    public ZonedDateTime atZone(TimeZone timeZone, ZoneResolver zoneResolver) {
        return ZonedDateTime.dateTime(this, timeZone, zoneResolver);
    }

    @Override
    public LocalDate toLocalDate() {
        return this.date;
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time;
    }

    @Override
    public LocalDateTime toLocalDateTime() {
        return this;
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(this.date, this.time, null, null);
    }

    @Override
    public int compareTo(LocalDateTime localDateTime) {
        int n = this.date.compareTo(localDateTime.date);
        if (n == 0) {
            n = this.time.compareTo(localDateTime.time);
        }
        return n;
    }

    public boolean isAfter(LocalDateTime localDateTime) {
        return this.compareTo(localDateTime) > 0;
    }

    public boolean isBefore(LocalDateTime localDateTime) {
        return this.compareTo(localDateTime) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return this.date.equals(localDateTime.date) && this.time.equals(localDateTime.time);
        }
        return false;
    }

    public int hashCode() {
        return this.date.hashCode() ^ this.time.hashCode();
    }

    public String toString() {
        return this.date + "T" + this.time;
    }
}

