/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateResolvers;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.Year;
import javax.time.calendar.format.DateTimeFormatter;
import javax.time.calendar.format.DateTimeFormatterBuilder;

public final class MonthDay
implements CalendricalProvider,
Comparable<MonthDay>,
Serializable,
DateAdjuster,
DateMatcher {
    private static final long serialVersionUID = -254395108L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ISOChronology.monthOfYearRule(), 2).appendLiteral('-').appendValue(ISOChronology.dayOfMonthRule(), 2).toFormatter();
    private final MonthOfYear month;
    private final int day;

    public static MonthDay monthDay(MonthOfYear monthOfYear, DayOfMonth dayOfMonth) {
        ISOChronology.checkNotNull(monthOfYear, "MonthOfYear must not be null");
        ISOChronology.checkNotNull(dayOfMonth, "DayOfMonth must not be null");
        return MonthDay.monthDay(monthOfYear, dayOfMonth.getValue());
    }

    public static MonthDay monthDay(MonthOfYear monthOfYear, int n) {
        ISOChronology.checkNotNull(monthOfYear, "MonthOfYear must not be null");
        ISOChronology.dayOfMonthRule().checkValue(n);
        if (n > monthOfYear.maxLengthInDays()) {
            throw new InvalidCalendarFieldException("Illegal value for DayOfMonth field, value " + n + " is not valid for month " + monthOfYear.name(), ISOChronology.dayOfMonthRule());
        }
        return new MonthDay(monthOfYear, n);
    }

    public static MonthDay monthDay(int n, int n2) {
        return MonthDay.monthDay(MonthOfYear.monthOfYear(n), n2);
    }

    public static MonthDay monthDay(DateProvider dateProvider) {
        LocalDate localDate = LocalDate.date(dateProvider);
        return new MonthDay(localDate.getMonthOfYear(), localDate.getDayOfMonth());
    }

    public static MonthDay monthDay(CalendricalProvider calendricalProvider) {
        Calendrical calendrical = calendricalProvider.toCalendrical();
        int n = calendrical.deriveValue(ISOChronology.monthOfYearRule());
        int n2 = calendrical.deriveValue(ISOChronology.dayOfMonthRule());
        return MonthDay.monthDay(n, n2);
    }

    public static MonthDay parse(String string) {
        ISOChronology.checkNotNull(string, "Text to parse must not be null");
        return MonthDay.monthDay(PARSER.parse(string));
    }

    private MonthDay(MonthOfYear monthOfYear, int n) {
        this.month = monthOfYear;
        this.day = n;
    }

    private MonthDay withMonthDay(MonthOfYear monthOfYear, int n) {
        if (this.month == monthOfYear && this.day == n) {
            return this;
        }
        return new MonthDay(monthOfYear, n);
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    public MonthOfYear toMonthOfYear() {
        return this.month;
    }

    public DayOfMonth toDayOfMonth() {
        return DayOfMonth.dayOfMonth(this.day);
    }

    public MonthOfYear getMonthOfYear() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public MonthDay with(MonthOfYear monthOfYear) {
        ISOChronology.checkNotNull(monthOfYear, "MonthOfYear must not be null");
        int n = monthOfYear.maxLengthInDays();
        if (this.day > n) {
            return this.withMonthDay(monthOfYear, n);
        }
        return this.withMonthDay(monthOfYear, this.day);
    }

    public MonthDay with(DayOfMonth dayOfMonth) {
        ISOChronology.checkNotNull(dayOfMonth, "DayOfMonth must not be null");
        return this.withDayOfMonth(dayOfMonth.getValue());
    }

    public MonthDay withMonthOfYear(int n) {
        return this.with(MonthOfYear.monthOfYear(n));
    }

    public MonthDay withDayOfMonth(int n) {
        ISOChronology.dayOfMonthRule().checkValue(n);
        int n2 = this.month.maxLengthInDays();
        if (n > n2) {
            throw new InvalidCalendarFieldException("Day of month cannot be changed to " + n + " for the month " + this.month, ISOChronology.dayOfMonthRule());
        }
        return this.withMonthDay(this.month, n);
    }

    public MonthDay rollMonthOfYear(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = n % 12 + (this.month.getValue() - 1);
        n2 = (n2 + 12) % 12;
        return this.withMonthOfYear(++n2);
    }

    public MonthDay rollDayOfMonth(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = this.month.maxLengthInDays();
        int n3 = n % n2 + (this.day - 1);
        n3 = (n3 + n2) % n2;
        return this.withDayOfMonth(++n3);
    }

    @Override
    public LocalDate adjustDate(LocalDate localDate) {
        return this.adjustDate(localDate, DateResolvers.strict());
    }

    public LocalDate adjustDate(LocalDate localDate, DateResolver dateResolver) {
        ISOChronology.checkNotNull(localDate, "LocalDate must not be null");
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (this.month == localDate.getMonthOfYear() && this.day == localDate.getDayOfMonth()) {
            return localDate;
        }
        LocalDate localDate2 = dateResolver.resolveDate(localDate.toYear(), this.month, this.toDayOfMonth());
        ISOChronology.checkNotNull(localDate2, "The implementation of DateResolver must not return null");
        return localDate2;
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return this.month == localDate.getMonthOfYear() && this.day == localDate.getDayOfMonth();
    }

    public LocalDate atYear(Year year) {
        return this.atYear(year.getValue());
    }

    public LocalDate atYear(int n) {
        return LocalDate.date(n, this.month, this.day);
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(ISOChronology.monthOfYearRule(), this.month.getValue(), ISOChronology.dayOfMonthRule(), this.day);
    }

    @Override
    public int compareTo(MonthDay monthDay) {
        int n = this.month.compareTo(monthDay.month);
        if (n == 0) {
            n = MathUtils.safeCompare(this.day, monthDay.day);
        }
        return n;
    }

    public boolean isAfter(MonthDay monthDay) {
        return this.compareTo(monthDay) > 0;
    }

    public boolean isBefore(MonthDay monthDay) {
        return this.compareTo(monthDay) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MonthDay) {
            MonthDay monthDay = (MonthDay)object;
            return this.month == monthDay.month && this.day == monthDay.day;
        }
        return false;
    }

    public int hashCode() {
        return (this.month.getValue() << 6) + this.day;
    }

    public String toString() {
        int n = this.month.getValue();
        int n2 = this.day;
        return new StringBuilder(10).append("--").append(n < 10 ? "0" : "").append(n).append(n2 < 10 ? "-0" : "-").append(n2).toString();
    }
}

