/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.DateTimeProvider;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.TimeZone;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZoneResolver;
import javax.time.calendar.ZoneResolvers;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.DayOfYear;
import javax.time.calendar.field.HourOfDay;
import javax.time.calendar.field.MinuteOfHour;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.NanoOfSecond;
import javax.time.calendar.field.SecondOfMinute;
import javax.time.calendar.field.Year;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.PeriodProvider;

public final class OffsetDateTime
implements CalendricalProvider,
InstantProvider,
DateTimeProvider,
DateMatcher,
TimeMatcher,
DateAdjuster,
TimeAdjuster,
Comparable<OffsetDateTime>,
Serializable {
    private static final long serialVersionUID = -456761901L;
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;

    public static OffsetDateTime dateMidnight(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateMidnight(year, monthOfYear, dayOfMonth);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateMidnight(int n, MonthOfYear monthOfYear, int n2, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateMidnight(n, monthOfYear, n2);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateMidnight(int n, int n2, int n3, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateMidnight(n, n2, n3);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateMidnight(DateProvider dateProvider, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateMidnight(dateProvider);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateTime(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth, HourOfDay hourOfDay, MinuteOfHour minuteOfHour, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateTime(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth, HourOfDay hourOfDay, MinuteOfHour minuteOfHour, SecondOfMinute secondOfMinute, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateTime(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth, HourOfDay hourOfDay, MinuteOfHour minuteOfHour, SecondOfMinute secondOfMinute, NanoOfSecond nanoOfSecond, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateTime(int n, MonthOfYear monthOfYear, int n2, int n3, int n4, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(n, monthOfYear, n2, n3, n4);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateTime(int n, MonthOfYear monthOfYear, int n2, int n3, int n4, int n5, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(n, monthOfYear, n2, n3, n4, n5);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateTime(int n, MonthOfYear monthOfYear, int n2, int n3, int n4, int n5, int n6, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(n, monthOfYear, n2, n3, n4, n5, n6);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateTime(int n, int n2, int n3, int n4, int n5, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(n, n2, n3, n4, n5);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateTime(int n, int n2, int n3, int n4, int n5, int n6, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(n, n2, n3, n4, n5, n6);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(n, n2, n3, n4, n5, n6, n7);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateTime(DateProvider dateProvider, TimeProvider timeProvider, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(dateProvider, timeProvider);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime dateTime(DateTimeProvider dateTimeProvider, ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(dateTimeProvider);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime fromInstant(InstantProvider instantProvider, ZoneOffset zoneOffset) {
        Instant instant = Instant.instant(instantProvider);
        ISOChronology.checkNotNull(zoneOffset, "ZoneOffset must not be null");
        long l = instant.getEpochSeconds() + (long)zoneOffset.getAmountSeconds();
        long l2 = l / 86400L + 719528L;
        int n = (int)(l % 86400L);
        if (n < 0) {
            n += 86400;
            --l2;
        }
        LocalDate localDate = LocalDate.fromYearZeroDays(l2);
        LocalTime localTime = LocalTime.fromSecondOfDay(n, instant.getNanoOfSecond());
        LocalDateTime localDateTime = LocalDateTime.dateTime(localDate, localTime);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public static OffsetDateTime parse(String string) {
        return DateTimeFormatters.isoOffsetDateTime().parse(string).mergeStrict().toOffsetDateTime();
    }

    private OffsetDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        if (localDateTime == null) {
            throw new NullPointerException("The date-time must not be null");
        }
        if (zoneOffset == null) {
            throw new NullPointerException("The zone offset must not be null");
        }
        this.dateTime = localDateTime;
        this.offset = zoneOffset;
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    public boolean isSupported(DateTimeFieldRule dateTimeFieldRule) {
        return this.dateTime.isSupported(dateTimeFieldRule);
    }

    public int get(DateTimeFieldRule dateTimeFieldRule) {
        return this.dateTime.get(dateTimeFieldRule);
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public OffsetDateTime withDateTime(DateTimeProvider dateTimeProvider) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(dateTimeProvider);
        return localDateTime.equals(this.dateTime) ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetDateTime withOffsetSameLocal(ZoneOffset zoneOffset) {
        return zoneOffset == this.offset ? this : OffsetDateTime.dateTime(this.dateTime, zoneOffset);
    }

    public OffsetDateTime withOffsetSameInstant(ZoneOffset zoneOffset) {
        if (zoneOffset.equals(this.offset)) {
            return this;
        }
        int n = zoneOffset.getAmountSeconds() - this.offset.getAmountSeconds();
        LocalDateTime localDateTime = this.dateTime.plusSeconds(n);
        return new OffsetDateTime(localDateTime, zoneOffset);
    }

    public Year toYear() {
        return this.dateTime.toYear();
    }

    public MonthOfYear toMonthOfYear() {
        return this.dateTime.toMonthOfYear();
    }

    public DayOfMonth toDayOfMonth() {
        return this.dateTime.toDayOfMonth();
    }

    public DayOfYear toDayOfYear() {
        return this.dateTime.toDayOfYear();
    }

    public DayOfWeek toDayOfWeek() {
        return this.dateTime.toDayOfWeek();
    }

    public HourOfDay toHourOfDay() {
        return this.dateTime.toHourOfDay();
    }

    public MinuteOfHour toMinuteOfHour() {
        return this.dateTime.toMinuteOfHour();
    }

    public SecondOfMinute toSecondOfMinute() {
        return this.dateTime.toSecondOfMinute();
    }

    public NanoOfSecond toNanoOfSecond() {
        return this.dateTime.toNanoOfSecond();
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public MonthOfYear getMonthOfYear() {
        return this.dateTime.getMonthOfYear();
    }

    public int getDayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime.getDayOfWeek();
    }

    public int getHourOfDay() {
        return this.dateTime.getHourOfDay();
    }

    public int getMinuteOfHour() {
        return this.dateTime.getMinuteOfHour();
    }

    public int getSecondOfMinute() {
        return this.dateTime.getSecondOfMinute();
    }

    public int getNanoOfSecond() {
        return this.dateTime.getNanoOfSecond();
    }

    public OffsetDateTime with(DateAdjuster dateAdjuster) {
        LocalDateTime localDateTime = this.dateTime.with(dateAdjuster);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime with(TimeAdjuster timeAdjuster) {
        LocalDateTime localDateTime = this.dateTime.with(timeAdjuster);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withYear(int n) {
        LocalDateTime localDateTime = this.dateTime.withYear(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withYear(int n, DateResolver dateResolver) {
        LocalDateTime localDateTime = this.dateTime.withYear(n, dateResolver);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withMonthOfYear(int n) {
        LocalDateTime localDateTime = this.dateTime.withMonthOfYear(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withMonthOfYear(int n, DateResolver dateResolver) {
        LocalDateTime localDateTime = this.dateTime.withMonthOfYear(n, dateResolver);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withDayOfMonth(int n) {
        LocalDateTime localDateTime = this.dateTime.withDayOfMonth(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withDate(int n, int n2, int n3) {
        LocalDateTime localDateTime = this.dateTime.withDate(n, n2, n3);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withHourOfDay(int n) {
        LocalDateTime localDateTime = this.dateTime.withHourOfDay(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withMinuteOfHour(int n) {
        LocalDateTime localDateTime = this.dateTime.withMinuteOfHour(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withSecondOfMinute(int n) {
        LocalDateTime localDateTime = this.dateTime.withSecondOfMinute(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withNanoOfSecond(int n) {
        LocalDateTime localDateTime = this.dateTime.withNanoOfSecond(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withTime(int n, int n2) {
        LocalDateTime localDateTime = this.dateTime.withTime(n, n2);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withTime(int n, int n2, int n3) {
        LocalDateTime localDateTime = this.dateTime.withTime(n, n2, n3);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime withTime(int n, int n2, int n3, int n4) {
        LocalDateTime localDateTime = this.dateTime.withTime(n, n2, n3, n4);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime plus(PeriodProvider periodProvider) {
        LocalDateTime localDateTime = this.dateTime.plus(periodProvider);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime plusYears(int n) {
        LocalDateTime localDateTime = this.dateTime.plusYears(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime plusYears(int n, DateResolver dateResolver) {
        LocalDateTime localDateTime = this.dateTime.plusYears(n, dateResolver);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime plusMonths(int n) {
        LocalDateTime localDateTime = this.dateTime.plusMonths(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime plusMonths(int n, DateResolver dateResolver) {
        LocalDateTime localDateTime = this.dateTime.plusMonths(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime plusWeeks(int n) {
        LocalDateTime localDateTime = this.dateTime.plusWeeks(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime plusDays(int n) {
        LocalDateTime localDateTime = this.dateTime.plusDays(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime plusHours(int n) {
        LocalDateTime localDateTime = this.dateTime.plusHours(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime plusMinutes(int n) {
        LocalDateTime localDateTime = this.dateTime.plusMinutes(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime plusSeconds(int n) {
        LocalDateTime localDateTime = this.dateTime.plusSeconds(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime plusNanos(int n) {
        LocalDateTime localDateTime = this.dateTime.plusNanos(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime minus(PeriodProvider periodProvider) {
        LocalDateTime localDateTime = this.dateTime.minus(periodProvider);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime minusYears(int n) {
        LocalDateTime localDateTime = this.dateTime.minusYears(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime minusYears(int n, DateResolver dateResolver) {
        LocalDateTime localDateTime = this.dateTime.minusYears(n, dateResolver);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime minusMonths(int n) {
        LocalDateTime localDateTime = this.dateTime.minusMonths(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime minusMonths(int n, DateResolver dateResolver) {
        LocalDateTime localDateTime = this.dateTime.minusMonths(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime minusWeeks(int n) {
        LocalDateTime localDateTime = this.dateTime.minusWeeks(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime minusDays(int n) {
        LocalDateTime localDateTime = this.dateTime.minusDays(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime minusHours(int n) {
        LocalDateTime localDateTime = this.dateTime.minusHours(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime minusMinutes(int n) {
        LocalDateTime localDateTime = this.dateTime.minusMinutes(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime minusSeconds(int n) {
        LocalDateTime localDateTime = this.dateTime.minusSeconds(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public OffsetDateTime minusNanos(int n) {
        LocalDateTime localDateTime = this.dateTime.minusNanos(n);
        return localDateTime == this.dateTime ? this : new OffsetDateTime(localDateTime, this.offset);
    }

    public boolean matches(DateMatcher dateMatcher) {
        return this.dateTime.matches(dateMatcher);
    }

    public boolean matches(TimeMatcher timeMatcher) {
        return this.dateTime.matches(timeMatcher);
    }

    @Override
    public LocalDate adjustDate(LocalDate localDate) {
        return this.dateTime.adjustDate(localDate);
    }

    @Override
    public LocalTime adjustTime(LocalTime localTime) {
        return this.dateTime.adjustTime(localTime);
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return this.dateTime.matchesDate(localDate);
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        return this.dateTime.matchesTime(localTime);
    }

    public ZonedDateTime atZoneSameInstant(TimeZone timeZone) {
        return ZonedDateTime.fromInstant(this, timeZone);
    }

    public ZonedDateTime atZoneSimilarLocal(TimeZone timeZone) {
        return ZonedDateTime.dateTime(this, timeZone, ZoneResolvers.postTransition());
    }

    public ZonedDateTime atZoneSimilarLocal(TimeZone timeZone, ZoneResolver zoneResolver) {
        return ZonedDateTime.dateTime(this, timeZone, zoneResolver);
    }

    @Override
    public Instant toInstant() {
        int n = this.dateTime.getNanoOfSecond();
        return Instant.instant(this.toEpochSeconds(), n);
    }

    @Override
    public LocalDate toLocalDate() {
        return this.dateTime.toLocalDate();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.dateTime.toLocalTime();
    }

    @Override
    public LocalDateTime toLocalDateTime() {
        return this.dateTime;
    }

    public OffsetDate toOffsetDate() {
        return OffsetDate.date(this.dateTime, this.offset);
    }

    public OffsetTime toOffsetTime() {
        return OffsetTime.time(this.dateTime, this.offset);
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(this.toLocalDate(), this.toLocalTime(), this.offset, null);
    }

    public long toEpochSeconds() {
        long l = this.dateTime.getDate().toEpochDays();
        long l2 = l * 60L * 60L * 24L + (long)this.dateTime.getTime().toSecondOfDay();
        return l2 -= (long)this.offset.getAmountSeconds();
    }

    @Override
    public int compareTo(OffsetDateTime offsetDateTime) {
        if (this.offset.equals(offsetDateTime.offset)) {
            return this.dateTime.compareTo(offsetDateTime.dateTime);
        }
        int n = MathUtils.safeCompare(this.toEpochSeconds(), offsetDateTime.toEpochSeconds());
        if (n == 0) {
            n = this.dateTime.compareTo(offsetDateTime.dateTime);
        }
        return n;
    }

    public boolean isBefore(OffsetDateTime offsetDateTime) {
        long l;
        long l2 = this.toEpochSeconds();
        return l2 < (l = offsetDateTime.toEpochSeconds()) || l2 == l && this.getNanoOfSecond() < offsetDateTime.getNanoOfSecond();
    }

    public boolean equalInstant(OffsetDateTime offsetDateTime) {
        return this.toEpochSeconds() == offsetDateTime.toEpochSeconds() && this.getNanoOfSecond() == offsetDateTime.getNanoOfSecond();
    }

    public boolean isAfter(OffsetDateTime offsetDateTime) {
        long l;
        long l2 = this.toEpochSeconds();
        return l2 > (l = offsetDateTime.toEpochSeconds()) || l2 == l && this.getNanoOfSecond() > offsetDateTime.getNanoOfSecond();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return this.dateTime.equals(offsetDateTime.dateTime) && this.offset.equals(offsetDateTime.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.dateTime.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.dateTime.toString() + this.offset.toString();
    }
}

