/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.util.Map;
import javax.time.CalendricalException;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.zone.ZoneRules;
import javax.time.calendar.zone.ZoneRulesGroup;

public final class TimeZone
implements Serializable {
    private static final long serialVersionUID = 93618758758127L;
    public static final TimeZone UTC = new TimeZone("", "UTC", "", ZoneRules.fixed(ZoneOffset.UTC));
    private final String groupID;
    private final String regionID;
    private final String versionID;
    private volatile transient ZoneRules rules;

    public static TimeZone timeZone(String string, Map<String, TimeZone> map) {
        ISOChronology.checkNotNull(string, "Time Zone ID must not be null");
        ISOChronology.checkNotNull(map, "Alias map must not be null");
        TimeZone timeZone = map.get(string);
        return timeZone == null ? TimeZone.timeZone(string) : timeZone;
    }

    public static TimeZone timeZone(String string) {
        ZoneRulesGroup zoneRulesGroup;
        ISOChronology.checkNotNull(string, "Time zone ID must not be null");
        if (string.equals("UTC") || string.equals("GMT")) {
            return UTC;
        }
        if (string.equals("UTCZ") || string.equals("GMTZ")) {
            throw new CalendricalException("Invalid time zone ID: " + string);
        }
        if (string.startsWith("UTC") || string.startsWith("GMT")) {
            try {
                return TimeZone.timeZone(ZoneOffset.zoneOffset(string.substring(3)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CalendricalException("Invalid time zone ID: " + illegalArgumentException.toString(), illegalArgumentException);
            }
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            zoneRulesGroup = ZoneRulesGroup.getGroup(string.substring(0, n));
            string = string.substring(n + 1);
        } else {
            zoneRulesGroup = ZoneRulesGroup.getGroup("TZDB");
        }
        n = string.indexOf(35);
        String string2 = "";
        if (n >= 0) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        ZoneRules zoneRules = zoneRulesGroup.getRules(string, string2);
        return new TimeZone(zoneRulesGroup.getID(), string, string2, zoneRules);
    }

    public static TimeZone timeZone(ZoneOffset zoneOffset) {
        ISOChronology.checkNotNull(zoneOffset, "ZoneOffset must not be null");
        if (zoneOffset == ZoneOffset.UTC) {
            return UTC;
        }
        String string = "UTC" + zoneOffset.getID();
        ZoneRules zoneRules = ZoneRules.fixed(zoneOffset);
        return new TimeZone("", string, "", zoneRules);
    }

    private TimeZone(String string, String string2, String string3, ZoneRules zoneRules) {
        this.groupID = string;
        this.regionID = string2;
        this.versionID = string3;
        this.rules = zoneRules;
    }

    private Object readResolve() {
        if (this.isFixed()) {
            if ("UTC".equals(this.regionID)) {
                return UTC;
            }
            return TimeZone.timeZone(this.getID());
        }
        return this;
    }

    public String getID() {
        if (this.isFixed()) {
            return this.regionID;
        }
        if (this.groupID.equals("TZDB")) {
            return this.regionID + (this.versionID.length() == 0 ? "" : "#" + this.versionID);
        }
        return this.groupID + ":" + this.regionID + (this.versionID.length() == 0 ? "" : "#" + this.versionID);
    }

    public String getGroupID() {
        return this.groupID;
    }

    public String getRegionID() {
        return this.regionID;
    }

    public String getVersionID() {
        return this.versionID;
    }

    public boolean isFixed() {
        return this.groupID.length() == 0;
    }

    public boolean isFloatingVersion() {
        return this.isFixed() || this.versionID.length() == 0;
    }

    public TimeZone withFloatingVersion() {
        if (this.isFloatingVersion()) {
            return this;
        }
        return new TimeZone(this.groupID, this.regionID, "", null);
    }

    public boolean isLatestVersion() {
        return this.isFloatingVersion() || this.versionID.equals(this.getGroup().getLatestVersionID(this.regionID));
    }

    public TimeZone withLatestVersion() {
        if (this.isFloatingVersion()) {
            return this;
        }
        String string = this.getGroup().getLatestVersionID(this.regionID);
        if (string.equals(this.versionID)) {
            return this;
        }
        return new TimeZone(this.groupID, this.regionID, string, this.rules);
    }

    public TimeZone withVersion(String string) {
        ISOChronology.checkNotNull(string, "Version ID must not be null");
        if (this.isFixed()) {
            if (string.length() > 0) {
                throw new CalendricalException("Fixed time zone does not provide versions");
            }
            return this;
        }
        ZoneRules zoneRules = this.getGroup().getRules(this.regionID, string);
        if (string.equals(this.versionID)) {
            return this;
        }
        return new TimeZone(this.groupID, this.regionID, string, zoneRules);
    }

    public TimeZone withLatestVersionValidFor(OffsetDateTime offsetDateTime) {
        ISOChronology.checkNotNull(offsetDateTime, "OffsetDateTime must not be null");
        if (this.isFixed()) {
            if (!this.getRules().getOffset(offsetDateTime).equals(offsetDateTime.getOffset())) {
                throw new CalendricalException("Fixed time zone " + this.getID() + " is invalid for date-time " + offsetDateTime);
            }
            return this;
        }
        return this.withVersion(this.getGroup().getLatestVersionIDValidFor(this.regionID, offsetDateTime));
    }

    public ZoneRulesGroup getGroup() {
        if (this.isFixed()) {
            throw new CalendricalException("Fixed time zone is not provided by a group");
        }
        return ZoneRulesGroup.getGroup(this.groupID);
    }

    public boolean isValid() {
        if (this.isFixed()) {
            return true;
        }
        if (!ZoneRulesGroup.isValidGroup(this.groupID)) {
            return false;
        }
        ZoneRulesGroup zoneRulesGroup = ZoneRulesGroup.getGroup(this.groupID);
        return zoneRulesGroup.isValidRules(this.regionID, this.versionID);
    }

    public ZoneRules getRules() {
        if (this.rules != null) {
            return this.rules;
        }
        ZoneRulesGroup zoneRulesGroup = ZoneRulesGroup.getGroup(this.groupID);
        ZoneRules zoneRules = zoneRulesGroup.getRules(this.regionID, this.versionID);
        if (this.versionID.length() > 0) {
            this.rules = zoneRules;
        }
        return zoneRules;
    }

    public boolean isValidFor(OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            return false;
        }
        if (this.isFixed()) {
            return this.getRules().getOffset(offsetDateTime).equals(offsetDateTime.getOffset());
        }
        if (!ZoneRulesGroup.isValidGroup(this.groupID)) {
            return false;
        }
        ZoneRulesGroup zoneRulesGroup = ZoneRulesGroup.getGroup(this.groupID);
        return zoneRulesGroup.isValidRulesFor(this.regionID, this.versionID, offsetDateTime);
    }

    public ZoneRules getRulesValidFor(OffsetDateTime offsetDateTime) {
        ISOChronology.checkNotNull(offsetDateTime, "OffsetDateTime must not be null");
        if (this.isFixed()) {
            if (!this.getRules().getOffset(offsetDateTime).equals(offsetDateTime.getOffset())) {
                throw new CalendricalException("Fixed time zone " + this.getID() + " is invalid for date-time " + offsetDateTime);
            }
            return ZoneRules.fixed(this.getRules().getOffset(offsetDateTime));
        }
        ZoneRulesGroup zoneRulesGroup = ZoneRulesGroup.getGroup(this.groupID);
        return zoneRulesGroup.getRulesValidFor(this.regionID, this.versionID, offsetDateTime);
    }

    public String getName() {
        return this.regionID;
    }

    public String getShortName() {
        return this.regionID;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TimeZone) {
            TimeZone timeZone = (TimeZone)object;
            return this.regionID.equals(timeZone.regionID) && this.versionID.equals(timeZone.versionID) && this.groupID.equals(timeZone.groupID);
        }
        return false;
    }

    public int hashCode() {
        return this.groupID.hashCode() ^ this.regionID.hashCode() ^ this.versionID.hashCode();
    }

    public String toString() {
        return this.getID();
    }
}

