/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import javax.time.CalendricalException;
import javax.time.Instant;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.TimeZone;
import javax.time.calendar.ZoneResolver;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneRules;

public final class ZoneResolvers {
    private ZoneResolvers() {
    }

    public static ZoneResolver strict() {
        return Strict.INSTANCE;
    }

    public static ZoneResolver preTransition() {
        return PreTransition.INSTANCE;
    }

    public static ZoneResolver postTransition() {
        return PostTransition.INSTANCE;
    }

    public static ZoneResolver postGapPreOverlap() {
        return PostGapPreOverlap.INSTANCE;
    }

    public static ZoneResolver retainOffset() {
        return RetainOffset.INSTANCE;
    }

    public static ZoneResolver pushForward() {
        return PushForward.INSTANCE;
    }

    public static ZoneResolver combination(ZoneResolver zoneResolver, ZoneResolver zoneResolver2) {
        zoneResolver = zoneResolver == null ? ZoneResolvers.strict() : zoneResolver;
        ZoneResolver zoneResolver3 = zoneResolver2 = zoneResolver2 == null ? ZoneResolvers.strict() : zoneResolver2;
        if (zoneResolver == zoneResolver2) {
            return zoneResolver;
        }
        return new Combination(zoneResolver, zoneResolver2);
    }

    private static class Combination
    extends ZoneResolver {
        private final ZoneResolver gapResolver;
        private final ZoneResolver overlapResolver;

        public Combination(ZoneResolver zoneResolver, ZoneResolver zoneResolver2) {
            this.gapResolver = zoneResolver;
            this.overlapResolver = zoneResolver2;
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            return this.gapResolver.handleGap(timeZone, zoneRules, zoneOffsetTransition, localDateTime, offsetDateTime);
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            return this.overlapResolver.handleOverlap(timeZone, zoneRules, zoneOffsetTransition, localDateTime, offsetDateTime);
        }
    }

    private static class PushForward
    extends ZoneResolver {
        private static final ZoneResolver INSTANCE = new PushForward();

        private PushForward() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            LocalDateTime localDateTime2 = localDateTime.plus(zoneOffsetTransition.getTransitionSize());
            return OffsetDateTime.dateTime(localDateTime2, zoneOffsetTransition.getOffsetAfter());
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            return OffsetDateTime.dateTime(localDateTime, zoneOffsetTransition.getOffsetAfter());
        }
    }

    private static class RetainOffset
    extends ZoneResolver {
        private static final ZoneResolver INSTANCE = new RetainOffset();

        private RetainOffset() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            return zoneOffsetTransition.getDateTimeAfter();
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            if (offsetDateTime != null && zoneOffsetTransition.isValidOffset(offsetDateTime.getOffset())) {
                return OffsetDateTime.dateTime(localDateTime, offsetDateTime.getOffset());
            }
            return OffsetDateTime.dateTime(localDateTime, zoneOffsetTransition.getOffsetAfter());
        }
    }

    private static class PostGapPreOverlap
    extends ZoneResolver {
        private static final ZoneResolver INSTANCE = new PostGapPreOverlap();

        private PostGapPreOverlap() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            return zoneOffsetTransition.getDateTimeAfter();
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            return OffsetDateTime.dateTime(localDateTime, zoneOffsetTransition.getOffsetBefore());
        }
    }

    private static class PostTransition
    extends ZoneResolver {
        private static final ZoneResolver INSTANCE = new PostTransition();

        private PostTransition() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            return zoneOffsetTransition.getDateTimeAfter();
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            return OffsetDateTime.dateTime(localDateTime, zoneOffsetTransition.getOffsetAfter());
        }
    }

    private static class PreTransition
    extends ZoneResolver {
        private static final ZoneResolver INSTANCE = new PreTransition();

        private PreTransition() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            Instant instant = zoneOffsetTransition.getInstant().minusNanos(1L);
            return OffsetDateTime.fromInstant(instant, zoneOffsetTransition.getOffsetBefore());
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            return OffsetDateTime.dateTime(localDateTime, zoneOffsetTransition.getOffsetBefore());
        }
    }

    private static class Strict
    extends ZoneResolver {
        private static final Strict INSTANCE = new Strict();

        private Strict() {
        }

        @Override
        protected OffsetDateTime handleGap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            throw new CalendricalException("Local time " + localDateTime + " does not exist in time zone " + timeZone + " due to a gap in the local time-line");
        }

        @Override
        protected OffsetDateTime handleOverlap(TimeZone timeZone, ZoneRules zoneRules, ZoneOffsetTransition zoneOffsetTransition, LocalDateTime localDateTime, OffsetDateTime offsetDateTime) {
            throw new CalendricalException("Local time " + localDateTime + " has two matching offsets, " + zoneOffsetTransition.getOffsetBefore() + " and " + zoneOffsetTransition.getOffsetAfter() + ", in time zone " + timeZone);
        }
    }
}

