/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.calendar.CalendarConversionException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.DateTimeProvider;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.TimeZone;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZoneResolver;
import javax.time.calendar.ZoneResolvers;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.DayOfYear;
import javax.time.calendar.field.HourOfDay;
import javax.time.calendar.field.MinuteOfHour;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.NanoOfSecond;
import javax.time.calendar.field.SecondOfMinute;
import javax.time.calendar.field.Year;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.calendar.zone.ZoneRules;
import javax.time.period.PeriodProvider;

public final class ZonedDateTime
implements InstantProvider,
DateTimeProvider,
CalendricalProvider,
Comparable<ZonedDateTime>,
Serializable {
    private static final long serialVersionUID = -456761901L;
    private final OffsetDateTime dateTime;
    private final TimeZone zone;

    public static ZonedDateTime dateTime(DateProvider dateProvider, TimeProvider timeProvider, TimeZone timeZone) {
        return ZonedDateTime.dateTime(dateProvider, timeProvider, timeZone, ZoneResolvers.strict());
    }

    public static ZonedDateTime dateTime(DateProvider dateProvider, TimeProvider timeProvider, TimeZone timeZone, ZoneResolver zoneResolver) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(dateProvider, timeProvider);
        return ZonedDateTime.resolve(localDateTime, null, timeZone, zoneResolver);
    }

    public static ZonedDateTime dateTime(DateTimeProvider dateTimeProvider, TimeZone timeZone) {
        return ZonedDateTime.dateTime(dateTimeProvider, timeZone, ZoneResolvers.strict());
    }

    public static ZonedDateTime dateTime(DateTimeProvider dateTimeProvider, TimeZone timeZone, ZoneResolver zoneResolver) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(dateTimeProvider);
        return ZonedDateTime.resolve(localDateTime, null, timeZone, zoneResolver);
    }

    public static ZonedDateTime dateTime(OffsetDateTime offsetDateTime, TimeZone timeZone) {
        ISOChronology.checkNotNull(offsetDateTime, "OffsetDateTime must not be null");
        ISOChronology.checkNotNull(timeZone, "TimeZone must not be null");
        ZoneOffset zoneOffset = offsetDateTime.getOffset();
        ZoneRules zoneRules = timeZone.getRules();
        ZoneRules.OffsetInfo offsetInfo = zoneRules.getOffsetInfo(offsetDateTime.toLocalDateTime());
        if (!offsetInfo.isValidOffset(zoneOffset)) {
            if (offsetInfo.isDiscontinuity() && offsetInfo.getDiscontinuity().isGap()) {
                throw new CalendarConversionException("The local time " + offsetDateTime.toLocalDateTime() + " does not exist in time zone " + timeZone + " due to a daylight savings gap");
            }
            throw new CalendarConversionException("The offset in the date-time " + offsetDateTime + " is invalid for time zone " + timeZone);
        }
        return new ZonedDateTime(offsetDateTime, timeZone);
    }

    public static ZonedDateTime fromInstant(InstantProvider instantProvider, TimeZone timeZone) {
        Instant instant = Instant.instant(instantProvider);
        ISOChronology.checkNotNull(timeZone, "TimeZone must not be null");
        ZoneRules zoneRules = timeZone.getRules();
        OffsetDateTime offsetDateTime = OffsetDateTime.fromInstant(instant, zoneRules.getOffset(instant));
        return new ZonedDateTime(offsetDateTime, timeZone);
    }

    public static ZonedDateTime fromInstant(OffsetDateTime offsetDateTime, TimeZone timeZone) {
        ISOChronology.checkNotNull(offsetDateTime, "OffsetDateTime must not be null");
        ISOChronology.checkNotNull(timeZone, "TimeZone must not be null");
        ZoneRules zoneRules = timeZone.getRules();
        if (!zoneRules.isValidDateTime(offsetDateTime)) {
            ZoneOffset zoneOffset = zoneRules.getOffset(offsetDateTime);
            offsetDateTime = offsetDateTime.withOffsetSameInstant(zoneOffset);
        }
        return new ZonedDateTime(offsetDateTime, timeZone);
    }

    public static ZonedDateTime parse(String string) {
        return DateTimeFormatters.isoZonedDateTime().parse(string).mergeStrict().toZonedDateTime();
    }

    private static ZonedDateTime resolve(LocalDateTime localDateTime, ZonedDateTime zonedDateTime, TimeZone timeZone, ZoneResolver zoneResolver) {
        ISOChronology.checkNotNull(localDateTime, "LocalDateTime must not be null");
        ISOChronology.checkNotNull(timeZone, "TimeZone must not be null");
        ISOChronology.checkNotNull(zoneResolver, "ZoneResolver must not be null");
        OffsetDateTime offsetDateTime = zoneResolver.resolve(timeZone, localDateTime, zonedDateTime);
        return new ZonedDateTime(offsetDateTime, timeZone);
    }

    private ZonedDateTime(OffsetDateTime offsetDateTime, TimeZone timeZone) {
        this.dateTime = offsetDateTime;
        this.zone = timeZone;
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    public boolean isSupported(DateTimeFieldRule dateTimeFieldRule) {
        return this.dateTime.isSupported(dateTimeFieldRule);
    }

    public int get(DateTimeFieldRule dateTimeFieldRule) {
        return this.dateTime.get(dateTimeFieldRule);
    }

    public LocalDateTime getDateTime() {
        return this.dateTime.getDateTime();
    }

    public ZonedDateTime withDateTime(DateTimeProvider dateTimeProvider) {
        LocalDateTime localDateTime = LocalDateTime.dateTime(dateTimeProvider);
        return localDateTime.equals(this.dateTime.toLocalDateTime()) ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZoneOffset getOffset() {
        return this.dateTime.getOffset();
    }

    public ZonedDateTime withEarlierOffsetAtOverlap() {
        ZoneOffset zoneOffset;
        ZoneRules.OffsetInfo offsetInfo = this.getApplicableRules().getOffsetInfo(this.toLocalDateTime());
        if (offsetInfo.isDiscontinuity() && !(zoneOffset = offsetInfo.getDiscontinuity().getOffsetBefore()).equals(this.getOffset())) {
            OffsetDateTime offsetDateTime = this.dateTime.withOffsetSameLocal(zoneOffset);
            return new ZonedDateTime(offsetDateTime, this.zone);
        }
        return this;
    }

    public ZonedDateTime withLaterOffsetAtOverlap() {
        ZoneOffset zoneOffset;
        ZoneRules.OffsetInfo offsetInfo = this.getApplicableRules().getOffsetInfo(this.toLocalDateTime());
        if (offsetInfo.isDiscontinuity() && !(zoneOffset = offsetInfo.getDiscontinuity().getOffsetAfter()).equals(this.getOffset())) {
            OffsetDateTime offsetDateTime = this.dateTime.withOffsetSameLocal(zoneOffset);
            return new ZonedDateTime(offsetDateTime, this.zone);
        }
        return this;
    }

    public TimeZone getZone() {
        return this.zone;
    }

    public ZonedDateTime withZoneSameLocal(TimeZone timeZone) {
        return this.withZoneSameLocal(timeZone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withZoneSameLocal(TimeZone timeZone, ZoneResolver zoneResolver) {
        ISOChronology.checkNotNull(timeZone, "TimeZone must not be null");
        ISOChronology.checkNotNull(zoneResolver, "ZoneResolver must not be null");
        return timeZone == this.zone ? this : ZonedDateTime.resolve(this.dateTime.toLocalDateTime(), this, timeZone, zoneResolver);
    }

    public ZonedDateTime withZoneSameInstant(TimeZone timeZone) {
        return timeZone == this.zone ? this : ZonedDateTime.fromInstant(this.dateTime, timeZone);
    }

    public TimeZone getApplicableZone() {
        if (this.zone.isFloatingVersion()) {
            return this.zone.withLatestVersionValidFor(this.dateTime);
        }
        return this.zone;
    }

    public ZoneRules getApplicableRules() {
        return this.zone.getRulesValidFor(this.dateTime);
    }

    public Year toYear() {
        return this.dateTime.toYear();
    }

    public MonthOfYear toMonthOfYear() {
        return this.dateTime.toMonthOfYear();
    }

    public DayOfMonth toDayOfMonth() {
        return this.dateTime.toDayOfMonth();
    }

    public DayOfYear toDayOfYear() {
        return this.dateTime.toDayOfYear();
    }

    public DayOfWeek toDayOfWeek() {
        return this.dateTime.toDayOfWeek();
    }

    public HourOfDay toHourOfDay() {
        return this.dateTime.toHourOfDay();
    }

    public MinuteOfHour toMinuteOfHour() {
        return this.dateTime.toMinuteOfHour();
    }

    public SecondOfMinute toSecondOfMinute() {
        return this.dateTime.toSecondOfMinute();
    }

    public NanoOfSecond toNanoOfSecond() {
        return this.dateTime.toNanoOfSecond();
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public MonthOfYear getMonthOfYear() {
        return this.dateTime.getMonthOfYear();
    }

    public int getDayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime.getDayOfWeek();
    }

    public int getHourOfDay() {
        return this.dateTime.getHourOfDay();
    }

    public int getMinuteOfHour() {
        return this.dateTime.getMinuteOfHour();
    }

    public int getSecondOfMinute() {
        return this.dateTime.getSecondOfMinute();
    }

    public int getNanoOfSecond() {
        return this.dateTime.getNanoOfSecond();
    }

    public ZonedDateTime with(DateAdjuster dateAdjuster) {
        return this.with(dateAdjuster, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime with(DateAdjuster dateAdjuster, ZoneResolver zoneResolver) {
        ISOChronology.checkNotNull(dateAdjuster, "DateAdjuster must not be null");
        ISOChronology.checkNotNull(zoneResolver, "ZoneResolver must not be null");
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().with(dateAdjuster);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, zoneResolver);
    }

    public ZonedDateTime with(TimeAdjuster timeAdjuster) {
        return this.with(timeAdjuster, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime with(TimeAdjuster timeAdjuster, ZoneResolver zoneResolver) {
        ISOChronology.checkNotNull(timeAdjuster, "TimeAdjuster must not be null");
        ISOChronology.checkNotNull(zoneResolver, "ZoneResolver must not be null");
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().with(timeAdjuster);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, zoneResolver);
    }

    public ZonedDateTime withYear(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().withYear(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withMonthOfYear(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().withMonthOfYear(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withDayOfMonth(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().withDayOfMonth(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withDate(int n, int n2, int n3) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().withDate(n, n2, n3);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withHourOfDay(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().withHourOfDay(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withMinuteOfHour(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().withMinuteOfHour(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withSecondOfMinute(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().withSecondOfMinute(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withNanoOfSecond(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().withNanoOfSecond(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withTime(int n, int n2) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().withTime(n, n2);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withTime(int n, int n2, int n3) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().withTime(n, n2, n3);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime withTime(int n, int n2, int n3, int n4) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().withTime(n, n2, n3, n4);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plus(PeriodProvider periodProvider) {
        return this.plus(periodProvider, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plus(PeriodProvider periodProvider, ZoneResolver zoneResolver) {
        ISOChronology.checkNotNull(periodProvider, "PeriodProvider must not be null");
        ISOChronology.checkNotNull(zoneResolver, "ZoneResolver must not be null");
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().plus(periodProvider);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, zoneResolver);
    }

    public ZonedDateTime plusYears(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().plusYears(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusMonths(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().plusMonths(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusWeeks(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().plusWeeks(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusDays(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().plusDays(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusHours(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().plusHours(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusMinutes(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().plusMinutes(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusSeconds(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().plusSeconds(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime plusNanos(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().plusNanos(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minus(PeriodProvider periodProvider) {
        return this.minus(periodProvider, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minus(PeriodProvider periodProvider, ZoneResolver zoneResolver) {
        ISOChronology.checkNotNull(periodProvider, "PeriodProvider must not be null");
        ISOChronology.checkNotNull(zoneResolver, "ZoneResolver must not be null");
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().minus(periodProvider);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, zoneResolver);
    }

    public ZonedDateTime minusYears(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().minusYears(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusMonths(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().minusMonths(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusWeeks(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().minusWeeks(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusDays(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().minusDays(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusHours(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().minusHours(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusMinutes(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().minusMinutes(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusSeconds(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().minusSeconds(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public ZonedDateTime minusNanos(int n) {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime().minusNanos(n);
        return localDateTime == this.dateTime.toLocalDateTime() ? this : ZonedDateTime.resolve(localDateTime, this, this.zone, ZoneResolvers.retainOffset());
    }

    public boolean matches(DateMatcher dateMatcher) {
        return this.dateTime.matches(dateMatcher);
    }

    public boolean matches(TimeMatcher timeMatcher) {
        return this.dateTime.matches(timeMatcher);
    }

    @Override
    public Instant toInstant() {
        return this.dateTime.toInstant();
    }

    @Override
    public LocalDate toLocalDate() {
        return this.dateTime.toLocalDate();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.dateTime.toLocalTime();
    }

    @Override
    public LocalDateTime toLocalDateTime() {
        return this.dateTime.toLocalDateTime();
    }

    public OffsetDate toOffsetDate() {
        return this.dateTime.toOffsetDate();
    }

    public OffsetTime toOffsetTime() {
        return this.dateTime.toOffsetTime();
    }

    public OffsetDateTime toOffsetDateTime() {
        return this.dateTime;
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(this.toLocalDate(), this.toLocalTime(), this.getOffset(), this.zone);
    }

    @Override
    public int compareTo(ZonedDateTime zonedDateTime) {
        int n = this.dateTime.compareTo(zonedDateTime.dateTime);
        if (n == 0) {
            n = this.zone.getID().compareTo(zonedDateTime.zone.getID());
        }
        return n;
    }

    public boolean isAfter(ZonedDateTime zonedDateTime) {
        return this.compareTo(zonedDateTime) > 0;
    }

    public boolean isBefore(ZonedDateTime zonedDateTime) {
        return this.compareTo(zonedDateTime) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return this.dateTime.equals(zonedDateTime.dateTime) && this.zone.equals(zonedDateTime.zone);
        }
        return false;
    }

    public int hashCode() {
        return this.dateTime.hashCode() ^ this.zone.hashCode();
    }

    public String toString() {
        return this.dateTime.toString() + '[' + this.zone.toString() + ']';
    }
}

