/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.util.Locale;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeFormatterBuilder;

public enum DayOfWeek implements CalendricalProvider,
DateMatcher
{
    MONDAY(1),
    TUESDAY(2),
    WEDNESDAY(3),
    THURSDAY(4),
    FRIDAY(5),
    SATURDAY(6),
    SUNDAY(7);

    private final int dayOfWeek;

    public static DateTimeFieldRule rule() {
        return ISOChronology.dayOfWeekRule();
    }

    public static DayOfWeek dayOfWeek(int n) {
        switch (n) {
            case 1: {
                return MONDAY;
            }
            case 2: {
                return TUESDAY;
            }
            case 3: {
                return WEDNESDAY;
            }
            case 4: {
                return THURSDAY;
            }
            case 5: {
                return FRIDAY;
            }
            case 6: {
                return SATURDAY;
            }
            case 7: {
                return SUNDAY;
            }
        }
        throw new IllegalCalendarFieldValueException(DayOfWeek.rule(), n, 1, 7);
    }

    public static DayOfWeek dayOfWeek(DateProvider dateProvider) {
        long l = LocalDate.date(dateProvider).toModifiedJulianDays();
        if (l < 0L) {
            long l2 = l / 7L;
            l += (-l2 + 1L) * 7L;
        }
        int n = (int)((l + 2L) % 7L);
        return DayOfWeek.dayOfWeek(n + 1);
    }

    public static DayOfWeek firstDayOfWeekFor(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Locale must not be null");
        }
        if (locale.equals(Locale.US) || locale.getLanguage().equals("pt") && locale.getCountry().equals("BR")) {
            return SUNDAY;
        }
        return MONDAY;
    }

    private DayOfWeek(int n2) {
        this.dayOfWeek = n2;
    }

    public int getValue() {
        return this.dayOfWeek;
    }

    public String getShortText(Locale locale) {
        DateTimeFormatSymbols dateTimeFormatSymbols = DateTimeFormatSymbols.getInstance(locale);
        String string = dateTimeFormatSymbols.getFieldValueText(DayOfWeek.rule(), DateTimeFormatterBuilder.TextStyle.SHORT, this.dayOfWeek);
        return string == null ? Integer.toString(this.dayOfWeek) : string;
    }

    public String getText(Locale locale) {
        DateTimeFormatSymbols dateTimeFormatSymbols = DateTimeFormatSymbols.getInstance(locale);
        String string = dateTimeFormatSymbols.getFieldValueText(DayOfWeek.rule(), DateTimeFormatterBuilder.TextStyle.FULL, this.dayOfWeek);
        return string == null ? Integer.toString(this.dayOfWeek) : string;
    }

    public DayOfWeek next() {
        return DayOfWeek.values()[(this.ordinal() + 1) % 7];
    }

    public DayOfWeek previous() {
        return DayOfWeek.values()[(this.ordinal() + 7 - 1) % 7];
    }

    public DayOfWeek plusDays(int n) {
        return DayOfWeek.values()[(this.ordinal() + n % 7) % 7];
    }

    public DayOfWeek minusDays(int n) {
        return DayOfWeek.values()[(this.ordinal() + 7 - n % 7) % 7];
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return localDate.getDayOfWeek() == this;
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(DayOfWeek.rule(), this.getValue());
    }

    public String toString() {
        return "DayOfWeek=" + this.name();
    }
}

