/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.Year;

public final class DayOfYear
implements CalendricalProvider,
Comparable<DayOfYear>,
DateAdjuster,
DateMatcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceArray<DayOfYear> CACHE = new AtomicReferenceArray(366);
    private static final int[] STANDARD_MONTH_START = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP_MONTH_START = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private final int dayOfYear;

    public static DateTimeFieldRule rule() {
        return ISOChronology.dayOfYearRule();
    }

    public static DayOfYear dayOfYear(int n) {
        try {
            DayOfYear dayOfYear = CACHE.get(--n);
            if (dayOfYear == null) {
                DayOfYear dayOfYear2 = new DayOfYear(n + 1);
                CACHE.compareAndSet(n, null, dayOfYear2);
                dayOfYear = CACHE.get(n);
            }
            return dayOfYear;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalCalendarFieldValueException(DayOfYear.rule(), ++n, 1, 366);
        }
    }

    public static DayOfYear dayOfYear(DateProvider dateProvider) {
        LocalDate localDate = LocalDate.date(dateProvider);
        int n = localDate.getMonthOfYear().ordinal();
        int n2 = localDate.getDayOfMonth();
        if (ISOChronology.isLeapYear(localDate.getYear())) {
            return DayOfYear.dayOfYear(LEAP_MONTH_START[n] + n2);
        }
        return DayOfYear.dayOfYear(STANDARD_MONTH_START[n] + n2);
    }

    private DayOfYear(int n) {
        this.dayOfYear = n;
    }

    private Object readResolve() {
        return DayOfYear.dayOfYear(this.dayOfYear);
    }

    public int getValue() {
        return this.dayOfYear;
    }

    @Override
    public LocalDate adjustDate(LocalDate localDate) {
        return this.atYear(localDate.toYear());
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return localDate.getDayOfYear() == this.dayOfYear;
    }

    public boolean isValid(Year year) {
        if (year == null) {
            throw new NullPointerException("Year must not be null");
        }
        return this.dayOfYear < 366 || year.isLeap();
    }

    public boolean isValid(int n) {
        ISOChronology.yearRule().checkValue(n);
        return this.dayOfYear < 366 || ISOChronology.isLeapYear(n);
    }

    public LocalDate atYear(Year year) {
        if (year == null) {
            throw new NullPointerException("Year must not be null");
        }
        return this.atYear(year.getValue());
    }

    public LocalDate atYear(int n) {
        int n2;
        boolean bl = ISOChronology.isLeapYear(n);
        if (this.dayOfYear == 366 && !bl) {
            throw new InvalidCalendarFieldException("DayOfYear 366 is invalid for year " + n, DayOfYear.rule());
        }
        int n3 = this.dayOfYear - 1;
        int[] nArray = bl ? LEAP_MONTH_START : STANDARD_MONTH_START;
        for (n2 = 1; n2 < 12 && n3 >= nArray[n2]; ++n2) {
        }
        MonthOfYear monthOfYear = MonthOfYear.monthOfYear(n2);
        int n4 = this.dayOfYear - nArray[n2 - 1];
        return LocalDate.date(n, monthOfYear, n4);
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(DayOfYear.rule(), this.getValue());
    }

    @Override
    public int compareTo(DayOfYear dayOfYear) {
        return MathUtils.safeCompare(this.dayOfYear, dayOfYear.dayOfYear);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.dayOfYear;
    }

    public String toString() {
        return "DayOfYear=" + this.getValue();
    }
}

