/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import javax.time.calendar.Calendrical;
import javax.time.calendar.DateAdjustor;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.FlexiDateTime;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.Year;

public enum Era implements Calendrical,
DateAdjustor,
DateMatcher
{
    BC(0),
    AD(1);

    public static final DateTimeFieldRule RULE;
    private final int era;

    public static Era era(int n) {
        switch (n) {
            case 0: {
                return BC;
            }
            case 1: {
                return AD;
            }
        }
        throw new IllegalCalendarFieldValueException(RULE, n, 0, 1);
    }

    public static Era era(DateProvider dateProvider) {
        return LocalDate.date(dateProvider).getYear().getEra();
    }

    private Era(int n2) {
        this.era = n2;
    }

    public int getValue() {
        return this.era;
    }

    public FlexiDateTime toFlexiDateTime() {
        return new FlexiDateTime(RULE, this.getValue());
    }

    @Override
    public LocalDate adjustDate(LocalDate localDate) {
        if (this == localDate.getYear().getEra()) {
            return localDate;
        }
        Year year = Year.year((Era)this, (int)localDate.getYear().getYearOfEra());
        return LocalDate.date(year, localDate.getMonthOfYear(), localDate.getDayOfMonth());
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return localDate.getYear().getEra() == this;
    }

    public boolean isBC() {
        return this == BC;
    }

    public boolean isAD() {
        return this == AD;
    }

    static {
        RULE = new Rule();
    }

    private static class Rule
    extends DateTimeFieldRule {
        protected Rule() {
            super("Era", null, null, 0, 1);
        }

        protected Integer extractValue(FlexiDateTime flexiDateTime) {
            return flexiDateTime.getDate() != null ? Integer.valueOf(flexiDateTime.getDate().getYear().getEra().getValue()) : null;
        }
    }
}

