/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.field.AmPmOfDay;

public final class HourOfDay
implements CalendricalProvider,
Comparable<HourOfDay>,
TimeAdjuster,
TimeMatcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceArray<HourOfDay> CACHE = new AtomicReferenceArray(24);
    private final int hourOfDay;

    public static DateTimeFieldRule rule() {
        return ISOChronology.hourOfDayRule();
    }

    public static HourOfDay hourOfDay(int n) {
        try {
            HourOfDay hourOfDay = CACHE.get(n);
            if (hourOfDay == null) {
                HourOfDay hourOfDay2 = new HourOfDay(n);
                CACHE.compareAndSet(n, null, hourOfDay2);
                hourOfDay = CACHE.get(n);
            }
            return hourOfDay;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalCalendarFieldValueException(HourOfDay.rule(), n, HourOfDay.rule().getMinimumValue(), HourOfDay.rule().getMaximumValue());
        }
    }

    public static HourOfDay hourOfDay(AmPmOfDay amPmOfDay, int n) {
        ISOChronology.hourOfAmPmRule().checkValue(n);
        int n2 = amPmOfDay.getValue() * 12 + n;
        return HourOfDay.hourOfDay(n2);
    }

    public static HourOfDay hourOfDay(TimeProvider timeProvider) {
        return LocalTime.time(timeProvider).toHourOfDay();
    }

    private HourOfDay(int n) {
        this.hourOfDay = n;
    }

    private Object readResolve() {
        return HourOfDay.hourOfDay(this.hourOfDay);
    }

    public int getValue() {
        return this.hourOfDay;
    }

    @Override
    public LocalTime adjustTime(LocalTime localTime) {
        return localTime.withHourOfDay(this.hourOfDay);
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        return this.hourOfDay == localTime.getHourOfDay();
    }

    public AmPmOfDay getAmPm() {
        return AmPmOfDay.amPmOfDay(this.hourOfDay / 12);
    }

    public int getHourOfAmPm() {
        return this.hourOfDay % 12;
    }

    public int getClockHourOfAmPm() {
        return (this.hourOfDay + 11) % 12 + 1;
    }

    public int getClockHourOfDay() {
        return this.hourOfDay == 0 ? 24 : this.hourOfDay;
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(HourOfDay.rule(), this.getValue());
    }

    @Override
    public int compareTo(HourOfDay hourOfDay) {
        int n = this.hourOfDay;
        int n2 = hourOfDay.hourOfDay;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.hourOfDay;
    }

    public String toString() {
        return "HourOfDay=" + this.getValue();
    }
}

