/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.util.Locale;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateResolvers;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.MonthDay;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.QuarterOfYear;
import javax.time.calendar.field.Year;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeFormatterBuilder;

public enum MonthOfYear implements CalendricalProvider,
DateAdjuster,
DateMatcher
{
    JANUARY(1),
    FEBRUARY(2),
    MARCH(3),
    APRIL(4),
    MAY(5),
    JUNE(6),
    JULY(7),
    AUGUST(8),
    SEPTEMBER(9),
    OCTOBER(10),
    NOVEMBER(11),
    DECEMBER(12);

    private final int monthOfYear;

    public static DateTimeFieldRule rule() {
        return ISOChronology.monthOfYearRule();
    }

    public static MonthOfYear monthOfYear(int n) {
        switch (n) {
            case 1: {
                return JANUARY;
            }
            case 2: {
                return FEBRUARY;
            }
            case 3: {
                return MARCH;
            }
            case 4: {
                return APRIL;
            }
            case 5: {
                return MAY;
            }
            case 6: {
                return JUNE;
            }
            case 7: {
                return JULY;
            }
            case 8: {
                return AUGUST;
            }
            case 9: {
                return SEPTEMBER;
            }
            case 10: {
                return OCTOBER;
            }
            case 11: {
                return NOVEMBER;
            }
            case 12: {
                return DECEMBER;
            }
        }
        throw new IllegalCalendarFieldValueException(MonthOfYear.rule(), n, 1, 12);
    }

    public static MonthOfYear monthOfYear(DateProvider dateProvider) {
        return LocalDate.date(dateProvider).getMonthOfYear();
    }

    private MonthOfYear(int n2) {
        this.monthOfYear = n2;
    }

    public int getValue() {
        return this.monthOfYear;
    }

    public String getShortText(Locale locale) {
        DateTimeFormatSymbols dateTimeFormatSymbols = DateTimeFormatSymbols.getInstance(locale);
        String string = dateTimeFormatSymbols.getFieldValueText(MonthOfYear.rule(), DateTimeFormatterBuilder.TextStyle.SHORT, this.monthOfYear);
        return string == null ? Integer.toString(this.monthOfYear) : string;
    }

    public String getText(Locale locale) {
        DateTimeFormatSymbols dateTimeFormatSymbols = DateTimeFormatSymbols.getInstance(locale);
        String string = dateTimeFormatSymbols.getFieldValueText(MonthOfYear.rule(), DateTimeFormatterBuilder.TextStyle.FULL, this.monthOfYear);
        return string == null ? Integer.toString(this.monthOfYear) : string;
    }

    public MonthOfYear next() {
        return MonthOfYear.values()[(this.ordinal() + 1) % 12];
    }

    public MonthOfYear previous() {
        return MonthOfYear.values()[(this.ordinal() + 12 - 1) % 12];
    }

    public MonthOfYear plusMonths(int n) {
        return MonthOfYear.values()[(this.ordinal() + n % 12) % 12];
    }

    public MonthOfYear minusMonths(int n) {
        return MonthOfYear.values()[(this.ordinal() + 12 - n % 12) % 12];
    }

    @Override
    public LocalDate adjustDate(LocalDate localDate) {
        return this.adjustDate(localDate, DateResolvers.previousValid());
    }

    public LocalDate adjustDate(LocalDate localDate, DateResolver dateResolver) {
        return localDate.withMonthOfYear(this.monthOfYear, dateResolver);
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return localDate.getMonthOfYear() == this;
    }

    public int lengthInDays(Year year) {
        if (year == null) {
            throw new NullPointerException("The year must not be null");
        }
        switch (this) {
            case FEBRUARY: {
                return year.isLeap() ? 29 : 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int lengthInDays(int n) {
        ISOChronology.yearRule().checkValue(n);
        switch (this) {
            case FEBRUARY: {
                return ISOChronology.isLeapYear(n) ? 29 : 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int minLengthInDays() {
        switch (this) {
            case FEBRUARY: {
                return 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int maxLengthInDays() {
        switch (this) {
            case FEBRUARY: {
                return 29;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public DayOfMonth getLastDayOfMonth(Year year) {
        return DayOfMonth.dayOfMonth(this.lengthInDays(year));
    }

    public QuarterOfYear getQuarterOfYear() {
        if (this.ordinal() < 3) {
            return QuarterOfYear.Q1;
        }
        if (this.ordinal() < 6) {
            return QuarterOfYear.Q2;
        }
        if (this.ordinal() < 9) {
            return QuarterOfYear.Q3;
        }
        return QuarterOfYear.Q4;
    }

    public int getMonthOfQuarter() {
        return this.ordinal() % 3 + 1;
    }

    public MonthDay atDay(DayOfMonth dayOfMonth) {
        return this.atDay(dayOfMonth.getValue());
    }

    public MonthDay atDay(int n) {
        return MonthDay.monthDay(this, n);
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(MonthOfYear.rule(), this.getValue());
    }

    public String toString() {
        return "MonthOfYear=" + this.name();
    }
}

