/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.WeekOfWeekBasedYear;
import javax.time.calendar.field.Year;

public final class WeekBasedYear
implements CalendricalProvider,
Comparable<WeekBasedYear>,
DateMatcher,
Serializable {
    public static final int MIN_YEAR = -2147483646;
    public static final int MAX_YEAR = Integer.MAX_VALUE;
    private static final long serialVersionUID = 1L;
    private final int weekyear;

    public static DateTimeFieldRule rule() {
        return ISOChronology.weekBasedYearRule();
    }

    public static WeekBasedYear weekyear(int n) {
        WeekBasedYear.rule().checkValue(n);
        return new WeekBasedYear(n);
    }

    public static WeekBasedYear weekyear(DateProvider dateProvider) {
        LocalDate localDate = LocalDate.date(dateProvider);
        return WeekBasedYear.weekyear(WeekBasedYear.computeYear(localDate).getValue());
    }

    static Year computeYear(LocalDate localDate) {
        Year year = localDate.toYear();
        switch (localDate.getMonthOfYear()) {
            case JANUARY: {
                int n;
                int n2 = localDate.getDayOfMonth();
                if (n2 >= 4 || (n = localDate.getDayOfWeek().getValue()) <= n2 + 3) break;
                year = year.previous();
                break;
            }
            case DECEMBER: {
                int n;
                int n3 = localDate.getDayOfMonth();
                if (n3 <= 28 || (n = localDate.getDayOfWeek().getValue()) > n3 % 7) break;
                year = year.next();
            }
        }
        return year;
    }

    private WeekBasedYear(int n) {
        this.weekyear = n;
    }

    public int getValue() {
        return this.weekyear;
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return WeekBasedYear.weekyear(localDate).equals(this);
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(WeekBasedYear.rule(), this.getValue());
    }

    public int lengthInWeeks() {
        LocalDate localDate = LocalDate.date(this.weekyear, MonthOfYear.JANUARY, 4);
        LocalDate localDate2 = LocalDate.date(this.weekyear, MonthOfYear.DECEMBER, 28);
        long l = (localDate2.toModifiedJulianDays() + (long)(8 - localDate2.getDayOfWeek().getValue()) - localDate.toModifiedJulianDays() + (long)localDate.getDayOfWeek().getValue() - 1L) / 7L;
        return MathUtils.safeToInt(l);
    }

    public WeekOfWeekBasedYear getLastWeekOfWeekyear() {
        return WeekOfWeekBasedYear.weekOfWeekyear(this.lengthInWeeks());
    }

    @Override
    public int compareTo(WeekBasedYear weekBasedYear) {
        int n = this.weekyear;
        int n2 = weekBasedYear.weekyear;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean isAfter(WeekBasedYear weekBasedYear) {
        return this.compareTo(weekBasedYear) > 0;
    }

    public boolean isBefore(WeekBasedYear weekBasedYear) {
        return this.compareTo(weekBasedYear) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WeekBasedYear) {
            return this.weekyear == ((WeekBasedYear)object).weekyear;
        }
        return false;
    }

    public int hashCode() {
        return this.weekyear;
    }

    public String toString() {
        return "WeekBasedYear=" + this.getValue();
    }
}

