/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.time.calendar.Calendrical;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

class CompositePrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final DateTimePrinter[] printers;
    private final DateTimeParser[] parsers;
    private final boolean optional;

    CompositePrinterParser(List<DateTimePrinter> list, List<DateTimeParser> list2, boolean bl) {
        this.printers = list.contains(null) ? null : list.toArray(new DateTimePrinter[list.size()]);
        this.parsers = list2.contains(null) ? null : list2.toArray(new DateTimeParser[list2.size()]);
        this.optional = bl;
    }

    public CompositePrinterParser withOptional(boolean bl) {
        if (bl == this.optional) {
            return this;
        }
        return new CompositePrinterParser(Arrays.asList(this.printers), Arrays.asList(this.parsers), bl);
    }

    public boolean isPrintSupported() {
        return this.printers != null;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols dateTimeFormatSymbols) throws IOException {
        if (this.printers == null) {
            throw new UnsupportedOperationException("Formatter does not support printing");
        }
        if (this.optional) {
            for (DateTimePrinter dateTimePrinter : this.printers) {
                if (dateTimePrinter.isPrintDataAvailable(calendrical)) continue;
                return;
            }
        }
        for (DateTimePrinter dateTimePrinter : this.printers) {
            dateTimePrinter.print(calendrical, appendable, dateTimeFormatSymbols);
        }
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        if (this.optional) {
            return true;
        }
        for (DateTimePrinter dateTimePrinter : this.printers) {
            if (dateTimePrinter.isPrintDataAvailable(calendrical)) continue;
            return false;
        }
        return true;
    }

    public boolean isParseSupported() {
        return this.parsers != null;
    }

    @Override
    public int parse(DateTimeParseContext dateTimeParseContext, String string, int n) {
        DateTimeParser dateTimeParser;
        if (this.parsers == null) {
            throw new UnsupportedOperationException("Formatter does not support parsing");
        }
        if (this.optional) {
            dateTimeParseContext.startOptional();
            int n2 = n;
            for (DateTimeParser dateTimeParser2 : this.parsers) {
                if ((n2 = dateTimeParser2.parse(dateTimeParseContext, string, n2)) >= 0) continue;
                dateTimeParseContext.endOptional(false);
                return n;
            }
            dateTimeParseContext.endOptional(true);
            return n2;
        }
        DateTimeParser[] dateTimeParserArray = this.parsers;
        int n3 = dateTimeParserArray.length;
        for (int i = 0; i < n3 && (n = (dateTimeParser = dateTimeParserArray[i]).parse(dateTimeParseContext, string, n)) >= 0; ++i) {
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.printers != null) {
            stringBuilder.append(this.optional ? "[" : "(");
            for (DateTimePrinter dateTimePrinter : this.printers) {
                stringBuilder.append(dateTimePrinter);
            }
            stringBuilder.append(this.optional ? "]" : ")");
        }
        return stringBuilder.toString();
    }
}

