/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.UnsupportedCalendarFieldException;
import javax.time.calendar.format.CalendricalFormatException;
import javax.time.calendar.format.CalendricalFormatFieldException;
import javax.time.calendar.format.CalendricalParseException;
import javax.time.calendar.format.CompositePrinterParser;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.FormatUtil;

public class DateTimeFormatter {
    private final DateTimeFormatSymbols symbols;
    private final CompositePrinterParser printerParser;

    DateTimeFormatter(Locale locale, CompositePrinterParser compositePrinterParser) {
        this.symbols = DateTimeFormatSymbols.getInstance(locale);
        this.printerParser = compositePrinterParser;
    }

    private DateTimeFormatter(DateTimeFormatSymbols dateTimeFormatSymbols, CompositePrinterParser compositePrinterParser) {
        this.symbols = dateTimeFormatSymbols;
        this.printerParser = compositePrinterParser;
    }

    public Locale getLocale() {
        return this.symbols.getLocale();
    }

    public DateTimeFormatter withLocale(Locale locale) {
        FormatUtil.checkNotNull(locale, "locale");
        if (locale.equals(this.getLocale())) {
            return this;
        }
        DateTimeFormatSymbols dateTimeFormatSymbols = DateTimeFormatSymbols.getInstance(locale);
        return new DateTimeFormatter(dateTimeFormatSymbols, this.printerParser);
    }

    public boolean isPrintSupported() {
        return this.printerParser.isPrintSupported();
    }

    public String print(CalendricalProvider calendricalProvider) {
        StringBuilder stringBuilder = new StringBuilder(32);
        this.print(calendricalProvider, stringBuilder);
        return stringBuilder.toString();
    }

    public void print(CalendricalProvider calendricalProvider, Appendable appendable) {
        FormatUtil.checkNotNull(calendricalProvider, "calendrical provider");
        FormatUtil.checkNotNull(appendable, "appendable");
        Calendrical calendrical = calendricalProvider.toCalendrical();
        try {
            this.printerParser.print(calendrical, appendable, this.symbols);
        }
        catch (UnsupportedCalendarFieldException unsupportedCalendarFieldException) {
            throw new CalendricalFormatFieldException(unsupportedCalendarFieldException);
        }
        catch (IOException iOException) {
            throw new CalendricalFormatException(iOException.getMessage(), iOException);
        }
    }

    public boolean isParseSupported() {
        return this.printerParser.isParseSupported();
    }

    public Calendrical parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Calendrical calendrical = this.parse(string, parsePosition);
        if (parsePosition.getErrorIndex() >= 0 || parsePosition.getIndex() < string.length()) {
            String string2 = string;
            if (string2.length() > 64) {
                string2 = string2.substring(0, 64) + "...";
            }
            if (parsePosition.getErrorIndex() >= 0) {
                throw new CalendricalParseException("Text could not be parsed at index " + parsePosition.getErrorIndex() + ": " + string2, string, parsePosition.getErrorIndex());
            }
            throw new CalendricalParseException("Unparsed text found at index " + parsePosition.getIndex() + ": " + string2, string, parsePosition.getIndex());
        }
        return calendrical;
    }

    public Calendrical parse(String string, ParsePosition parsePosition) {
        FormatUtil.checkNotNull(string, "text to parse");
        FormatUtil.checkNotNull(parsePosition, "position to parse from");
        DateTimeParseContext dateTimeParseContext = new DateTimeParseContext(this.symbols);
        int n = parsePosition.getIndex();
        n = this.printerParser.parse(dateTimeParseContext, string, n);
        if (n < 0) {
            parsePosition.setErrorIndex(~n);
            return null;
        }
        parsePosition.setIndex(n);
        return dateTimeParseContext.asCalendrical();
    }

    CompositePrinterParser toPrinterParser(boolean bl) {
        return this.printerParser.withOptional(bl);
    }

    public Format toFormat() {
        return new ClassicFormat();
    }

    public String toString() {
        String string = this.printerParser.toString();
        return string.startsWith("[") ? string : string.substring(1, string.length() - 1);
    }

    private class ClassicFormat
    extends Format {
        private static final long serialVersionUID = 1L;

        private ClassicFormat() {
        }

        @Override
        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            FormatUtil.checkNotNull(object, "object to be printed");
            FormatUtil.checkNotNull(stringBuffer, "string buffer");
            FormatUtil.checkNotNull(fieldPosition, "field position");
            Calendrical calendrical = null;
            if (object instanceof CalendricalProvider) {
                calendrical = ((CalendricalProvider)object).toCalendrical();
                if (calendrical == null) {
                    throw new NullPointerException("The CalendricalProvider implementation must not return null");
                }
            } else {
                throw new IllegalArgumentException("DateTimeFormatter can format Calendrical instances");
            }
            fieldPosition.setBeginIndex(0);
            fieldPosition.setEndIndex(0);
            DateTimeFormatter.this.print(calendrical, stringBuffer);
            return stringBuffer;
        }

        @Override
        public Object parseObject(String string) throws ParseException {
            try {
                return DateTimeFormatter.this.parse(string);
            }
            catch (CalendricalParseException calendricalParseException) {
                throw new ParseException(calendricalParseException.getMessage(), calendricalParseException.getErrorIndex());
            }
        }

        @Override
        public Object parseObject(String string, ParsePosition parsePosition) {
            return DateTimeFormatter.this.parse(string, parsePosition);
        }
    }
}

