/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.format.CharLiteralPrinterParser;
import javax.time.calendar.format.CompositePrinterParser;
import javax.time.calendar.format.DateTimeFormatter;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;
import javax.time.calendar.format.FormatUtil;
import javax.time.calendar.format.FractionPrinterParser;
import javax.time.calendar.format.NumberPrinterParser;
import javax.time.calendar.format.PadPrinterParserDecorator;
import javax.time.calendar.format.StringLiteralPrinterParser;
import javax.time.calendar.format.TextPrinterParser;
import javax.time.calendar.format.ZoneOffsetPrinterParser;
import javax.time.calendar.format.ZonePrinterParser;

public class DateTimeFormatterBuilder {
    private final List<DateTimePrinter> printers = new ArrayList<DateTimePrinter>();
    private final List<DateTimeParser> parsers = new ArrayList<DateTimeParser>();
    private final List<Integer> optionalIndexStack = new ArrayList<Integer>();
    private int padNextWidth;
    private char padNextChar;
    private int valueParserIndex = -1;
    private static final Map<Character, DateTimeFieldRule> RULE_MAP = new HashMap<Character, DateTimeFieldRule>();

    static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    public DateTimeFormatterBuilder appendValue(DateTimeFieldRule dateTimeFieldRule) {
        DateTimeFormatterBuilder.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        NumberPrinterParser numberPrinterParser = new NumberPrinterParser(dateTimeFieldRule, 1, 10, SignStyle.NORMAL);
        this.valueParserIndex = this.appendInternal(numberPrinterParser, numberPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValue(DateTimeFieldRule dateTimeFieldRule, int n) {
        DateTimeFormatterBuilder.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException("The width must be from 1 to 10 inclusive but was " + n);
        }
        NumberPrinterParser numberPrinterParser = new NumberPrinterParser(dateTimeFieldRule, n, n, SignStyle.NOT_NEGATIVE);
        if (this.valueParserIndex >= 0) {
            NumberPrinterParser numberPrinterParser2 = (NumberPrinterParser)this.printers.get(this.valueParserIndex);
            numberPrinterParser2 = numberPrinterParser2.withSubsequentWidth(n);
            int n2 = this.valueParserIndex;
            this.printers.set(this.valueParserIndex, numberPrinterParser2);
            this.parsers.set(this.valueParserIndex, numberPrinterParser2);
            this.appendInternal(numberPrinterParser, numberPrinterParser);
            this.valueParserIndex = n2;
        } else {
            this.appendInternal(numberPrinterParser, numberPrinterParser);
        }
        return this;
    }

    public DateTimeFormatterBuilder appendValue(DateTimeFieldRule dateTimeFieldRule, int n, int n2, SignStyle signStyle) {
        if (n == n2 && signStyle == SignStyle.NOT_NEGATIVE) {
            return this.appendValue(dateTimeFieldRule, n2);
        }
        DateTimeFormatterBuilder.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        DateTimeFormatterBuilder.checkNotNull((Object)signStyle, "SignStyle must not be null");
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException("The minimum width must be from 1 to 10 inclusive but was " + n);
        }
        if (n2 < 1 || n2 > 10) {
            throw new IllegalArgumentException("The maximum width must be from 1 to 10 inclusive but was " + n2);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("The maximum width must exceed or equal the minimum width but " + n2 + " < " + n);
        }
        NumberPrinterParser numberPrinterParser = new NumberPrinterParser(dateTimeFieldRule, n, n2, signStyle);
        if (n == n2) {
            this.appendInternal(numberPrinterParser, numberPrinterParser);
        } else {
            this.valueParserIndex = this.appendInternal(numberPrinterParser, numberPrinterParser);
        }
        return this;
    }

    public DateTimeFormatterBuilder appendFraction(DateTimeFieldRule dateTimeFieldRule, int n, int n2) {
        DateTimeFormatterBuilder.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        if (!dateTimeFieldRule.isFixedValueSet()) {
            throw new IllegalArgumentException("The field does not have a fixed set of values");
        }
        if (dateTimeFieldRule.getMinimumValue() != 0) {
            throw new IllegalArgumentException("The field does not have a minimum value of zero");
        }
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("The minimum width must be from 0 to 9 inclusive but was " + n);
        }
        if (n2 < 1 || n2 > 9) {
            throw new IllegalArgumentException("The maximum width must be from 1 to 9 inclusive but was " + n2);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("The maximum width must exceed or equal the minimum width but " + n2 + " < " + n);
        }
        FractionPrinterParser fractionPrinterParser = new FractionPrinterParser(dateTimeFieldRule, n, n2);
        this.appendInternal(fractionPrinterParser, fractionPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendText(DateTimeFieldRule dateTimeFieldRule) {
        return this.appendText(dateTimeFieldRule, TextStyle.FULL);
    }

    public DateTimeFormatterBuilder appendText(DateTimeFieldRule dateTimeFieldRule, TextStyle textStyle) {
        DateTimeFormatterBuilder.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        DateTimeFormatterBuilder.checkNotNull((Object)textStyle, "TextStyle must not be null");
        TextPrinterParser textPrinterParser = new TextPrinterParser(dateTimeFieldRule, textStyle);
        this.appendInternal(textPrinterParser, textPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendOffsetId() {
        return this.appendOffset("Z", true, true);
    }

    public DateTimeFormatterBuilder appendOffset(String string, boolean bl, boolean bl2) {
        DateTimeFormatterBuilder.checkNotNull(string, "UTC text must not be null");
        ZoneOffsetPrinterParser zoneOffsetPrinterParser = new ZoneOffsetPrinterParser(string, bl, bl2);
        this.appendInternal(zoneOffsetPrinterParser, zoneOffsetPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendZoneId() {
        ZonePrinterParser zonePrinterParser = new ZonePrinterParser();
        this.appendInternal(zonePrinterParser, zonePrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendZoneText(TextStyle textStyle) {
        DateTimeFormatterBuilder.checkNotNull((Object)textStyle, "TextStyle must not be null");
        ZonePrinterParser zonePrinterParser = new ZonePrinterParser(textStyle);
        this.appendInternal(zonePrinterParser, zonePrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(char c) {
        CharLiteralPrinterParser charLiteralPrinterParser = new CharLiteralPrinterParser(c);
        this.appendInternal(charLiteralPrinterParser, charLiteralPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(String string) {
        DateTimeFormatterBuilder.checkNotNull(string, "Literal text must not be null");
        if (string.length() > 0) {
            if (string.length() == 1) {
                CharLiteralPrinterParser charLiteralPrinterParser = new CharLiteralPrinterParser(string.charAt(0));
                this.appendInternal(charLiteralPrinterParser, charLiteralPrinterParser);
            } else {
                StringLiteralPrinterParser stringLiteralPrinterParser = new StringLiteralPrinterParser(string);
                this.appendInternal(stringLiteralPrinterParser, stringLiteralPrinterParser);
            }
        }
        return this;
    }

    public DateTimeFormatterBuilder append(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser) {
        if (dateTimePrinter == null && dateTimeParser == null) {
            throw new NullPointerException("One of DateTimePrinter or DateTimeParser must be non-null");
        }
        this.appendInternal(dateTimePrinter, dateTimeParser);
        return this;
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter dateTimeFormatter) {
        DateTimeFormatterBuilder.checkNotNull(dateTimeFormatter, "DateTimeFormatter must not be null");
        CompositePrinterParser compositePrinterParser = dateTimeFormatter.toPrinterParser(false);
        this.appendInternal(compositePrinterParser, compositePrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeFormatter dateTimeFormatter) {
        DateTimeFormatterBuilder.checkNotNull(dateTimeFormatter, "DateTimeFormatter must not be null");
        CompositePrinterParser compositePrinterParser = dateTimeFormatter.toPrinterParser(true);
        this.appendInternal(compositePrinterParser, compositePrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendPattern(String string) {
        DateTimeFormatterBuilder.checkNotNull(string, "Pattern must not be null");
        this.parsePattern(string);
        return this;
    }

    private void parsePattern(String string) {
        for (int i = 0; i < string.length(); ++i) {
            int n;
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                DateTimeFieldRule dateTimeFieldRule;
                int n2;
                n = i++;
                while (i < string.length() && string.charAt(i) == c) {
                    ++i;
                }
                int n3 = i - n;
                if (c == 'p') {
                    n2 = 0;
                    if (i < string.length() && ((c = string.charAt(i)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                        n2 = n3;
                        n = i++;
                        while (i < string.length() && string.charAt(i) == c) {
                            ++i;
                        }
                        n3 = i - n;
                    }
                    if (n2 == 0) {
                        throw new IllegalArgumentException("Pad letter 'p' must be followed by valid pad pattern: " + string);
                    }
                    this.padNext(n2);
                }
                n2 = 0;
                if (c == 'f') {
                    if (i < string.length() && ((c = string.charAt(i)) == 'H' || c == 'K' || c == 'm' || c == 's' || c == 'S' || c == 'n')) {
                        n2 = n3;
                        n = i++;
                        while (i < string.length() && string.charAt(i) == c) {
                            ++i;
                        }
                        n3 = i - n;
                    }
                    if (n2 == 0) {
                        throw new IllegalArgumentException("Fraction letter 'f' must be followed by valid fraction pattern: " + string);
                    }
                }
                if ((dateTimeFieldRule = RULE_MAP.get(Character.valueOf(c))) == null) {
                    if (c == 'z') {
                        if (n3 < 4) {
                            this.appendZoneText(TextStyle.SHORT);
                        } else {
                            this.appendZoneText(TextStyle.FULL);
                        }
                    } else if (c == 'I') {
                        this.appendZoneId();
                    } else if (c == 'Z') {
                        this.appendOffset(n3 == 1 ? "+0000" : (n3 == 2 ? "+00:00" : "Z"), n3 == 2 || n3 >= 4, n3 >= 3);
                    } else {
                        this.appendLiteral(string.substring(n, i));
                    }
                } else {
                    this.parseRule(c, n3, dateTimeFieldRule, n2);
                }
                n2 = 0;
                --i;
                continue;
            }
            if (c == '\'') {
                n = i++;
                while (i < string.length()) {
                    if (string.charAt(i) == '\'') {
                        if (i + 1 >= string.length() || string.charAt(i + 1) != '\'') break;
                        ++i;
                    }
                    ++i;
                }
                if (i >= string.length()) {
                    throw new IllegalArgumentException("Pattern ends with an incomplete string literal: " + string);
                }
                String string2 = string.substring(n + 1, i);
                if (string2.length() == 0) {
                    this.appendLiteral('\'');
                    continue;
                }
                this.appendLiteral(string2.replace("''", "'"));
                continue;
            }
            if (c == '[') {
                this.optionalStart();
                continue;
            }
            if (c == ']') {
                if (this.optionalIndexStack.isEmpty()) {
                    throw new IllegalArgumentException("Pattern invalid as it contains ] without previous [");
                }
                this.optionalEnd();
                continue;
            }
            this.appendLiteral(c);
        }
    }

    private void parseRule(char c, int n, DateTimeFieldRule dateTimeFieldRule, int n2) {
        block0 : switch (c) {
            case 'x': 
            case 'y': {
                if (n < 4) {
                    this.appendValue(dateTimeFieldRule, n, 10, SignStyle.NORMAL);
                    break;
                }
                this.appendValue(dateTimeFieldRule, n, 10, SignStyle.EXCEEDS_PAD);
                break;
            }
            case 'M': {
                switch (n) {
                    case 1: {
                        this.appendValue(dateTimeFieldRule);
                        break block0;
                    }
                    case 2: {
                        this.appendValue(dateTimeFieldRule, 2);
                        break block0;
                    }
                    case 3: {
                        this.appendText(dateTimeFieldRule, TextStyle.SHORT);
                        break block0;
                    }
                }
                this.appendText(dateTimeFieldRule, TextStyle.FULL);
                break;
            }
            case 'E': 
            case 'a': {
                if (n < 4) {
                    this.appendText(dateTimeFieldRule, TextStyle.SHORT);
                    break;
                }
                this.appendText(dateTimeFieldRule, TextStyle.FULL);
                break;
            }
            default: {
                if (n2 > 0) {
                    this.appendFraction(dateTimeFieldRule, n, n2 == 1 ? n : 9);
                    break;
                }
                if (n == 1) {
                    this.appendValue(dateTimeFieldRule);
                    break;
                }
                this.appendValue(dateTimeFieldRule, n);
            }
        }
    }

    public DateTimeFormatterBuilder padNext(int n) {
        return this.padNext(n, ' ');
    }

    public DateTimeFormatterBuilder padNext(int n, char c) {
        if (n < 1) {
            throw new IllegalArgumentException("The pad width must be at least one but was " + n);
        }
        this.padNextWidth = n;
        this.padNextChar = c;
        this.valueParserIndex = -1;
        return this;
    }

    public DateTimeFormatterBuilder optionalStart() {
        this.optionalIndexStack.add(this.printers.size());
        this.valueParserIndex = -1;
        return this;
    }

    public DateTimeFormatterBuilder optionalEnd() {
        if (this.optionalIndexStack.isEmpty()) {
            throw new IllegalStateException("Cannot call optionalEnd() as there was no previous call to optionalStart()");
        }
        int n = this.optionalIndexStack.remove(this.optionalIndexStack.size() - 1);
        if (n < this.printers.size()) {
            this.optionalEnd(n, this.printers, this.parsers);
        }
        return this;
    }

    private void optionalEnd(int n, List<DateTimePrinter> list, List<DateTimeParser> list2) {
        List<DateTimePrinter> list3 = list.subList(n, list.size());
        List<DateTimeParser> list4 = list2.subList(n, list2.size());
        CompositePrinterParser compositePrinterParser = new CompositePrinterParser(list3, list4, true);
        list3.clear();
        list4.clear();
        list.add(compositePrinterParser.isPrintSupported() ? compositePrinterParser : null);
        list2.add(compositePrinterParser.isParseSupported() ? compositePrinterParser : null);
    }

    private int appendInternal(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser) {
        if (this.padNextWidth > 0) {
            if (dateTimePrinter != null || dateTimeParser != null) {
                dateTimePrinter = new PadPrinterParserDecorator(dateTimePrinter, dateTimeParser, this.padNextWidth, this.padNextChar);
            }
            this.padNextWidth = 0;
            this.padNextChar = '\u0000';
        }
        this.printers.add(dateTimePrinter);
        this.parsers.add(dateTimeParser);
        this.valueParserIndex = -1;
        return this.printers.size() - 1;
    }

    public DateTimeFormatter toFormatter() {
        return this.toFormatter(Locale.getDefault());
    }

    public DateTimeFormatter toFormatter(Locale locale) {
        FormatUtil.checkNotNull(locale, "locale");
        if (this.optionalIndexStack.size() > 0) {
            ArrayList<DateTimePrinter> arrayList = new ArrayList<DateTimePrinter>(this.printers);
            ArrayList<DateTimeParser> arrayList2 = new ArrayList<DateTimeParser>(this.parsers);
            for (int i = this.optionalIndexStack.size() - 1; i >= 0; --i) {
                int n = this.optionalIndexStack.get(i);
                this.optionalEnd(n, arrayList, arrayList2);
            }
            return new DateTimeFormatter(locale, new CompositePrinterParser(arrayList, arrayList2, false));
        }
        return new DateTimeFormatter(locale, new CompositePrinterParser(this.printers, this.parsers, false));
    }

    static {
        RULE_MAP.put(Character.valueOf('y'), ISOChronology.yearRule());
        RULE_MAP.put(Character.valueOf('x'), ISOChronology.weekBasedYearRule());
        RULE_MAP.put(Character.valueOf('Q'), ISOChronology.quarterOfYearRule());
        RULE_MAP.put(Character.valueOf('M'), ISOChronology.monthOfYearRule());
        RULE_MAP.put(Character.valueOf('q'), ISOChronology.monthOfQuarterRule());
        RULE_MAP.put(Character.valueOf('w'), ISOChronology.weekOfWeekBasedYearRule());
        RULE_MAP.put(Character.valueOf('D'), ISOChronology.dayOfYearRule());
        RULE_MAP.put(Character.valueOf('d'), ISOChronology.dayOfMonthRule());
        RULE_MAP.put(Character.valueOf('F'), ISOChronology.weekOfMonthRule());
        RULE_MAP.put(Character.valueOf('E'), ISOChronology.dayOfWeekRule());
        RULE_MAP.put(Character.valueOf('e'), ISOChronology.dayOfWeekRule());
        RULE_MAP.put(Character.valueOf('a'), ISOChronology.amPmOfDayRule());
        RULE_MAP.put(Character.valueOf('H'), ISOChronology.hourOfDayRule());
        RULE_MAP.put(Character.valueOf('K'), ISOChronology.hourOfAmPmRule());
        RULE_MAP.put(Character.valueOf('m'), ISOChronology.minuteOfHourRule());
        RULE_MAP.put(Character.valueOf('s'), ISOChronology.secondOfMinuteRule());
        RULE_MAP.put(Character.valueOf('S'), ISOChronology.milliOfSecondRule());
        RULE_MAP.put(Character.valueOf('n'), ISOChronology.nanoOfSecondRule());
    }

    public static enum TextStyle {
        NARROW,
        SHORT,
        FULL;

    }

    public static enum SignStyle {
        NORMAL,
        ALWAYS,
        NEVER,
        NOT_NEGATIVE,
        EXCEEDS_PAD;

    }
}

