/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;

class NumberParser
implements DateTimeParser {
    private final DateTimeFieldRule fieldRule;
    private final int minWidth;
    private final int maxWidth;
    private final char padChar;
    private final boolean padOnLeft;
    private final DateTimeFormatterBuilder.SignStyle signStyle;

    public NumberParser(DateTimeFieldRule dateTimeFieldRule) {
        this(dateTimeFieldRule, 0, Integer.MAX_VALUE, '0', true, DateTimeFormatterBuilder.SignStyle.NORMAL);
    }

    NumberParser(DateTimeFieldRule dateTimeFieldRule, int n, int n2, char c, boolean bl, DateTimeFormatterBuilder.SignStyle signStyle) {
        this.fieldRule = dateTimeFieldRule;
        this.minWidth = n;
        this.maxWidth = n2;
        this.padChar = c;
        this.padOnLeft = bl;
        this.signStyle = signStyle;
    }

    @Override
    public int parse(DateTimeParseContext dateTimeParseContext, String string, int n) {
        char c;
        char c2;
        int n2 = n + this.minWidth;
        int n3 = string.length();
        if (n2 > n3) {
            return ~n;
        }
        int n4 = 0;
        if (this.minWidth > 1) {
            while (n < n2 - 1 && (c2 = (char)string.charAt(n)) == this.padChar) {
                ++n;
            }
        }
        while (n < n2) {
            if ((c = dateTimeParseContext.digit(c2 = string.charAt(n++))) < '\u0000') {
                return ~(n - 1);
            }
            n4 *= 10;
            n4 += c;
        }
        c2 = n + this.maxWidth;
        while (n < c2) {
            int n5;
            if ((n5 = dateTimeParseContext.digit(c = (char)string.charAt(n++))) < 0) {
                --n;
                break;
            }
            n4 *= 10;
            n4 += n5;
        }
        dateTimeParseContext.setFieldValue(this.fieldRule, n4);
        return n;
    }
}

