/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.format.CalendricalFormatFieldException;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;
import javax.time.calendar.format.FormatUtil;

class NumberPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private static final int[] EXCEED_POINTS = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private final DateTimeFieldRule fieldRule;
    private final int minWidth;
    private final int maxWidth;
    private final DateTimeFormatterBuilder.SignStyle signStyle;
    private final int subsequentWidth;

    NumberPrinterParser(DateTimeFieldRule dateTimeFieldRule, int n, int n2, DateTimeFormatterBuilder.SignStyle signStyle) {
        this.fieldRule = dateTimeFieldRule;
        this.minWidth = n;
        this.maxWidth = n2;
        this.signStyle = signStyle;
        this.subsequentWidth = 0;
    }

    private NumberPrinterParser(DateTimeFieldRule dateTimeFieldRule, int n, int n2, DateTimeFormatterBuilder.SignStyle signStyle, int n3) {
        this.fieldRule = dateTimeFieldRule;
        this.minWidth = n;
        this.maxWidth = n2;
        this.signStyle = signStyle;
        this.subsequentWidth = n3;
    }

    NumberPrinterParser withSubsequentWidth(int n) {
        return new NumberPrinterParser(this.fieldRule, this.minWidth, this.maxWidth, this.signStyle, this.subsequentWidth + n);
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols dateTimeFormatSymbols) throws IOException {
        String string;
        int n = calendrical.deriveValue(this.fieldRule);
        String string2 = string = n == Integer.MIN_VALUE ? "2147483648" : Integer.toString(Math.abs(n));
        if (string.length() > this.maxWidth) {
            throw new CalendricalFormatFieldException(this.fieldRule, n, this.maxWidth);
        }
        string = FormatUtil.convertToI18N(string, dateTimeFormatSymbols);
        if (n >= 0) {
            switch (this.signStyle) {
                case EXCEEDS_PAD: {
                    if (this.minWidth >= 10 || n < EXCEED_POINTS[this.minWidth]) break;
                    appendable.append(dateTimeFormatSymbols.getPositiveSignChar());
                    break;
                }
                case ALWAYS: {
                    appendable.append(dateTimeFormatSymbols.getPositiveSignChar());
                }
            }
        } else {
            switch (this.signStyle) {
                case EXCEEDS_PAD: 
                case ALWAYS: 
                case NORMAL: {
                    appendable.append(dateTimeFormatSymbols.getNegativeSignChar());
                    break;
                }
                case NOT_NEGATIVE: {
                    throw new CalendricalFormatFieldException(this.fieldRule, n);
                }
            }
        }
        for (int i = 0; i < this.minWidth - string.length(); ++i) {
            appendable.append(dateTimeFormatSymbols.getZeroChar());
        }
        appendable.append(string);
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return calendrical.isDerivable(this.fieldRule);
    }

    @Override
    public int parse(DateTimeParseContext dateTimeParseContext, String string, int n) {
        int n2;
        boolean bl;
        boolean bl2;
        int n3;
        block22: {
            block23: {
                char c;
                block21: {
                    n3 = string.length();
                    if (n == n3) {
                        return ~n;
                    }
                    c = string.charAt(n);
                    bl2 = false;
                    bl = false;
                    if (c != dateTimeParseContext.getSymbols().getPositiveSignChar()) break block21;
                    bl = true;
                    switch (this.signStyle) {
                        case EXCEEDS_PAD: 
                        case ALWAYS: {
                            ++n;
                            break block22;
                        }
                        default: {
                            return ~n;
                        }
                    }
                }
                if (c != dateTimeParseContext.getSymbols().getNegativeSignChar()) break block23;
                bl2 = true;
                switch (this.signStyle) {
                    case EXCEEDS_PAD: 
                    case ALWAYS: 
                    case NORMAL: {
                        ++n;
                        break block22;
                    }
                    default: {
                        return ~n;
                    }
                }
            }
            if (this.signStyle == DateTimeFormatterBuilder.SignStyle.ALWAYS) {
                return ~n;
            }
        }
        int n4 = n + this.minWidth;
        if (n4 > n3) {
            return ~n;
        }
        int n5 = this.maxWidth + this.subsequentWidth;
        long l = 0L;
        int n6 = n;
        for (n2 = 0; n2 < 2; ++n2) {
            int n7;
            int n8 = Math.min(n6 + n5, n3);
            while (n6 < n8) {
                n7 = string.charAt(n6++);
                int n9 = dateTimeParseContext.getSymbols().convertToDigit((char)n7);
                if (n9 < 0) {
                    if (--n6 >= n4) break;
                    return ~n;
                }
                l = l * 10L + (long)n9;
            }
            if (this.subsequentWidth <= 0 || n2 != 0) break;
            n7 = n6 - n;
            n5 = Math.max(this.minWidth, n7 - this.subsequentWidth);
            n6 = n;
            l = 0L;
        }
        if (bl2) {
            if (l == 0L) {
                return ~(n - 1);
            }
            l = -l;
        } else if (this.signStyle == DateTimeFormatterBuilder.SignStyle.EXCEEDS_PAD) {
            n2 = n6 - n;
            if (bl) {
                if (n2 <= this.minWidth) {
                    return ~(n - 1);
                }
            } else if (n2 > this.minWidth) {
                return ~n;
            }
        }
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            l /= 10L;
            --n6;
        }
        dateTimeParseContext.setFieldValue(this.fieldRule, (int)l);
        return n6;
    }

    public String toString() {
        if (this.minWidth == 1 && this.maxWidth == 10 && this.signStyle == DateTimeFormatterBuilder.SignStyle.NORMAL) {
            return "Value(" + this.fieldRule.getID() + ")";
        }
        if (this.minWidth == this.maxWidth && this.signStyle == DateTimeFormatterBuilder.SignStyle.NOT_NEGATIVE) {
            return "Value(" + this.fieldRule.getID() + "," + this.minWidth + ")";
        }
        return "Value(" + this.fieldRule.getID() + "," + this.minWidth + "," + this.maxWidth + "," + (Object)((Object)this.signStyle) + ")";
    }
}

