/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.util.List;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.zone.FixedZoneRules;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneOffsetTransitionRule;
import javax.time.calendar.zone.ZoneRulesBuilder;
import javax.time.period.Period;

public abstract class ZoneRules {
    private static final long serialVersionUID = 93618758758127L;

    public static ZoneRules fixed(ZoneOffset zoneOffset) {
        return new FixedZoneRules(zoneOffset);
    }

    static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    protected ZoneRules() {
    }

    public boolean isFixedOffset() {
        return false;
    }

    public abstract ZoneOffset getOffset(InstantProvider var1);

    public OffsetInfo getOffsetInfo(Instant instant) {
        ZoneOffset zoneOffset = this.getOffset(instant);
        OffsetDateTime offsetDateTime = OffsetDateTime.fromInstant(instant, zoneOffset);
        return this.getOffsetInfo(offsetDateTime.toLocalDateTime());
    }

    public abstract OffsetInfo getOffsetInfo(LocalDateTime var1);

    public abstract ZoneOffset getStandardOffset(InstantProvider var1);

    public Period getDaylightSavings(InstantProvider instantProvider) {
        Instant instant = Instant.instant(instantProvider);
        ZoneOffset zoneOffset = this.getStandardOffset(instant);
        ZoneOffset zoneOffset2 = this.getOffset(instant);
        return zoneOffset2.toPeriod().minus(zoneOffset.toPeriod()).normalized();
    }

    public boolean isDaylightSavings(InstantProvider instantProvider) {
        return !this.getStandardOffset(instantProvider).equals(this.getOffset(instantProvider));
    }

    public abstract ZoneOffsetTransition nextTransition(InstantProvider var1);

    public abstract ZoneOffsetTransition previousTransition(InstantProvider var1);

    public abstract List<ZoneOffsetTransition> getTransitions();

    public abstract List<ZoneOffsetTransitionRule> getTransitionRules();

    public boolean isValidDateTime(OffsetDateTime offsetDateTime) {
        OffsetInfo offsetInfo = this.getOffsetInfo(offsetDateTime.getDateTime());
        return offsetInfo.isValidOffset(offsetDateTime.getOffset());
    }

    protected OffsetInfo createOffsetInfo(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        ZoneRules.checkNotNull(localDateTime, "LocalDateTime must not be null");
        ZoneRules.checkNotNull(zoneOffset, "ZoneOffset must not be null");
        return new OffsetInfo(localDateTime, zoneOffset);
    }

    protected OffsetInfo createOffsetInfo(LocalDateTime localDateTime, OffsetDateTime offsetDateTime, ZoneOffset zoneOffset) {
        ZoneRules.checkNotNull(localDateTime, "LocalDateTime must not be null");
        ZoneRules.checkNotNull(offsetDateTime, "OffsetDateTime must not be null");
        ZoneRules.checkNotNull(zoneOffset, "ZoneOffset must not be null");
        return new OffsetInfo(localDateTime, offsetDateTime, zoneOffset);
    }

    protected ZoneOffsetTransition createTransition(OffsetDateTime offsetDateTime, ZoneOffset zoneOffset) {
        return new ZoneOffsetTransition(offsetDateTime, zoneOffset);
    }

    protected ZoneOffsetTransitionRule createTransitionRule(MonthOfYear monthOfYear, int n, DayOfWeek dayOfWeek, LocalTime localTime, ZoneRulesBuilder.TimeDefinition timeDefinition, ZoneOffset zoneOffset, ZoneOffset zoneOffset2, ZoneOffset zoneOffset3) {
        return new ZoneOffsetTransitionRule(monthOfYear, n, dayOfWeek, localTime, timeDefinition, zoneOffset, zoneOffset2, zoneOffset3);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static final class OffsetInfo {
        private final LocalDateTime dateTime;
        private final ZoneOffset offset;
        private final ZoneOffsetTransition discontinuity;

        OffsetInfo(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
            this.dateTime = localDateTime;
            this.offset = zoneOffset;
            this.discontinuity = null;
        }

        OffsetInfo(LocalDateTime localDateTime, OffsetDateTime offsetDateTime, ZoneOffset zoneOffset) {
            this.dateTime = localDateTime;
            this.offset = null;
            this.discontinuity = new ZoneOffsetTransition(offsetDateTime, zoneOffset);
        }

        public LocalDateTime getLocalDateTime() {
            return this.dateTime;
        }

        public boolean isDiscontinuity() {
            return this.discontinuity != null;
        }

        public ZoneOffset getOffset() {
            return this.offset;
        }

        public ZoneOffsetTransition getDiscontinuity() {
            return this.discontinuity;
        }

        public ZoneOffset getEstimatedOffset() {
            return this.isDiscontinuity() ? this.getDiscontinuity().getOffsetAfter() : this.offset;
        }

        public boolean isValidOffset(ZoneOffset zoneOffset) {
            return this.isDiscontinuity() ? this.discontinuity.isValidOffset(zoneOffset) : this.offset.equals(zoneOffset);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("OffsetInfo[").append(this.isDiscontinuity() ? this.discontinuity : this.offset).append(']');
            return stringBuilder.toString();
        }
    }
}

