/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.time.CalendricalException;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.zone.JarZoneRulesDataProvider;
import javax.time.calendar.zone.ZoneRules;
import javax.time.calendar.zone.ZoneRulesDataProvider;

public final class ZoneRulesGroup {
    private static final Set<String> IDS = new CopyOnWriteArraySet<String>();
    private static final ConcurrentMap<String, ZoneRulesGroup> GROUPS = new ConcurrentHashMap<String, ZoneRulesGroup>(16, 0.75f, 2);
    private final String groupID;
    private final ConcurrentMap<String, TreeMap<String, ZoneRulesDataProvider>> regions = new ConcurrentHashMap<String, TreeMap<String, ZoneRulesDataProvider>>(100, 0.75f, 2);

    public static boolean isValidGroup(String string) {
        if (string == null) {
            return false;
        }
        return GROUPS.containsKey(string);
    }

    public static ZoneRulesGroup getGroup(String string) {
        ZoneRules.checkNotNull(string, "Group ID must not be null");
        ZoneRulesGroup zoneRulesGroup = (ZoneRulesGroup)GROUPS.get(string);
        if (zoneRulesGroup == null) {
            throw new CalendricalException("Unknown time zone group ID: " + string);
        }
        return zoneRulesGroup;
    }

    public static List<ZoneRulesGroup> getAvailableGroups() {
        return new ArrayList<ZoneRulesGroup>(GROUPS.values());
    }

    public static Set<String> getParsableIDs() {
        return Collections.unmodifiableSet(IDS);
    }

    public static synchronized void registerProvider(ZoneRulesDataProvider zoneRulesDataProvider) {
        ZoneRulesGroup zoneRulesGroup = (ZoneRulesGroup)GROUPS.get(zoneRulesDataProvider.getGroupID());
        if (zoneRulesGroup == null) {
            zoneRulesGroup = new ZoneRulesGroup(zoneRulesDataProvider.getGroupID());
            GROUPS.put(zoneRulesDataProvider.getGroupID(), zoneRulesGroup);
        }
        zoneRulesGroup.registerProvider0(zoneRulesDataProvider);
    }

    private ZoneRulesGroup(String string) {
        if (string == null) {
            throw new NullPointerException("Group ID must not be null");
        }
        if (!string.matches("[A-Za-z0-9._-]+")) {
            throw new CalendricalException("Group ID must only contain alphanumerics, dot, underscore and dash");
        }
        this.groupID = string;
    }

    private synchronized void registerProvider0(ZoneRulesDataProvider zoneRulesDataProvider) {
        Set<String> set = zoneRulesDataProvider.getIDs();
        HashSet<String> hashSet = new HashSet<String>(set.size());
        HashSet<String[]> hashSet2 = new HashSet<String[]>(set.size());
        for (String stringArray : set) {
            TreeMap treeMap;
            int n = stringArray.indexOf(35);
            String string = stringArray;
            String string2 = "";
            if (n >= 0) {
                string = stringArray.substring(0, n);
                string2 = stringArray.substring(n + 1);
            }
            if ((treeMap = (TreeMap)this.regions.get(string)) != null) {
                if (string2.length() > 0 && treeMap.containsKey("")) {
                    throw new CalendricalException("Cannot register versioned provider '" + this.groupID + ":" + string + "#" + string2 + "' as an unversioned provider '" + this.groupID + ":" + string + "' is already registered");
                }
                if (treeMap.containsKey(string2)) {
                    throw new CalendricalException("Cannot register provider '" + this.groupID + ":" + string + "#" + string2 + "' as one is already registered with that ID");
                }
            }
            hashSet2.add(new String[]{string, string2});
            if (this.groupID.equals("TZDB")) {
                hashSet.add(stringArray);
                hashSet.add(string);
            }
            hashSet.add(this.groupID + ':' + stringArray);
            hashSet.add(this.groupID + ':' + string);
        }
        for (String[] stringArray : hashSet2) {
            TreeMap<String, ZoneRulesDataProvider> treeMap = new TreeMap<String, ZoneRulesDataProvider>();
            treeMap.put(stringArray[1], zoneRulesDataProvider);
            if ((treeMap = this.regions.putIfAbsent(stringArray[0], treeMap)) == null) continue;
            ((TreeMap)this.regions.get(stringArray[0])).put(stringArray[1], zoneRulesDataProvider);
        }
        IDS.addAll(hashSet);
    }

    private TreeMap<String, ZoneRulesDataProvider> getVersions(String string) {
        TreeMap treeMap = (TreeMap)this.regions.get(string);
        if (treeMap == null) {
            throw new CalendricalException("Unknown time zone region: " + this.groupID + ":" + string);
        }
        return treeMap;
    }

    public String getID() {
        return this.groupID;
    }

    public boolean isValidRules(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        TreeMap treeMap = (TreeMap)this.regions.get(string);
        return treeMap != null && (string2.length() == 0 || treeMap.containsKey(string2));
    }

    public ZoneRules getRules(String string, String string2) {
        ZoneRulesDataProvider zoneRulesDataProvider;
        ZoneRules.checkNotNull(string, "Region ID must not be null");
        ZoneRules.checkNotNull(string2, "Version ID must not be null");
        TreeMap<String, ZoneRulesDataProvider> treeMap = this.getVersions(string);
        if (string2.length() == 0) {
            string2 = treeMap.lastKey();
            zoneRulesDataProvider = treeMap.get(string2);
        } else {
            zoneRulesDataProvider = treeMap.get(string2);
            if (zoneRulesDataProvider == null) {
                throw new CalendricalException("Unknown time zone version: " + this.groupID + ":" + string + (string2.length() == 0 ? "" : "#" + string2));
            }
        }
        return zoneRulesDataProvider.getZoneRules(string, string2);
    }

    public boolean isValidRulesFor(String string, String string2, OffsetDateTime offsetDateTime) {
        if (string == null || string2 == null || offsetDateTime == null) {
            return false;
        }
        try {
            this.getRulesValidFor(string, string2, offsetDateTime);
            return true;
        }
        catch (CalendricalException calendricalException) {
            return false;
        }
    }

    public ZoneRules getRulesValidFor(String string, String string2, OffsetDateTime offsetDateTime) {
        ZoneRules.checkNotNull(string, "Region ID must not be null");
        ZoneRules.checkNotNull(string2, "Version ID must not be null");
        ZoneRules.checkNotNull(offsetDateTime, "Valid date-time must not be null");
        if (string2.length() > 0) {
            ZoneRules zoneRules = this.getRules(string, string2);
            if (!zoneRules.isValidDateTime(offsetDateTime)) {
                throw new CalendricalException("Rules in time zone " + this.groupID + ":" + string + "#" + string2 + " are invalid for date-time " + offsetDateTime);
            }
            return zoneRules;
        }
        string2 = this.getLatestVersionIDValidFor(string, offsetDateTime);
        return this.getRules(string, string2);
    }

    public String getLatestVersionIDValidFor(String string, OffsetDateTime offsetDateTime) {
        ZoneRules.checkNotNull(string, "Region ID must not be null");
        ZoneRules.checkNotNull(offsetDateTime, "OffsetDateTime must not be null");
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        treeMap.putAll(this.getVersions(string));
        for (Map.Entry entry : treeMap.entrySet()) {
            ZoneRulesDataProvider zoneRulesDataProvider = (ZoneRulesDataProvider)entry.getValue();
            ZoneRules zoneRules = zoneRulesDataProvider.getZoneRules(string, (String)entry.getKey());
            if (!zoneRules.isValidDateTime(offsetDateTime)) continue;
            return (String)entry.getKey();
        }
        throw new CalendricalException("No rules could be found in time zone " + this.groupID + ":" + string + " that are valid for date-time " + offsetDateTime);
    }

    public List<String> getAvailableRegionIDs() {
        ArrayList<String> arrayList = new ArrayList<String>(this.regions.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<String> getAvailableRegionIDs(String string) {
        ZoneRules.checkNotNull(string, "Version ID must not be null");
        if (string.length() == 0) {
            return this.getAvailableRegionIDs();
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : this.regions.entrySet()) {
            if (!((TreeMap)entry.getValue()).containsKey(string)) continue;
            hashSet.add(entry.getKey());
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    public String getLatestVersionID(String string) {
        ZoneRules.checkNotNull(string, "Region ID must not be null");
        TreeMap<String, ZoneRulesDataProvider> treeMap = this.getVersions(string);
        return treeMap.lastKey();
    }

    public List<String> getAvailableVersionIDs(String string) {
        ZoneRules.checkNotNull(string, "Region ID must not be null");
        TreeMap<String, ZoneRulesDataProvider> treeMap = this.getVersions(string);
        return new ArrayList<String>(treeMap.keySet());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZoneRulesGroup) {
            return this.groupID.equals(((ZoneRulesGroup)object).groupID);
        }
        return false;
    }

    public int hashCode() {
        return this.groupID.hashCode();
    }

    public String toString() {
        return this.groupID;
    }

    static {
        JarZoneRulesDataProvider.load();
    }
}

